/*
 * Decompiled with CFR 0.152.
 */
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.xerces.dom3.DOMImplementationRegistry;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.TreeWalker;

public class TDocumentImpl
implements TDocument {
    boolean mode_set = false;
    short time_mode;
    String date_format;
    Date cur_instant;
    Period seq_extent;
    Document doc;
    Element doc_root = null;
    NodeList children = null;
    SimpleDateFormat sdf = null;
    int cur_verid;

    public TDocumentImpl(String string) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            DOMImplementation dOMImplementation = documentBuilder.getDOMImplementation();
            this.doc = dOMImplementation.createDocument(null, string, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.time_mode = (short)-1;
        this.date_format = null;
        this.cur_verid = 0;
        this.doc_root = null;
    }

    public TDocumentImpl(Document document) {
        this.doc = document;
        this.time_mode = (short)-1;
        this.date_format = null;
        try {
            this.cur_verid = Integer.parseInt(document.getDocumentElement().getAttribute("cur_verid"));
        }
        catch (Exception exception) {
            TreeWalker treeWalker = ((DocumentTraversal)((Object)document)).createTreeWalker(document.getDocumentElement(), 1, null, false);
            this.cur_verid = 0;
            Element element = (Element)treeWalker.nextNode();
            while (element != null) {
                String string = element.getAttribute("cur_verid");
                try {
                    int n = Integer.parseInt(string);
                    if (n >= this.cur_verid) {
                        this.cur_verid = n + 1;
                    }
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                treeWalker.setCurrentNode(element);
                element = (Element)treeWalker.nextNode();
            }
            document.getDocumentElement().setAttribute("cur_verid", Integer.toString(this.cur_verid));
        }
    }

    String getNextVerid() {
        return Integer.toString(this.cur_verid++);
    }

    public void setModeRepresentational() throws TDOMException {
        if (this.mode_set && this.time_mode != 1) {
            throw new TDOMException(106, "MODE IS FIXED.");
        }
        this.time_mode = 1;
        this.doc_root = null;
    }

    public void setModeCurrent(String string, String string2) throws TDOMException {
        Date date;
        if (this.mode_set && this.time_mode != 2) {
            throw new TDOMException(106, "MODE IS FIXED.");
        }
        try {
            this.sdf = new SimpleDateFormat(string);
        }
        catch (Exception exception) {
            throw new TDOMException(103, "");
        }
        try {
            date = this.sdf.parse(string2);
        }
        catch (Exception exception) {
            throw new TDOMException(104, "");
        }
        this.time_mode = (short)2;
        this.cur_instant = date;
        try {
            this.seq_extent = new Period(this.cur_instant, this.sdf.parse("9999-12-31"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.date_format = string;
        String string3 = this.doc.getDocumentElement().getAttribute("cur_date");
        if (string3.length() == 0) {
            this.doc.getDocumentElement().setAttribute("cur_date", string2);
        }
        this.doc_root = null;
    }

    public void setModeCurrent(String string, Date date) {
        if (this.mode_set && this.time_mode != 2) {
            throw new TDOMException(106, "MODE IS FIXED.");
        }
        try {
            this.sdf = new SimpleDateFormat(string);
        }
        catch (Exception exception) {
            throw new TDOMException(103, "");
        }
        this.time_mode = (short)2;
        this.cur_instant = (Date)date.clone();
        try {
            this.seq_extent = new Period(this.cur_instant, this.sdf.parse("9999-12-31"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.date_format = string;
        String string2 = this.doc.getDocumentElement().getAttribute("cur_date");
        if (string2.length() == 0) {
            this.doc.getDocumentElement().setAttribute("cur_date", this.sdf.format(date));
        }
        this.doc_root = null;
    }

    public void setModeSequenced(String string, String string2, String string3) throws TDOMException {
        Date date;
        Date date2;
        if (this.mode_set && this.time_mode != 3) {
            throw new TDOMException(106, "MODE IS FIXED.");
        }
        try {
            this.sdf = new SimpleDateFormat(string);
        }
        catch (Exception exception) {
            throw new TDOMException(103, "");
        }
        try {
            date2 = this.sdf.parse(string2);
            date = this.sdf.parse(string3);
            if (date2.compareTo(date) >= 0) {
                throw new TDOMException(105, "");
            }
        }
        catch (Exception exception) {
            throw new TDOMException(105, "");
        }
        this.time_mode = (short)3;
        this.date_format = string;
        this.seq_extent = new Period(date2, date);
        String string4 = this.doc.getDocumentElement().getAttribute("cur_date");
        if (string4.length() == 0) {
            this.doc.getDocumentElement().setAttribute("cur_date", string2);
            Element element = this.doc.createElement("timestamp");
            element.setAttribute("vtbegin", string2);
            element.setAttribute("vtend", string3);
            this.doc.getDocumentElement().insertBefore(element, this.doc.getDocumentElement().getFirstChild());
        } else {
            try {
                Date date3 = this.sdf.parse(string4);
                if (date3.after(date2)) {
                    this.seq_extent = new Period(date3, date);
                }
            }
            catch (Exception exception) {
                System.out.println("bad format of cur_date");
                System.exit(0);
            }
        }
        this.doc_root = null;
    }

    public void setModeSequenced(String string, Period period) throws TDOMException {
        if (this.mode_set && this.time_mode != 3) {
            throw new TDOMException(106, "MODE IS FIXED.");
        }
        try {
            this.sdf = new SimpleDateFormat(string);
        }
        catch (Exception exception) {
            throw new TDOMException(103, "");
        }
        this.time_mode = (short)3;
        this.date_format = string;
        this.seq_extent = new Period(period.getBegin(), period.getEnd());
        String string2 = this.doc.getDocumentElement().getAttribute("cur_date");
        if (string2.length() == 0) {
            this.doc.getDocumentElement().setAttribute("cur_date", this.sdf.format(this.seq_extent.getBegin()));
            Element element = this.doc.createElement("timestamp");
            element.setAttribute("vtbegin", this.sdf.format(this.seq_extent.getBegin()));
            element.setAttribute("vtend", this.sdf.format(this.seq_extent.getEnd()));
            this.doc.getDocumentElement().insertBefore(element, this.doc.getDocumentElement().getFirstChild());
        } else {
            try {
                Date date = this.sdf.parse(string2);
                if (date.after(this.seq_extent.getBegin())) {
                    this.seq_extent = new Period(date, this.seq_extent.getEnd());
                }
            }
            catch (Exception exception) {
                System.out.println("bad format of cur_date");
                System.exit(0);
            }
        }
        this.doc_root = null;
    }

    public short getMode() {
        if (this.time_mode == -1) {
            this.time_mode = 1;
        }
        return this.time_mode;
    }

    public String getDateFormat() throws TDOMException {
        if (this.time_mode != 2 && this.time_mode != 3) {
            throw new TDOMException(102, "");
        }
        return this.date_format;
    }

    public Date getCurrentInstant() throws TDOMException {
        if (this.time_mode != 2) {
            throw new TDOMException(102, "");
        }
        return this.cur_instant;
    }

    public Period getSequencedExtent() throws TDOMException {
        if (this.time_mode != 3) {
            throw new TDOMException(102, "Not in sequenced mode.");
        }
        return this.seq_extent;
    }

    public DocumentType getDoctype() {
        if (this.time_mode == -1) {
            this.time_mode = 1;
        }
        switch (this.time_mode) {
            case 1: 
            case 2: 
            case 3: {
                return this.doc.getDoctype();
            }
        }
        return null;
    }

    public DOMImplementation getImplementation() {
        if (this.time_mode == -1) {
            this.time_mode = 1;
        }
        switch (this.time_mode) {
            case 1: {
                return this.doc.getImplementation();
            }
            case 2: {
                return null;
            }
            case 3: {
                return null;
            }
        }
        return null;
    }

    public Element getDocumentElement() {
        if (this.doc_root != null) {
            return this.doc_root;
        }
        if (this.time_mode == -1) {
            this.time_mode = 1;
        }
        this.mode_set = true;
        switch (this.time_mode) {
            case 1: {
                this.doc_root = this.doc.getDocumentElement();
                break;
            }
            case 2: {
                Element element = this.doc.getDocumentElement();
                if (element.getNodeName().equalsIgnoreCase("timevarying-root")) {
                    Element element2;
                    Period period;
                    Object object;
                    TreeWalker treeWalker = ((DocumentTraversal)((Object)this.doc)).createTreeWalker(element, 1, new SeqExtFilter(this), false);
                    ArrayList<Node> arrayList = new ArrayList<Node>();
                    Node node = treeWalker.firstChild();
                    while (node != null) {
                        object = TDOMUtil.getTimestamp(this, node);
                        int n = arrayList.size();
                        for (int i = 0; i < arrayList.size(); ++i) {
                            Element element3 = (Element)arrayList.get(i);
                            if (((Period)object).getEnd().compareTo(TDOMUtil.getTimestamp(this, element3).getBegin()) > 0) continue;
                            n = i;
                            break;
                        }
                        arrayList.add(n, node);
                        treeWalker.setCurrentNode(node);
                        node = treeWalker.nextSibling();
                    }
                    if (arrayList.size() == 0) {
                        return null;
                    }
                    object = (Element)arrayList.get(0);
                    if (!TDOMUtil.nodeAtInstant(this, (Node)object)) {
                        return null;
                    }
                    ArrayList<Object> arrayList2 = new ArrayList<Object>();
                    arrayList2.add(object);
                    Date date = TDOMUtil.getTimestamp(this, (Node)object).getEnd();
                    for (int i = 1; i < arrayList.size() && (period = TDOMUtil.getTimestamp(this, element2 = (Element)arrayList.get(i))).getBegin().compareTo(date) == 0; ++i) {
                        arrayList2.add(element2);
                        date = period.getEnd();
                    }
                    this.doc_root = new CurrentElementImpl(this, this, arrayList2);
                    break;
                }
                if (TDOMUtil.nodeAtInstant(this, element)) {
                    ArrayList<Element> arrayList = new ArrayList<Element>();
                    arrayList.add(element);
                    this.doc_root = new CurrentElementImpl(this, this, arrayList);
                    break;
                }
                return null;
            }
            case 3: {
                Element element = this.doc.getDocumentElement();
                if (element.getNodeName().equalsIgnoreCase("timevarying-root")) {
                    TreeWalker treeWalker = ((DocumentTraversal)((Object)this.doc)).createTreeWalker(element, 1, new SeqExtFilter(this), false);
                    ArrayList<Node> arrayList = new ArrayList<Node>();
                    Node node = treeWalker.firstChild();
                    while (node != null) {
                        arrayList.add(node);
                        treeWalker.setCurrentNode(node);
                        node = treeWalker.nextSibling();
                    }
                    if (arrayList.size() == 0) {
                        return null;
                    }
                    this.doc_root = new VersionedElementImpl(this, this, arrayList);
                    break;
                }
                if (!TDOMUtil.nodeInExtent(this, element)) {
                    return null;
                }
                ArrayList<Element> arrayList = new ArrayList<Element>();
                arrayList.add(element);
                this.doc_root = new VersionedElementImpl(this, this, arrayList);
            }
        }
        return this.doc_root;
    }

    public NodeList getElementsByTagName(String string) {
        if (this.time_mode == -1) {
            this.time_mode = 1;
        }
        this.mode_set = true;
        switch (this.time_mode) {
            case 1: {
                return this.doc.getElementsByTagName(string);
            }
            case 2: 
            case 3: {
                this.getDocumentElement();
                MyNodeList myNodeList = new MyNodeList();
                if (this.doc_root.getNodeName().equals(string)) {
                    myNodeList.add(this.doc_root);
                }
                MyNodeList myNodeList2 = (MyNodeList)this.doc_root.getElementsByTagName(string);
                for (int i = 0; i < myNodeList2.getLength(); ++i) {
                    myNodeList.add(myNodeList2.item(i));
                }
                return myNodeList;
            }
        }
        return null;
    }

    public NodeList getElementsByTagNameNS(String string, String string2) {
        if (this.time_mode == -1) {
            this.time_mode = 1;
        }
        return null;
    }

    public Element getElementById(String string) {
        if (this.time_mode == -1) {
            this.time_mode = 1;
        }
        switch (this.time_mode) {
            case 1: {
                return this.doc.getElementById(string);
            }
            case 2: {
                return null;
            }
            case 3: {
                return null;
            }
        }
        return null;
    }

    public String getNodeName() {
        if (this.time_mode == -1) {
            this.time_mode = 1;
        }
        switch (this.time_mode) {
            case 1: 
            case 2: 
            case 3: {
                return this.doc.getNodeName();
            }
        }
        return null;
    }

    public String getNodeValue() {
        if (this.time_mode == -1) {
            this.time_mode = 1;
        }
        return this.doc.getNodeValue();
    }

    public void setNodeValue(String string) {
        if (this.time_mode == -1) {
            this.time_mode = 1;
        }
        this.doc.setNodeValue(string);
    }

    public short getNodeType() {
        if (this.time_mode == -1) {
            this.time_mode = 1;
        }
        return this.doc.getNodeType();
    }

    public Node getParentNode() {
        if (this.time_mode == -1) {
            this.time_mode = 1;
        }
        return this.doc.getParentNode();
    }

    public NodeList getChildNodes() {
        if (this.children != null) {
            return this.children;
        }
        if (this.time_mode == -1) {
            this.time_mode = 1;
        }
        this.mode_set = true;
        switch (this.time_mode) {
            case 1: {
                this.children = this.doc.getChildNodes();
                break;
            }
            case 2: 
            case 3: {
                this.children = new MyNodeList();
                NodeList nodeList = this.doc.getChildNodes();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node node = nodeList.item(i);
                    if (!(node instanceof Element)) {
                        ((MyNodeList)this.children).add(node);
                        continue;
                    }
                    this.getDocumentElement();
                    if (this.doc_root == null) continue;
                    ((MyNodeList)this.children).add(this.doc_root);
                }
                break;
            }
        }
        return this.children;
    }

    public Node getFirstChild() {
        if (this.time_mode == -1) {
            this.time_mode = 1;
        }
        this.mode_set = true;
        this.getChildNodes();
        if (this.children.getLength() > 0) {
            return this.children.item(0);
        }
        return null;
    }

    public Node getLastChild() {
        if (this.time_mode == -1) {
            this.time_mode = 1;
        }
        this.mode_set = true;
        this.getChildNodes();
        if (this.children.getLength() > 0) {
            return this.children.item(this.children.getLength() - 1);
        }
        return null;
    }

    public Node getPreviousSibling() {
        if (this.time_mode == -1) {
            this.time_mode = 1;
        }
        switch (this.time_mode) {
            case 1: {
                return this.doc.getPreviousSibling();
            }
            case 2: 
            case 3: {
                return null;
            }
        }
        return null;
    }

    public Node getNextSibling() {
        if (this.time_mode == -1) {
            this.time_mode = 1;
        }
        switch (this.time_mode) {
            case 1: {
                return this.doc.getNextSibling();
            }
            case 2: 
            case 3: {
                return null;
            }
        }
        return null;
    }

    public NamedNodeMap getAttributes() {
        if (this.time_mode == -1) {
            this.time_mode = 1;
        }
        return null;
    }

    public Document getOwnerDocument() {
        if (this.time_mode == -1) {
            this.time_mode = 1;
        }
        return null;
    }

    public boolean hasChildNodes() {
        if (this.time_mode == -1) {
            this.time_mode = 1;
        }
        this.mode_set = true;
        this.getChildNodes();
        return this.children.getLength() > 0;
    }

    public boolean isSupported(String string, String string2) {
        if (this.time_mode == -1) {
            this.time_mode = 1;
        }
        return this.doc.isSupported(string, string2);
    }

    public String getNamespaceURI() {
        if (this.time_mode == -1) {
            this.time_mode = 1;
        }
        return this.doc.getNamespaceURI();
    }

    public String getPrefix() {
        if (this.time_mode == -1) {
            this.time_mode = 1;
        }
        return this.doc.getPrefix();
    }

    public String getLocalName() {
        if (this.time_mode == -1) {
            this.time_mode = 1;
        }
        return this.doc.getLocalName();
    }

    public boolean hasAttributes() {
        if (this.time_mode == -1) {
            this.time_mode = 1;
        }
        return this.doc.hasAttributes();
    }

    public VersionedElement createVersionedElement(String string) throws TDOMException {
        if (this.time_mode != 3) {
            throw new TDOMException(102, "");
        }
        return new VersionedElementImpl(this, string);
    }

    public Element createElement(String string) {
        if (this.time_mode == -1) {
            this.time_mode = 1;
        }
        this.mode_set = true;
        switch (this.time_mode) {
            case 1: {
                return this.doc.createElement(string);
            }
            case 2: {
                return new CurrentElementImpl(this, string);
            }
            case 3: {
                return new SequencedElementImpl(this, string);
            }
        }
        return null;
    }

    public DocumentFragment createDocumentFragment() {
        if (this.time_mode == -1) {
            this.time_mode = 1;
        }
        return null;
    }

    public Text createTextNode(String string) {
        if (this.time_mode == -1) {
            this.time_mode = 1;
        }
        this.mode_set = true;
        switch (this.time_mode) {
            case 1: {
                return this.doc.createTextNode(string);
            }
            case 2: 
            case 3: {
                return new TTextImpl(this, string);
            }
        }
        return null;
    }

    public Comment createComment(String string) {
        if (this.time_mode == -1) {
            this.time_mode = 1;
        }
        return this.doc.createComment(string);
    }

    public CDATASection createCDATASection(String string) {
        if (this.time_mode == -1) {
            this.time_mode = 1;
        }
        return this.doc.createCDATASection(string);
    }

    public ProcessingInstruction createProcessingInstruction(String string, String string2) {
        if (this.time_mode == -1) {
            this.time_mode = 1;
        }
        return this.doc.createProcessingInstruction(string, string2);
    }

    public Attr createAttribute(String string) {
        if (this.time_mode == -1) {
            this.time_mode = 1;
        }
        this.mode_set = true;
        switch (this.time_mode) {
            case 1: {
                return this.doc.createAttribute(string);
            }
            case 2: {
                return new CurrentAttrImpl(this, string);
            }
            case 3: {
                return new SequencedAttrImpl(this, null, string);
            }
        }
        return null;
    }

    public EntityReference createEntityReference(String string) {
        if (this.time_mode == -1) {
            this.time_mode = 1;
        }
        return this.doc.createEntityReference(string);
    }

    public Node importNode(Node node, boolean bl) {
        if (this.time_mode == -1) {
            this.time_mode = 1;
        }
        return null;
    }

    public Element createElementNS(String string, String string2) {
        if (this.time_mode == -1) {
            this.time_mode = 1;
        }
        return null;
    }

    public Attr createAttributeNS(String string, String string2) {
        if (this.time_mode == -1) {
            this.time_mode = 1;
        }
        return null;
    }

    public Node insertBefore(Node node, Node node2) throws DOMException {
        return null;
    }

    public Node replaceChild(Node node, Node node2) throws DOMException {
        return null;
    }

    public Node removeChild(Node node) throws DOMException {
        return null;
    }

    public Node appendChild(Node node) throws DOMException {
        return null;
    }

    public Node cloneNode(boolean bl) {
        return new TDocumentImpl((Document)this.doc.cloneNode(bl));
    }

    public void normalize() {
        this.doc.normalize();
    }

    public void setPrefix(String string) throws DOMException {
        this.doc.setPrefix(string);
    }

    public void writeTree() {
        String string;
        Object object;
        int n;
        ArrayList<Element> arrayList = new ArrayList<Element>();
        NodeList nodeList = this.doc.getElementsByTagName("timestamp");
        for (n = 0; n < nodeList.getLength(); ++n) {
            object = (Element)nodeList.item(n);
            if (arrayList.contains(object)) continue;
            string = object.getAttribute("vtbegin");
            String string2 = object.getAttribute("vtend");
            for (Node node = object.getNextSibling(); node != null; node = node.getNextSibling()) {
                if (!(node instanceof Element)) continue;
                NodeList nodeList2 = ((Element)node).getElementsByTagName("timestamp");
                for (int i = 0; i < nodeList2.getLength(); ++i) {
                    Element element = (Element)nodeList2.item(i);
                    if (!string.equals(element.getAttribute("vtbegin")) || !string2.equals(element.getAttribute("vtend"))) continue;
                    arrayList.add(element);
                }
            }
        }
        for (n = 0; n < arrayList.size(); ++n) {
            object = (Element)arrayList.get(n);
            object.getParentNode().removeChild((Node)object);
        }
        try {
            System.setProperty("org.w3c.dom.DOMImplementationSourceList", "org.apache.xerces.dom.DOMImplementationSourceImpl");
            DOMImplementationRegistry dOMImplementationRegistry = DOMImplementationRegistry.newInstance();
            object = (DOMImplementationLS)((Object)dOMImplementationRegistry.getDOMImplementation("LS-Load"));
            string = object.createDOMWriter();
            this.doc.getDocumentElement().setAttribute("cur_verid", Integer.toString(this.cur_verid));
            string.writeNode((OutputStream)new FileOutputStream(this.doc.getDocumentElement().getNodeName() + ".xml"), (Node)this.doc);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

