package tauzaman.tests.iotests;

import tauzaman.calendricsystem.*;
import tauzaman.property.*;
import tauzaman.field.*;
import tauzaman.field.fvsupport.*;
import tauzaman.*;
import tauzaman.timestamp.*;
import tauzaman.temporaldatatypes.*;

import java.net.*;
import java.rmi.*;
import java.io.*;


public class Test3{

  public static void main(String args[]) throws Exception{

     long start, end;
     TauZamanSystem tzs = new TauZamanSystem();

     /******* URL FETCHING FOR TESTING ***********/
     TestBaseParser tsp = null;

     tsp = new TestBaseParser(new URL(args[0]));

     /* for server */
     String strings [] = tsp.getServerUrls();
     String serverUrl = strings[0];

     URL urls [] = null;
     /* for calendric system */
     urls = tsp.getCalendricSystemUrls();
     URL UofACalendricSystemUrl = urls[0];

     /* for property */
     urls = tsp.getPropertyUrls();
     URL propertyTable1 = urls[0]; // default property table
     /******* URL FETCHING FOR TESTING ***********/
     
     TauZamanRemoteService tzrs = tzs.getRemoteService(serverUrl, null, null, "uofa", UofACalendricSystemUrl, propertyTable1);
     
     TauZamanLocalService tzls = tzs.getLocalService("uofa", UofACalendricSystemUrl, propertyTable1);


     /************** INTERACTED EXPERIMENT *************/
     int choice;

     do{
         choice = menu();
         start = System.currentTimeMillis();
         switch(choice){
             case '1':
                   Instant instant = new Instant(readFile());
                   System.out.println(instant.output());
                   break;
             case '2':
                   Interval interval = new Interval(readFile());
                   System.out.println(interval.output());
                   break;
             case '3':
                   Period period = new Period(readFile());
                   System.out.println(period.output());
                   break;
             case '4':
                   tzs.setActiveService(tzls);
                   System.out.println("switched to local service");
                   break;
             case '5':
                   tzs.setActiveService(tzrs);
                   System.out.println("switched to remote service");
         }
         System.out.println("Parsed and reparsed in: " + (System.currentTimeMillis()-start) + " ms...");

     }while( choice != '0');

     System.out.println("Quitting... :(");

     /*************************************************/

  }

  private static String readFile() throws Exception{
      
     BufferedReader input = new BufferedReader(new InputStreamReader(new FileInputStream("data.txt")));
     StringBuffer buffer = new StringBuffer();
     String line;

     while ((line = input.readLine()) != null) {
       buffer.append(line + "\n");
     }

     input.close();

     buffer = buffer.deleteCharAt(buffer.length()-1);

     return buffer.toString();
  }


  private static int menu() throws Exception{
      int choice;

      do{
        System.out.println("1 parse instant");
        System.out.println("2 parse interval");
        System.out.println("3 parse period");
        System.out.println("4 change active service to local");
        System.out.println("5 change active service to remote");
        System.out.println("0 quit");
        System.out.flush();
        choice = System.in.read();
        while(choice == '\n')
            choice = System.in.read();
      }while(choice < '0' || choice > '5');

      return choice; 
  }

}
