package tauzaman.tests.iotests;

import tauzaman.calendricsystem.*;
import tauzaman.property.*;
import tauzaman.field.*;
import tauzaman.field.fvsupport.*;
import tauzaman.*;
import tauzaman.timestamp.*;
import tauzaman.temporaldatatypes.*;

import java.net.*;
import java.rmi.*;
import java.io.*;
import java.util.*;

public class Test2{

  public static void main(String args[]) throws Exception{

     TauZamanSystem tzs = new TauZamanSystem();

     /******* URL FETCHING FOR TESTING ***********/
     TestBaseParser tsp = null;

     tsp = new TestBaseParser(new URL(args[0]));

     URL urls [] = null;
     /* for calendric system */
     urls = tsp.getCalendricSystemUrls();
     URL UofACalendricSystemUrl = urls[0];

     /* for property */
     urls = tsp.getPropertyUrls();
     URL propertyTable1 = urls[0]; // default property table
     URL propertyTable2 = urls[2];
     /******* URL FETCHING FOR TESTING ***********/

     TauZamanLocalService tzls = tzs.getLocalService("uofa", UofACalendricSystemUrl, propertyTable1);

     String inputFocusPropertyNames []= {"InstantInputFormat", "IntervalInputFormat", "IndeterminateInstantInputFormat",
                                       "NowRelativeInstantInputFormat", "PeriodInputFormat"};

     String outputFocusPropertyNames []= {"InstantOutputFormat", "IntervalOutputFormat", "IndeterminateInstantOutputFormat",
                                       "NowRelativeInstantOutputFormat", "PeriodOutputFormat"};

     /************** TESTS ************/
     long start;
     long finish;
     String data [] = null;
     Instant instant = null;
     Interval interval = null;
     Period period = null;

     data = tsp.getDeterminateInstants();
     start = System.currentTimeMillis();
     //long start1 = System.currentTimeMillis();
     //long start2 = System.currentTimeMillis();
     //long start3 = System.currentTimeMillis();
     //long start4 = System.currentTimeMillis();
     //long start5 = System.currentTimeMillis();
     //System.out.println("processing time: " + (start1-start) + " ms...");
     //System.out.println("processing time: " + (start2-start) + " ms...");
     //System.out.println("processing time: " + (start3-start) + " ms...");
     //System.out.println("processing time: " + (start4-start) + " ms...");
     //System.out.println("processing time: " + (start5-start) + " ms...");
     System.out.println("Input of a Determinate Instant");
     start = System.currentTimeMillis();
     /*
         Input:
             <instant>
               <day value = "5" />
               <month value = "March" />
               <year value = "2003" />
             </instant>

         Format:

     */
     instant = new Instant(data[0]);
     finish = System.currentTimeMillis();
     System.out.println("processing time: " + (finish-start) + " ms...");
     /*
         Temporal Data Type (TDT) image:
     */
     System.out.println(instant.image());
     /*
         Format:

         Output:

     */
     System.out.println("Output of a Determinate Instant");
     start = System.currentTimeMillis();
     String s = instant.output();
     finish = System.currentTimeMillis();
     System.out.println(s);
     System.out.println("processing time: " + (finish-start) + " ms...");


     data = tsp.getIndeterminateInstants();
     System.out.println("Input of an Indeterminate Instant");
     start = System.currentTimeMillis();
     /*
         Input:

         Format:

     */
     instant = new Instant(data[0]);
     finish = System.currentTimeMillis();
     System.out.println("processing time: " + (finish-start) + " ms...");
     /*
         Temporal Data Type (TDT) image:
     */
     System.out.println(instant.image());
     /*
         Format:
    <indeterminateInstant>
      <instant>
        <day value = "5" />
        <month value = "March" />
        <year value = "2003" />
      </instant>

      <instant>
        <day value = "5" />
        <month value = "March" />
        <year value = "2003" />
      </instant>

      <distribution value = "uniform" />
    </indeterminateInstant>

         Output:

     */
     System.out.println("Output of a Determinate Instant");
     s = instant.output();
     finish = System.currentTimeMillis();
     System.out.println(s);
     System.out.println("processing time: " + (finish-start) + " ms...");

     data = tsp.getNowRelativeInstants();
     start = System.currentTimeMillis();
     /*
         Input:
           <now value = "now" />
           <direction value = "+" />
           <months value = "5" />
         Format:

     */
     instant = new Instant(data[0]);
     /*
         Temporal Data Type (TDT) image:
     */
     System.out.println(instant.image());
     /*
         Format:

         Output:

     */
     System.out.println(instant.output());
     System.out.println("processing time: " + (System.currentTimeMillis()-start) + " ms...");

     data = tsp.getIntervals();
     start = System.currentTimeMillis();
     /*
         Input:

         Format:

     */
     interval = new Interval(data[0]);
     /*
         Temporal Data Type (TDT) image:
     */
     System.out.println(interval.image());
     /*
         Format:

         Output:

     */
     System.out.println(interval.output());
     System.out.println("processing time: " + (System.currentTimeMillis()-start) + " ms...");

     data = tsp.getDeterminatePeriods();
     start = System.currentTimeMillis();
     /*
         Input:

         Format:

     */
     period = new Period(data[0]);
     /*
         Temporal Data Type (TDT) image:
     */
     System.out.println(period.image());
     /*
         Format:

         Output:

     */
     System.out.println(period.output());
     System.out.println("processing time: " + (System.currentTimeMillis()-start) + " ms...");

     /* now use a different property table with different inputs */

     tzls.propertyDeactivateAll();
     tzls.propertyActivate(propertyTable2, null);

     data = tsp.getDeterminateInstants();
     start = System.currentTimeMillis();
     /*
         Input:
             <date month = "March" year = "2003" day = "5" />

         Format:

     */
     instant = new Instant(data[1]);
     /*
         Temporal Data Type (TDT) image:
     */
     System.out.println(instant.image());
     /*
         Format:

         Output:

     */
     System.out.println(instant.output());
     System.out.println("processing time: " + (System.currentTimeMillis()-start) + " ms...");


     data = tsp.getIndeterminateInstants();
     start = System.currentTimeMillis();
     /*
         Input:

         Format:

     */
     instant = new Instant(data[1]);
     /*
         Temporal Data Type (TDT) image:
     */
     System.out.println(instant.image());
     /*
         Format:

         Output:

     */
     System.out.println(instant.output());
     System.out.println("processing time: " + (System.currentTimeMillis()-start) + " ms...");

     data = tsp.getNowRelativeInstants();
     start = System.currentTimeMillis();
     /*
         Input:
            <interval>
               <months> 5 </months>
            </interval>
            <direction>
               +
            </direction>
            <now>
               now
            </now>

         Format:

     */
     instant = new Instant(data[1]);
     /*
         Temporal Data Type (TDT) image:
     */
     System.out.println(instant.image());
     /*
         Format:

         Output:

     */
     System.out.println(instant.output());
     System.out.println("processing time: " + (System.currentTimeMillis()-start) + " ms...");

     data = tsp.getIntervals();
     start = System.currentTimeMillis();
     /*
         Input:

         Format:

     */
     interval = new Interval(data[1]);
     /*
         Temporal Data Type (TDT) image:
     */
     System.out.println(interval.image());
     /*
         Format:

         Output:

     */
     System.out.println(interval.output());
     System.out.println("processing time: " + (System.currentTimeMillis()-start) + " ms...");

     data = tsp.getIndeterminatePeriods();
     start = System.currentTimeMillis();
     /*
         Input:

         Format:

     */
     period = new Period(data[0]);
     /*
         Temporal Data Type (TDT) image:
     */
     System.out.println(period.image());
     /*
         Format:

         Output:

     */
     System.out.println(period.output());
     System.out.println("processing time: " + (System.currentTimeMillis()-start) + " ms...");


  }

}
