package tauzaman.tests.iotests;

import tauzaman.calendricsystem.*;
import tauzaman.property.*;
import tauzaman.field.*;
import tauzaman.field.fvsupport.*;
import tauzaman.*;
import tauzaman.timestamp.*;
import tauzaman.temporaldatatypes.*;

import java.net.*;
import java.rmi.*;
import java.io.*;
import java.util.*;

public class Test1{

  public static void main(String args[]) throws Exception{

     TauZamanSystem tzs = new TauZamanSystem();

     /******* URL FETCHING FOR TESTING ***********/
     TestBaseParser tsp = null;

     tsp = new TestBaseParser(new URL(args[0]));

     /* for server */
     String strings [] = tsp.getServerUrls();
     String serverUrl = strings[0];

     URL urls [] = null;
     /* for calendric system */
     urls = tsp.getCalendricSystemUrls();
     URL UofACalendricSystemUrl = urls[0];

     /* for property */
     urls = tsp.getPropertyUrls();
     URL propertyTable1 = urls[0]; // default property table
     URL propertyTable2 = urls[1];
     /******* URL FETCHING FOR TESTING ***********/



     TauZamanRemoteService tzrs = tzs.getRemoteService(serverUrl, null, null, "uofa", UofACalendricSystemUrl, propertyTable1);

     TauZamanLocalService tzls = tzs.getLocalService("uofa", UofACalendricSystemUrl, propertyTable1);

     String inputFocusPropertyNames []= {"InstantInputFormat", "IntervalInputFormat", "IndeterminateInstantInputFormat",
                                       "NowRelativeInstantInputFormat", "PeriodInputFormat"};
     String outputFocusPropertyNames []= {"InstantOutputFormat", "IntervalOutputFormat", "IndeterminateInstantOutputFormat",
                                       "NowRelativeInstantOutputFormat", "PeriodOutputFormat"};

     /************** INTERACTED EXPERIMENT ************/
     long start;
     int choice;
     boolean isCurrentServiceLocal = true;
     boolean showOutput = true;
     String data [] = null;

     do{
         if(isCurrentServiceLocal)
             System.out.println("Local service is being used...");
         else
             System.out.println("Remote service is being used...");

         if(showOutput)
             System.out.println("Output is being shown...");
         else
             System.out.println("Output is being hidden...");

         choice = menu();
         start = System.currentTimeMillis();
         switch(choice){
             case 'a':
                   data = tsp.getDeterminateInstants();
                   start = System.currentTimeMillis();
                   Instant instant1 = new Instant(data[0]);
                   if(showOutput)
                       System.out.println(instant1.output());
                   else
                       instant1.output();
                   break;
             case 'b':
                   data = tsp.getIndeterminateInstants();
                   start = System.currentTimeMillis();
                   Instant instant3 = new Instant(data[0]);
                   if(showOutput)
                       System.out.println(instant3.output());
                   else
                       instant3.output();
                   break;
             case 'c':
                   data = tsp.getNowRelativeInstants();
                   start = System.currentTimeMillis();
                   Instant instant2 = new Instant(data[0]);
                   if(showOutput)
                       System.out.println(instant2.output());
                   else
                       instant2.output();
                   break;
             case 'd':
                   data = tsp.getIntervals();
                   start = System.currentTimeMillis();
                   Interval interval = new Interval(data[0]);
                   if(showOutput)
                       System.out.println(interval.output());
                   else
                       interval.output();
                   break;
             case 'e':
                   data = tsp.getDeterminatePeriods();
                   start = System.currentTimeMillis();
                   Period period1 = new Period(data[0]);
                   if(showOutput)
                       System.out.println(period1.output());
                   else
                       period1.output();
                   break;
             case 'f':
                   data = tsp.getIndeterminatePeriods();
                   start = System.currentTimeMillis();
                   Period period2 = new Period(data[0]);
                   if(showOutput)
                       System.out.println(period2.output());
                   else
                       period2.output();
                   break;
             case 'g':
                   if(isCurrentServiceLocal){
                       tzls.propertyDeactivate("InstantInputFormat");
                       tzls.propertyDeactivate("IntervalInputFormat");
                       tzls.propertyDeactivate("IndeterminateInstantInputFormat");
                       tzls.propertyDeactivate("NowRelativeInstantInputFormat");
                       tzls.propertyDeactivate("PeriodInputFormat");
                       tzls.propertyActivate(propertyTable1, inputFocusPropertyNames);
                   }
                   else{
                       tzrs.propertyDeactivate("InstantInputFormat");
                       tzrs.propertyDeactivate("IntervalInputFormat");
                       tzrs.propertyDeactivate("IndeterminateInstantInputFormat");
                       tzrs.propertyDeactivate("NowRelativeInstantInputFormat");
                       tzrs.propertyDeactivate("PeriodInputFormat");
                       tzrs.propertyActivate(propertyTable1, inputFocusPropertyNames);
                   }
                   break;
             case 'h':
                   if(isCurrentServiceLocal){
                       tzls.propertyDeactivate("InstantInputFormat");
                       tzls.propertyDeactivate("IntervalInputFormat");
                       tzls.propertyDeactivate("IndeterminateInstantInputFormat");
                       tzls.propertyDeactivate("NowRelativeInstantInputFormat");
                       tzls.propertyDeactivate("PeriodInputFormat");
                       tzls.propertyActivate(propertyTable2, inputFocusPropertyNames);
                   }
                   else{
                       tzrs.propertyDeactivate("InstantInputFormat");
                       tzrs.propertyDeactivate("IntervalInputFormat");
                       tzrs.propertyDeactivate("IndeterminateInstantInputFormat");
                       tzrs.propertyDeactivate("NowRelativeInstantInputFormat");
                       tzrs.propertyDeactivate("PeriodInputFormat");
                       tzrs.propertyActivate(propertyTable2, inputFocusPropertyNames);
                   }
                   break;
             case 'i':
                   if(isCurrentServiceLocal){
                       tzls.propertyDeactivate("InstantOutputFormat");
                       tzls.propertyDeactivate("IntervalOutputFormat");
                       tzls.propertyDeactivate("IndeterminateInstantOutputFormat");
                       tzls.propertyDeactivate("NowRelativeInstantOutputFormat");
                       tzls.propertyDeactivate("PeriodOutputFormat");
                       tzls.propertyActivate(propertyTable1, outputFocusPropertyNames);
                   }
                   else{
                       tzrs.propertyDeactivate("InstantOutputFormat");
                       tzrs.propertyDeactivate("IntervalOutputFormat");
                       tzrs.propertyDeactivate("IndeterminateInstantOutputFormat");
                       tzrs.propertyDeactivate("NowRelativeInstantOutputFormat");
                       tzrs.propertyDeactivate("PeriodOutputFormat");
                       tzrs.propertyActivate(propertyTable1, outputFocusPropertyNames);
                   }
                   break;
             case 'j':
                   if(isCurrentServiceLocal){
                       tzls.propertyDeactivate("InstantOutputFormat");
                       tzls.propertyDeactivate("IntervalOutputFormat");
                       tzls.propertyDeactivate("IndeterminateInstantOutputFormat");
                       tzls.propertyDeactivate("NowRelativeInstantOutputFormat");
                       tzls.propertyDeactivate("PeriodOutputFormat");
                       tzls.propertyActivate(propertyTable2, outputFocusPropertyNames);
                   }
                   else{
                       tzrs.propertyDeactivate("InstantOutputFormat");
                       tzrs.propertyDeactivate("IntervalOutputFormat");
                       tzrs.propertyDeactivate("IndeterminateInstantOutputFormat");
                       tzrs.propertyDeactivate("NowRelativeInstantOutputFormat");
                       tzrs.propertyDeactivate("PeriodOutputFormat");
                       tzrs.propertyActivate(propertyTable2, outputFocusPropertyNames);
                   }
                   break;
             case 'k':
                   if(isCurrentServiceLocal){
                       tzs.setActiveService(tzrs);
                       isCurrentServiceLocal = false;
                   }
                   else{
                       tzs.setActiveService(tzls);
                       isCurrentServiceLocal = true;
                   }
                   break;
             case 'l':
                   showOutput = !showOutput;
                   break;
         }
         System.out.println("processing time: " + (System.currentTimeMillis()-start) + " ms...");


     }while( choice != 'm');

     System.out.println("Quitting... :(");
     /************** INTERACTED EXPERIMENT ************/

  }

  private static int menu() throws Exception{
      int choice;

      do{
        System.out.println("**************TAUZAMAN INTERACTIVE TEST PROGRAM**************");
        System.out.println("**            a to parse determinate instant               **");
        System.out.println("**            b to parse indeterminate instant             **");
        System.out.println("**            c to parse now relative instant              **");
        System.out.println("**            d to parse interval                          **");
        System.out.println("**            e to parse determinate period                **");
        System.out.println("**            f to parse indeterminate period              **");
        System.out.println("**            g to use property table 1 for input          **");
        System.out.println("**            h to use property table 2 for input          **");
        System.out.println("**            i to use property table 1 for output         **");
        System.out.println("**            j to use property table 2 for output         **");
        System.out.println("**            k to switch service (local/remote )          **");
        System.out.println("**            l to switch output (on/off)                  **");
        System.out.println("**            m to quit                                    **");
        System.out.println("*************************************************************");
        System.out.print("input:");
        System.out.flush();
        choice = System.in.read();
        while(choice == '\n')
            choice = System.in.read();
      }while(choice < 'a' || choice > 'm');

      return choice;
  }

}
