package tauzaman.tests.application;

import tauzaman.calendricsystem.*;
import tauzaman.property.*;
import tauzaman.field.*;
import tauzaman.field.fvsupport.*;
import tauzaman.*;
import tauzaman.timestamp.*;
import tauzaman.temporaldatatypes.*;

/* for testing purposes */
import tauzaman.tests.iotests.TestBaseParser;

import java.net.*;
import java.rmi.*;
import java.io.*;

import javax.swing.*;          //This is the final package name.
//import com.sun.java.swing.*; //Used by JDK 1.2 Beta 4 and all
                               //Swing releases before Swing 1.1 Beta 3.
import java.awt.*;
import java.awt.event.*;

public class TauZamanApplication {

    
    /**************** RELATED TO TEST  ********************/
    private String whichService = "local service", lastService = "local service";
    private String whichCalendricSystem = "U of A", lastCalendricSystem = "U of A";
    private String whichPropertyTable = "property table 1", lastPropertyTable = "property table 1";
    private String whichTemporalType= "instant", lastTemporalType = "instant";


    /**************** RELATED TO GUI  ********************/

    /* all panels */
    private JTabbedPane tabPane = new JTabbedPane();

    final private JPanel mainPane = new JPanel();
    private JPanel inputPane = new JPanel(), 
                   outputPane = new JPanel(), 
                   configurationPane = new JPanel();

    /* all scrollpanes for input and output */
    final private JTextArea inputTextArea = new JTextArea(14, 24), 
              outputTextArea = new JTextArea(14, 24);

    private JScrollPane inputScrollPane = new JScrollPane(inputTextArea),
                outputScrollPane = new JScrollPane(outputTextArea);
    
    /* elements of configuration pane */
    private JButton processButton = new JButton("PROCESS");

    private JLabel serviceLabel = new JLabel("Choose Service");
    private JLabel calendricSystemLabel = new JLabel("Choose Calendric System");
    private JLabel propertyTableLabel = new JLabel("Choose Property Table");
    private JLabel temporalTypeLabel = new JLabel("Choose Temporal Type");
    private JLabel processingInfoLabel = new JLabel("Processing Time");

    private String services [] = {"local service", "remote service"};
    private String calendricSystems [] = {"U Of A"};
    private String properties [] = {"property table 1", "property table 2"};
    private String temporalTypes [] = {"instant", "interval", "period"};

    private final JComboBox serviceComboBox = new JComboBox(services);
    private final JComboBox calendricSystemComboBox = new JComboBox(calendricSystems);
    private final JComboBox propertyTableComboBox = new JComboBox(properties);
    private final JComboBox temporalTypeComboBox = new JComboBox(temporalTypes);


    /***************** RELATED TO TAUZAMAN ****************/
    /* TauZamanSystem */
    private TauZamanSystem tzs = null;

    /* URLs for calendric system and */
    private URL calendricSystem = null, propertyTable1 = null, propertyTable2 = null;

    private TauZamanLocalService tzls = null;        
    private TauZamanRemoteService tzrs = null;        
    private TestBaseParser tsp = null;

    /* Constructor */
    public TauZamanApplication(String testBaseUrl){
        tzs = new TauZamanSystem();

        try{
            tsp = new TestBaseParser(new URL(testBaseUrl));
        }
        catch(MalformedURLException mue){
            System.err.println("Bad url for testBase: " + mue);
        }

        URL urls [] = null;

        /* for calendric system */
        urls = tsp.getCalendricSystemUrls();
        calendricSystem = urls[0];

        /* for property */
        urls = tsp.getPropertyUrls();
        propertyTable1 = urls[0]; // default property table
        propertyTable2 = urls[1];

        try{
           tzrs = tzs.getRemoteService("127.0.0.1", null, null, "cs1", calendricSystem, propertyTable1);
           tzls = tzs.getLocalService("cs1", calendricSystem, propertyTable1);
        }
        catch(TauZamanException tze){
                System.err.println("Exception when creating services: " + tze);
                tze.printStackTrace();
        }
    }

    public Component createComponents() {

        /* Input Panel configuration */
        inputPane.setBorder(BorderFactory.createCompoundBorder(
                        BorderFactory.createTitledBorder("input"),
                        BorderFactory.createEmptyBorder(3,3,3,3)));

        inputPane.setPreferredSize(new Dimension(300, 350));
        inputPane.setMinimumSize(new Dimension(300, 350));
        //inputPane.setMaximumSize(new Dimension(300, 350));


        inputPane.add(inputScrollPane /*, BorderLayout.CENTER */);

        /* Output Panel configuration */
        outputPane.setBorder(BorderFactory.createCompoundBorder(
                        BorderFactory.createTitledBorder("output"),
                        BorderFactory.createEmptyBorder(3,3,3,3)));

        outputPane.setPreferredSize(new Dimension(300, 350));
        outputPane.setMinimumSize(new Dimension(300, 350));
        //outputPane.setMaximumSize(new Dimension(300, 350));

        outputPane.add(outputScrollPane /*, BorderLayout.CENTER */);

        /* Configuration Panel configuration */

        configurationPane.setPreferredSize(new Dimension(230, 350));
        configurationPane.setMinimumSize(new Dimension(230, 350));
        //configurationPane.setMaximumSize(new Dimension(230, 350));

        configurationPane.setBorder(BorderFactory.createCompoundBorder(
                        BorderFactory.createTitledBorder("configuration"),
                        BorderFactory.createEmptyBorder(0,0,0,0)));
        
        configurationPane.setLayout(new BoxLayout(configurationPane, BoxLayout.Y_AXIS));

        /* service Label placement */
        serviceLabel.setPreferredSize(new Dimension(120, 15));
        serviceLabel.setMinimumSize(new Dimension(120, 15));
        serviceLabel.setMaximumSize(new Dimension(120, 15));
        serviceLabel.setAlignmentX((float)0.25);

        /* service ComboBox placement */
        serviceComboBox.setPreferredSize(new Dimension(120, 30));
        serviceComboBox.setMinimumSize(new Dimension(120, 30));
        serviceComboBox.setMaximumSize(new Dimension(120, 30));
        serviceComboBox.setAlignmentX((float)0.25);

        serviceComboBox.setSelectedIndex(0);
        serviceComboBox.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                /* get the updated selection */
                whichService = (String)serviceComboBox.getSelectedItem();
            }
        });

        /* calendricSystem Label placement, notice the setAlignmentX(value)
           is different than others this is due to difference in maximum sizes.
           I think this is not nicely implemented in Java Swings */
        calendricSystemLabel.setPreferredSize(new Dimension(150, 15));
        calendricSystemLabel.setMinimumSize(new Dimension(150, 15));
        calendricSystemLabel.setMaximumSize(new Dimension(150, 15));
        calendricSystemLabel.setAlignmentX((float)0.20);

        calendricSystemComboBox.setPreferredSize(new Dimension(120, 30));
        calendricSystemComboBox.setMinimumSize(new Dimension(120, 30));
        calendricSystemComboBox.setMaximumSize(new Dimension(120, 30));
        calendricSystemComboBox.setAlignmentX((float)0.25);

        calendricSystemComboBox.setSelectedIndex(0);
        calendricSystemComboBox.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                /* get the updated selection */
                whichCalendricSystem = (String)calendricSystemComboBox.getSelectedItem();
            }
        });

        propertyTableComboBox.setPreferredSize(new Dimension(120, 30));
        propertyTableComboBox.setMinimumSize(new Dimension(120, 30));
        propertyTableComboBox.setMaximumSize(new Dimension(120, 30));
        propertyTableComboBox.setAlignmentX((float)0.25);

        propertyTableComboBox.setSelectedIndex(0);
        propertyTableComboBox.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                /* get the updated selection */
                whichPropertyTable = (String)propertyTableComboBox.getSelectedItem();
            }
        });

        propertyTableLabel.setPreferredSize(new Dimension(150, 15));
        propertyTableLabel.setMinimumSize(new Dimension(150, 15));
        propertyTableLabel.setMaximumSize(new Dimension(150, 15));
        propertyTableLabel.setAlignmentX((float)0.20);

        temporalTypeLabel.setPreferredSize(new Dimension(150, 15));
        temporalTypeLabel.setMinimumSize(new Dimension(150, 15));
        temporalTypeLabel.setMaximumSize(new Dimension(150, 15));
        temporalTypeLabel.setAlignmentX((float)0.20);

        temporalTypeComboBox.setPreferredSize(new Dimension(120, 30));
        temporalTypeComboBox.setMinimumSize(new Dimension(120, 30));
        temporalTypeComboBox.setMaximumSize(new Dimension(120, 30));
        temporalTypeComboBox.setAlignmentX((float)0.25);

        temporalTypeComboBox.setSelectedIndex(0);
        temporalTypeComboBox.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                /* get the updated selection */
                whichTemporalType= (String)temporalTypeComboBox.getSelectedItem();
            }
        });


        processButton.setPreferredSize(new Dimension(120, 30));
        processButton.setMinimumSize(new Dimension(120, 30));
        processButton.setMaximumSize(new Dimension(120, 30));
        processButton.setAlignmentX((float)0.25);
        processButton.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {

                try{
                    /* adjustments*/
                    if(!lastService.equals(whichService)){
                        lastService = whichService;
                        if(whichService.equals("local service"))
                            tzs.setActiveService(tzls);
                        else
                            tzs.setActiveService(tzrs);
                        System.out.println("change of service to " + whichService);
                    }
                    if(!lastCalendricSystem.equals(whichCalendricSystem)){ 
                        /* irrelevant for this test program, since there is
                           only one calendric sytem */
                        System.err.println("something weird");
                        lastCalendricSystem = whichCalendricSystem;
                        System.out.println("change of calendric system to " + whichCalendricSystem);
                    }  
                    if(!lastPropertyTable.equals(whichPropertyTable)){

                        lastPropertyTable = whichPropertyTable;
                        tzls.propertyDeactivateAll();
                        tzrs.propertyDeactivateAll();
                        if(whichPropertyTable.equals("property table 1")){
                            tzls.propertyActivate(propertyTable1, null);
                            tzrs.propertyActivate(propertyTable1, null);
                            System.out.println("table1 activated");
                        }
                        else{
                            tzls.propertyActivate(propertyTable2, null);
                            tzrs.propertyActivate(propertyTable2, null);                       
                            System.out.println("table2 activated");
                        }
                    }
                
                    long start = System.currentTimeMillis();
                    /* after the adjustments, process input/output */
                    if(whichTemporalType.equals("instant")){
                        System.out.println(inputTextArea.getText());
                        Instant anInstant = new Instant(inputTextArea.getText());
                        processingInfoLabel.setText("Processing time " + (System.currentTimeMillis() - start) + " ms");
                        outputTextArea.setText(anInstant.output());
                    }
                    else if(whichTemporalType.equals("interval")){
                        Interval anInterval = new Interval(inputTextArea.getText());
                        processingInfoLabel.setText("Processing time " + (System.currentTimeMillis() - start) + " ms");
                        outputTextArea.setText(anInterval.output());
                    }
                    else {
                        Period aPeriod = new Period(inputTextArea.getText());
                        processingInfoLabel.setText("Processing time " + (System.currentTimeMillis() - start) + " ms");
                        outputTextArea.setText(aPeriod.output());                      
                    }

                }
                catch(Exception exp){
                    JOptionPane.showMessageDialog(mainPane, 
                      "General IO Test Error Occured!", 
                      "General Error", 
                      JOptionPane.ERROR_MESSAGE); 
                      System.out.println("Exception : " );
                      exp.printStackTrace();
                }


            }
        });

        processingInfoLabel.setPreferredSize(new Dimension(150, 15));
        processingInfoLabel.setMinimumSize(new Dimension(150, 15));
        processingInfoLabel.setMaximumSize(new Dimension(150, 15));
        processingInfoLabel.setAlignmentX((float)0.25);


        /* since we use BoxLayout, the cumulative height should be 300! 
           and length should be less than or equal to 250. 
           created rigidAreas are for these reasons */

        configurationPane.add(serviceLabel);
        configurationPane.add(Box.createRigidArea(new Dimension(0,10)));
        configurationPane.add(serviceComboBox);
        configurationPane.add(Box.createRigidArea(new Dimension(0,10)));
        configurationPane.add(calendricSystemLabel);
        configurationPane.add(Box.createRigidArea(new Dimension(0,10)));
        configurationPane.add(calendricSystemComboBox);
        configurationPane.add(Box.createRigidArea(new Dimension(0,10)));
        configurationPane.add(propertyTableLabel);
        configurationPane.add(Box.createRigidArea(new Dimension(0,10)));
        configurationPane.add(propertyTableComboBox);
        configurationPane.add(Box.createRigidArea(new Dimension(0,10)));
        configurationPane.add(temporalTypeLabel);
        configurationPane.add(Box.createRigidArea(new Dimension(0,10)));
        configurationPane.add(temporalTypeComboBox);
        configurationPane.add(Box.createRigidArea(new Dimension(0,15)));
        configurationPane.add(processButton);
        configurationPane.add(Box.createRigidArea(new Dimension(0,15)));
        configurationPane.add(processingInfoLabel);



        /* Main Panel configuration */
        mainPane.setBorder(BorderFactory.createCompoundBorder(
                        BorderFactory.createTitledBorder("IO Test"),
                        BorderFactory.createEmptyBorder(3,3,3,3)));

        mainPane.setLayout(new BoxLayout(mainPane, BoxLayout.X_AXIS));
        mainPane.add(inputPane);
        mainPane.add(Box.createRigidArea(new Dimension(5,0)));
        mainPane.add(configurationPane);
        mainPane.add(Box.createRigidArea(new Dimension(5,0)));
        mainPane.add(outputPane);

        JPanel testPane1 = new JPanel();
        JPanel testPane2 = new JPanel();
        JPanel testPane3 = new JPanel();

        tabPane.add("Service Configuration", testPane1);
        tabPane.add("Property Management", testPane2);
        tabPane.add("Input Output", mainPane);
        tabPane.add("Temporal Operations", testPane3);

        //return mainPane;
        return tabPane;
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(
                UIManager.getCrossPlatformLookAndFeelClassName());
        } catch (Exception e) { }

        //Create the top-level container and add contents to it.
        JFrame frame = new JFrame("TauZamanApplication");
        TauZamanApplication app = new TauZamanApplication(args[0]);
        Component contents = app.createComponents();
        frame.getContentPane().add(contents, BorderLayout.CENTER);

        //Finish setting up the frame, and show it.
        frame.addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        frame.pack();
        frame.setVisible(true);
    }
}
