package tauzaman.temporaldatatypes;

/**
* An <code>UnanchoredTemporalDataType</code> provides a set of basic 
* operations available on unnchored temporal entities such as intervals.
* An Unnchored entity represents a (collective) distance or length on the
* time-line, and is not tethered to any specific time-line point.
* For example, an Interval (e.g., 1 day) 
* is unanchored entity since it a length rather than a specific day.
**/
public abstract class UnanchoredTemporalDataType extends TemporalDataType {

  public UnanchoredTemporalDatatype() {
    super(null);
    }

  public UnanchoredTemporalDatatype(Granularity g) {
    super(g);
    }

  /**
  * Returns the smallest @see TimeValue in the Unanchored.  It is unusual, 
  * but possible, for an Unanchorable to contain more than one TimeValue, 
  * for instance, a set of intervals.  This method will select the smallest
  * TimeValue from among all the TimeValues in an Unanchored.
  * @return Interval - a minimal TimeValue
  **/
  public abstract TimeValue smallest();

  /**
  * Returns the smallest @see TimeValue in the Unanchored.  It is unusual, 
  * but possible, for an Unanchorable to contain more than one TimeValue, 
  * for instance, a set of intervals.  This method will select the smallest
  * TimeValue from among all the TimeValues in an Unanchored.
  * @return Interval - a maximal TimeValue
  **/
  public abstract TimeValue largest();

// Removed Curt Jan-28-03
//  /**
//  * Create an Enumeration on the Unanchorable.
//  **/
//  public Enumeration enumerate(); 
 
  /**
  * Retrieve the @see TimeValue(s) from this Unanchored.
  * @return - array of all the TimeValues in the Unanchored.  TimeValues in
  *           the array will <b>not</b> be ordered in any specific way.
  **/
  public abstract TimeValue[] timeValueArray(); 

  /**
  * Cast this Unanchored to the indicated granularity.
  * Note that it is not a mutator, it will create a new Unanchored.
  **/
  public abstract UnanchoredDataType cast(Granularity g) { }

  /**
  * Cast this Unanchored to the default granularity.
  * Note that it is not a mutator, it will create a new Unanchored.
  **/
  public abstract UnanchoredDataType cast() { }

  /**
  * Scale this Unanchored to the indicated granularity.
  * Note that it is not a mutator, it will create a new Unanchored.
  **/
  public abstract Unanchored scale(Granularity g) {}

  /**
  * Scale this Unanchored to the default granularity.
  * Note that it is not a mutator, it will create a new Unanchored.
  **/
  public abstract Unanchored scale() {}

}
