package tauadt.temporaldatatypes;

import java.util.*;

/**
* The <code>TemporalDataType</code> class provides a set of basic 
* operations common to Temporal entities, such as instants, periods, and
* intervals.  In terms of data values, every temporal entity has a
* granularity.  In terms of operations, every operation on a temporal
* entity is evaluated in the context of a single Semantics.  In general, 
* this class will be inherited into a 
* specific TemporalDataType.
**/
public abstract class TemporalDataType implements Cloneable {
  // The Granularity is the default Granularity, initially there is no 
  // granularity as represented by a null
  protected static Granularity Granularity = null
  // A Semantics is specified for the class, rather than per temporal entity
  // The default is left operand semantics, where operations are evaluated
  // in the granularity of the left operand.
  protected static Semantics Semantics = new LeftOperandSemantics();

  // Each temporal entity has Granularity, initially there is no granularity
  protected Granularity granularity = Granularity;

  public TemporalDatatype() {
    granularity = Granularity;
    }

  public TemporalDatatype(Granularity g) {
    granularity = g;
    }

  // Set the Semantics to the passed Semantics.  All operations
  // subsequently executed on temporal entities will be evaluated
  // in the set Semantics.
  public static final void setSemantics(Semantics s) {
    Semantics = s;
    }

  // Set the default granularity.  
  public static final void setGranularity(Granularity g) {
    Granularity = g;
    }
}
