package tauzaman.temporaldatatypes;

import java.util.*;
import java.math.*;

import tauzaman.timestamp.*;
import tauzaman.timestamp.domain.*;
import tauzaman.timestamp.internal.*;
import tauzaman.calendricsystem.*;

/**
* The <code>NowRelativeInstant</code> class provides a set of 
* constructor and selector operations for <em>now-relative</em> instants.
* Arithmetic and comparison operations are implemented in a @see Semantics.  
* A now-relative instant is a moving point on the time-line.  It consists
* of the variable <em>now</em> that represents the current time, and an
* @see Interval, that displaces the instant the specified distance 
* from the current time.  For example, the now-relative instant 
* 'now + 1 day' indicates that the Instant represented is whatever the
* current time is displaced by one day in the future.
* This class implements now-relative instants that
* have a known, fixed displacement (as opposed to instants that have
* indeterminate displacements).
* Note that none of the operations are mutators, that is, they all
* create a new instant if needed.  
*
* To perform comparisons and arithmetic operations on now-relative instants, 
* it is first necessary to create a @see Semantics interface.
* A Semantics implements common comparison and arithmetic operations on 
* temporal entities.  For example a user might write code like the following
*  <pre>
*     // Left operand semantics casts operands in binary operations 
*     // to the granularity of the left operand, and then performs
*     // the desired operation. 
*     Ops = new LeftOperandSemantics();
*     // Create two Instants, in this case, both are at the granularity of days
*     Instant i = new NowRelativeInstant("now + 1 day");
*     Instant j = new Instant("July 4, 2002");
*     // Is i earlier on the time-line than j?
*     if (Ops.precedes(i,j)) ...
*  </pre>
* We employ this strategy so that all the now-relative instant operations can be
* performed under varying Semantics.
*
* @author  Curtis Dyreson 
* @version 0.9, Jan/31/2003
* @see     tauzaman.timestamp.Semantics
* @see     tauzaman.temporaldatatypes.Instant
* @see     tauzaman.temporaldatatypes.AnchoredDataType
* @status  Design, complete NOT IMPLMENTED
**/
public class NowRelativeInstant extends AnchornedDataType {

  // The displacement in a now-relative instant
  private TimeValue displacement;

  // This is the granularity of the instant.
  // It may be finer or coarser than the granularity that is in 
  // the granule in the displacement.
  private Granularity g;

  /**
  * Construct a NowRelativeInstant to the specified granularity with the
  * given interval.
  * @param g - Desired granularity of the instant
  * @param displacement - displacement from now
  * @status NOT IMPLEMENTED
  **/
  public NowRelativeInstant(Granularity g, Interval displacement) {
    this.g = g;
    this.tv = new TimeValue(TimeValue.NORMAL, granules);
    }

  /**
  * Construct an NowRelativeInstant by parsing a string, 
  * using the default granularity.
  * @param literal - a string representation of the instant
  * @status NOT IMPLMENTED
  **/
  public static NowRelativeInstant(String literal) {
    this.g = g;
    }

  /**
  * Construct an NowRelativeInstant by parsing a string.
  * The resulting Instant will
  * be <em>cast</em> to the desired @see Granularity.
  * @param literal - a string representation of the instant
  * @param g - granularity
  * @status NOT IMPLMENTED
  **/
  public static NowRelativeInstant(String literal, Granularity g) {
    this.g = g;
    }

  /**
  * Construct the Instant representing <em>now</em> (with no displacement)
  * in the desired granularity.  
  * @param g - Granularity
  * @status NOT IMPLEMENTED.  
  **/
  public NowRelativeInstant(Granularity g) {
    }

  /**
  * Construct the Instant representing <em>now</em> (with no displacement)
  * in the default granularity.  
  * @status NOT IMPLEMENTED.  
  **/
  public NowRelativeInstant() {
    }

  /**
  * Construct a NowRelativeInstant from a TimeValue representing the 
  * Interval.
  * @param g - granularity
  * @param displacement - TimeValue representing the displacement 
  * @status NOT IMPLEMENTED
  **/
  public NowRelativeInstant(Granularity g, TimeValue displacement) {
    this.g = g;
    this.displacement = displacement;
    }

  /** 
  * Build a nice string image of the object, for debugging mostly.  Provides
  * an alternative to toString().
  * @return String image of Instant
  * @status NOT IMPLEMENTED
  **/
  public String image() {
    return "[NowRelativeInstant interval " + displacement.image() + " granularity " + 
             this.g.toString() + "]";
    }

  /** 
  * Generate the hash code value, needed for supporting Hashtables.
  * @return int 
  **/
  public int hashCode() {
    return displacement.hashCode() + g.hashCode();
    }

  /** 
  * Test for object equality, needed only for supporting Hashtables, use
  * equalTo for comparing Instants directly.  This method is used for
  * NowRelativeInstant/Instant comparisons, 
  * the default method for Objects is used
  * for NowRelativeInstant/Object comparisons.
  * @param other - Instant to compare
  * @return true or false 
  **/
  public boolean equals(Instant other) {
    //return ((displacement.hashCode() == other.timeValue().hashCode()) &&
    //        (g.hashCode() == other.g.hashCode()));
    }

  /** 
  * Test for object equality, needed only for supporting Hashtables, use
  * equalTo for comparing Instants directly.  This method is used for
  * NowRelativeInstant/NowRelativeInstant comparisons, 
  * the default method for Objects is used
  * for NowRelativeInstant/Object comparisons.
  * @param other - NowRelativeInstant to compare
  * @return true or false 
  **/
  public boolean equals(NowRelativeInstant other) {
    //return ((displacement.hashCode() == other.displacement.hashCode()) &&
    //        (g.hashCode() == other.g.hashCode()));
    }

  /**
  * Returns the earliest (only!) TimeValue in the NowRelativeInstant.
  * To determine the time, <em>now</em> is <em>bound to</em> 
  * the current time and then the displacement is added.
  * @return TimeValue - the bound TimeValue for this NowRelativeInstant
  **/
  public TimeValue earliest() {
    //return this;
    }

  /**
  * Returns the latest (only!) TimeValue in the NowRelativeInstant.
  * To determine the time, <em>now</em> is <em>bound to</em> 
  * the current time and then the displacement is added.
  * @return TimeValue - the latest TimevValue
  **/
  public TimeValue latest() {
    //return this;
    }

  /**
  * Cast this NowRelativeInstant to the indicated granularity.
  * Note that it is not a mutator, it will create a new Anchorable.
  * @param g - desired @see Granularity
  * @status NOT IMPLEMENTED
  **/
  public NowRelativeInstant cast(Granularity g) {
    //return this;
    }

  /**
  * Scale this NowRelativeInstant to the indicated granularity.
  * Note that it is not a mutator, it will create a new Instant.
  * @param g - desired @see Granularity
  * @status NOT IMPLEMENTED
  **/
  public NowRelativeInstant scale(Granularity g) {
    //return this;
    }

  /**
  * Retrieve the array of TimeValues (containing only one TimeValue) from
  * this NowRelativeInstant.
  * To determine the time, <em>now</em> is <em>bound to</em> 
  * the current time and then the displacement is added.
  * @return array of TimeValues with only one bound TimeValue in it.
  * @status NOT IMPLEMENTED
  **/
  public TimeValue[] timeValueArray() {
    //TimeValue[] temp = new TimeValue[1];
    //temp[0] = this.tv;
    //return temp;
    return null;
    }

  /**
  * Retrieve the Granularity from this NowRelativeInstant
  * @return Granularity object
  **/
  public Granularity granularity() {
    return g;
    }

  /**
  * Retrieve the TimeValue from this NowRelativeInstant
  * To determine the time, <em>now</em> is <em>bound to</em> 
  * the current time and then the displacement is added.
  * @return TimeValue
  * @status NOT IMPLEMENTED
  **/
  public TimeValue timeValue() {
    return null;
    }

  /**
  * Construct a new instance of a NowRelativeInstant from an array of 
  * TimeValues.
  * This method may not seem useful but operations on AnchoredDataTypes
  * will produce arrays of TimeValues, from which the first TimeValue is 
  * selected to "create" a new NowRelativeInstant.  To compute the 
  * NowRelativeInstant, the displacement is computed from the current time. 
  * @param - i an array of TimeValues
  * @return - new NowRelativeInstant
  * @status NOT IMPLEMENTED
  **/
  public static nowRelativeInstant newInstance(TimeValue[] i) {
    // Sanity check
    if (i.length != 1) Internal.Error("More than one TimeValue in array");
    //return new Instant(i[0].granularity(), i[0]);
    return null;
    }
 
}
