package tauzaman.temporaldatatypes;

import tauzaman.TauZamanException;

/**
* <code>TemporalDataTypeServiceException</code> class represents a set of Exceptions
* related to service of temporal elements. For example, scale, cast methods in temporal
* data types, etc.

*
* @author Curtis Dyreson and Bedirhan Urgun
* @version 0.1. 01/06/02
*
*/

public class TemporalDataTypeServiceException extends TauZamanException{
 
  /**
  * Constructs a <code>TemporalDataTypeException</code> object given a detailed explanation of
  * abnormal condition in String message.
  *
  * @param message a detailed explanation of abnormal condition
  *
  */
  public TemporalDataTypeServiceException(String message){
      super(message);
  }

  /**
  * Constructs a <code>TemporalDataTypeException</code> object given a detailed explanation of
  * abnormal condition in String message and another exception, which
  * is the immediate cause of this exception.
  *
  * @param message a detailed explanation of abnormal condition
  * @param cause a Throwable object, which is the cause of this exception
  *
  */
  public TemporalDataTypeServiceException(String message, Throwable cause){
      super(message, cause);
  }

}
