package tauzaman.temporaldatatypes;

import tauzaman.TauZamanException;

/**
* <code>TemporalDataTypeFormationException</code> class represents a set of Exceptions
* related to parsing of temporal elements.
*
* @author Curtis Dyreson and Bedirhan Urgun
* @version 0.1. 01/06/02
*
*/

public class TemporalDataTypeFormationException extends TauZamanException{
 
  /**
  * Constructs a <code>TemporalDataTypeFormationException</code> object given a detailed explanation of
  * abnormal condition in String message.
  *
  * @param message a detailed explanation of abnormal condition
  *
  */
  public TemporalDataTypeFormationException(String message){
      super(message);
  }

  /**
  * Constructs a <code>TemporalDataTypeFormationException</code> object given a detailed explanation of
  * abnormal condition in String message and another exception, which
  * is the immediate cause of this exception.
  *
  * @param message a detailed explanation of abnormal condition
  * @param cause a Throwable object, which is the cause of this exception
  *
  */
  public TemporalDataTypeFormationException(String message, Throwable cause){
      super(message, cause);
  }

}
