package tauzaman.property;

import org.w3c.dom.*;

import tauzaman.field.Fields;

/**
* <p>
* <code>PropertyCache</code> class represents cached version of a 
* <code>Property</code>. Basically, it includes parsed <code>Fields</code>
* of a <code>Property</code> using its <code>Format</code>, <code>ImportFormat</code>
* and <code>FieldInfo</code> members. It also has String content of <code>Format</code> 
* either as a DOM or as a String. </p> <p>
* It worthes to note that String or DOM parsed <code>Format</code> might be produced 
* by using other <code>Format</code> pointed by <code>ImportFormat</code>s in this
* <code>Property</code>. </p>
* 
* @see tauzaman.io.Input
* @see tauzaman.property.Property
* @see tauzaman.property.Format
* @see tauzaman.property.ImportFormat
* @see tauzaman.property.FieldInfo
* @see tauzaman.field.Fields
*/
public class PropertyCache{

  /** <code>Fields</code> object that is cached **/
  private Fields fields = null;

  /** DOM parsed version of produced <code>Format</code> of cached <code>Property</code> **/
  private Element formatDOM = null;

  /** String version of produced <code>Format</code> of cached <code>Property</code> **/
  private String formatString = null;

  /** whitespace characteristic of <code>Format</code> **/
  private boolean whitespace = true;

  /**
  * Constructs a <code>PropertyCache</code> object.
  *
  * @param fields <code>Fields</code> that is produced from this <code>Property</code>
  * @param formatDOM DOM parsed version of produced <code>Format</code> of cached <code>Property</code>
  * @param formatString String version of produced <code>Format</code> of cached <code>Property</code>
  * @param whitespace whitespace characteristic of <code>Format</code>
  *
  */
  public PropertyCache(Fields fields, Element formatDOM, String formatString, boolean whitespace){
      this.fields = fields;
      this.formatDOM = formatDOM;
      this.formatString = formatString;
      this.whitespace = whitespace;
  }

  /**
  * Returns cached <code>Fields</code>.
  *
  * @return <code>Fields</code> object
  */
  public Fields getFields(){
      return (Fields)fields.clone();
  }

  /**
  * Returns cached <code>Format</code> as DOM.
  *
  * @return DOM version of <code>Format</code>
  */
  public Element getFormatDOM(){
      return formatDOM;
  }

  /**
  * Returns cached <code>Format</code> as String.
  *
  * @return String version of <code>Format</code>
  */
  public String getFormatString(){
      return formatString;
  }

  /**
  * Returns whitespace characteristic of cached <code>Format</code>.
  * 
  * @return whitespace characteristic of cached <code>Format</code>
  */
  public boolean getWhitespace(){
      return whitespace;
  }
  
}
