package tauzaman.field;

import org.w3c.dom.*;

import java.net.URL;
import java.util.*;

import tauzaman.field.fvsupport.FVSupport;

/**
* <code>FVSupportRepository</code> class represents Field Support 
* and manages the services to input and ouput operations 
* by mapping and handling field value tables and functions.
*
* @author  Curtis Dyreson and Bedirhan Urgun
* @version 0.1, 11/15/02
* @see tauzaman.field.fvsupport.FVSupport 
* @see tauzaman.field.FVTable
* @see tauzaman.field.FVFunction
* @status design complete, implementation complete  
*/

public class FVSupportRepository{

  /** List of <code>FVSupport</code>s in this manager. Its keys are
      the labels of fVSupport structures (FVTable or FVFunction), and 
      values are FVSupport object handles */
  private Hashtable fvSupportCache = null;
 
  /**
  * Constructs a <code>FVSupportRepository</code> object. And allocates memory
  * for <code>FVsupport</code>s that system will use.
  */
  public FVSupportRepository(){
      fvSupportCache = new Hashtable();
  }

  /** 
  * Returns a handle to <code>FVSupport</code> with a given label if it exists, 
  * loads it otherwise.
  *
  * @param url URL of the <code>FVSupport</code> that is looked for
  * 
  * @return an <code>FVSupport</code>
  *
  * @throws FVFormationException if any errors occur when parsing a FV Specification
  * file
  */
  public FVSupport loadFVSupport(URL url) throws FVFormationException{

      FVSupport fvs = null;

      /* check whether cache has requested FVSupport */
      if(fvSupportCache.containsKey(url))
          fvs = (FVSupport)(fvSupportCache.get(url));
      else{
          /* cache does not have the requested FVSupport */
          String strUrl = url.toExternalForm();
          /* try to understand which kind of FVSupport is requested */
          if(strUrl.endsWith(".class")){
              /* load an FVFunction */ 
              fvs = new FVFunction(url);
          }
          else if(strUrl.endsWith(".xml")){
              /* load an FVTable */
              fvs = new FVTable(url);
          }
          else{
              /* undefined FVSupport specification file url */
              throw new FVFormationException("Exception when forming an FVSupport from: " + 
                                    url.toExternalForm() + " undefined specification file!");
          }

          /* add this newly formed FVSupport to cache */
          fvSupportCache.put(url, fvs);
      }
      return fvs;
  }

  /**
  * toString method, which produces string representation of
  * this <code>FVSupportRepository</code>.
  * 
  * @return a String, which is a representation of this <code>FVSupportRepository</code>
  */
  public String toString(){
      String result = "FVSupportRepository: \n";
      Iterator it = (fvSupportCache.values()).iterator();
      while(it.hasNext()){
          result = result.concat(((FVSupport)(it.next())).toString() + "\n");
      }
      return result;
  }
 
}
