package tauzaman.calendricsystem.granularitylattice.minpriorityqueue;

/**
  * <p>Title: Minimum Priority Queue Element</p>
  * <p>Description: A class that is composed of a priority with a particular
  *      element that can be put into a priority queue. </p>
  * <p>Copyright: Copyright (c) 2003</p>
  * @author Jessica Miller
  * @version 1.0
  */

public class MPQElement
{
  /**
    * The priority of the element has to be something that is
    *   <code>Comparable</code> is that it can be assessed to in the priority
    *   queue.
    */
  private Comparable priority;

  /**
    * The actual value of the minimum priority queue element.
    */
  private Object value;

  /**
    * Constructs a minimum priority queue element.
    *
    * @param priority  the priority of the element
    * @param value     the element associated with the priority
    */
  public MPQElement(Comparable priority, Object value)
  {
    this.priority = priority;
    this.value    = value;
  }

  /**
    * Evaluates whether the given object is equivalent to this
    *   <code>MPQElement</code>.
    *
    * @param o  the object to compare this element to
    * @return   whether or not the two object are equivalent
    */
  public boolean equals(Object o)
  {
    MPQElement other = (MPQElement) o;
    return this.priority.equals(other.getPriority()) && this.value.equals(other.getValue());
  }

  /**
    * Returns the priority of this element.
    *
    * @return  the priority of this element
    */
  public Comparable getPriority()
  {
    return priority;
  }

  /**
    * Returns the value of this element.
    *
    * @return  the value of this element
    */
  public Object getValue()
  {
    return value;
  }

  /**
    * Sets the priority of this element to be something new.
    *
    * @param priority  the new priority of this element
    * @return          the old priority of this element
    */
  public Comparable setPriority(Comparable priority)
  {
    Comparable oldPriority = this.priority;
    this.priority = priority;
    return oldPriority;
  }

 /**
   * Sets the value of this element to be something new.
   *
   * @param priority  the new value of this element
   * @return          the old value of this element
   */
 public Object setValue(Object value)
  {
    Object oldValue = this.value;
    this.value = value;
    return oldValue;
  }

  /**
    * Returns a string representation of this <code>MPQElement</code>.
    *
    * @return  a string representation of this <code>MPQElement</code>
    */
  public String toString()
  {
    return "MPQEl: pri = " + priority + ", val = " + value;
  }
}