package tauzaman.calendricsystem;

import tauzaman.TauZamanException;

/**
* <code>CalendricSystemFormationException</code> class represents a set of Exceptions
* related to formation of <code>CalendricSystem</code>s. For example; Parsing errors,
* URL errors, etc.
*
* @author Curtis Dyreson and Bedirhan Urgun
* @version 0.1. 01/06/02
*
* @status Design complete, implementation not started
*/

public class CalendricSystemFormationException extends TauZamanException{

  /**
  * Constructs a <code>CalendricSystemFormationException</code> object given a detailed explanation of
  * abnormal condition in String message.
  *
  * @param message a detailed explanation of abnormal condition
  *
  */
  public CalendricSystemFormationException(String message){
      super(message);
  }

  /**
  * Constructs a <code>CalendricSystemFormationException</code> object given a detailed explanation of
  * abnormal condition in String message and another exception, which
  * is the immediate cause of this exception.
  *
  * @param message a detailed explanation of abnormal condition
  * @param cause a Throwable object, which is the cause of this exception
  *
  */
  public CalendricSystemFormationException(String message, Throwable cause){
      super(message, cause);
  }

}
