package tauzaman;

import java.rmi.*;
import java.net.*;

import tauzaman.property.*;
import tauzaman.calendricsystem.*;

/**
* <p>
* <code>TauZamanRemoteServiceHandler</code> interface enables a 
* <code>TauZamanSystem</code> to be set as a server. </p><p>
* <code>TauZamanRemoteServiceHandler</code> is itself a remote class
* interface. </p>
*
* @author Curtis Dyreson and Bedirhan Urgun
* @version 0.1. 01/27/02
* @status design complete, implementation complete
*
* @see tauzaman.TauZamanRemoteServiceHandlerImpl
* @see tauzaman.TauZamanSystem
* @see tauzaman.TauZamanRemoteService
*/
public interface TauZamanRemoteServiceHandler extends Remote{

  /**
  * Returns a <code>TauZamanRemoteService</code> with a default <code>CalendricSystem</code>
  * and <code>Property</code> list.
  *
  * @param calendricSystemName String name, given by user, which loaded default <code>CalendricSystem</code>
  * will be referred as
  * @param calendricSystemUrl default <code>CalendricSystem</code> for this <code>TauZamanService</code>
  * @param defaultPropertiesUrl default <code>Properties</code> related to default <code>CalendricSystem</code>
  *
  * @return a <code>TauZamanRemoteService</code> ready to serve
  *
  * @throws RemoteException if an abnormal condition occurs during remote connection
  *
  * @throws CalendricSystemFormationException if any abnormal condition occurs when loading
  * default <code>CalendricSystem</code> for the fetched remote service
  * @throws PropertyFormationException if any abnormal condition occurs when loading
  * default <code>Property</code> list for the fetched remote service
  */
  public TauZamanRemoteService getService(String calendricSystemName, URL calendricSystemUrl, URL defaultPropertyListUrl) 
                                   throws RemoteException, CalendricSystemFormationException, PropertyFormationException;
}
