package tauzaman;

import java.net.*;
import java.lang.reflect.*;
import java.util.*;
import java.lang.*;

/* do we want this class to be public?
   do we want this class to be in this package, namely, directly under tauzaman package? 
   This is a general class, it does not contain any specific behavour to tauzaman!
*/





/********IMPORTANT NOTES FOR DYNAMIC METHOD CALLING*********************

 1. one has to get parameter types to get handle to dynamic method, 
    and parameter types are shown by using class names. Because of 
    this, we can not use primitive types as formal parameters in our 
    dynamic method. 
  
    And also this is meaningful, since if you had two dynamic methods
    in a class;
        method1(int x)
        method1(Integer X)

    which one will be called when you call it dynamically? 

 2. on the other hand, when returning values from dynamic method
    primitive types can be used. This primitive types will be wrapped
    to their wrapper classes. However, still we have to downcast to primitive
    since it will not be unwrapped at the callee automatically.

      (Boolean) m.invoke() is valid if m returns a primitive boolean
      (boolean) m.invoke() is invalid if m returns a primitive boolean
      (boolean []) m.invoke() is valid if m returns a primitive boolean array


************************************************************************/

/**
* <p>
* <code>ClassLoaderMethodCaller</code> class dynamically loads
* a <code>Class</code> and provide service for calling any of loaded 
* <code>Method</code>s.
* </p><p>
* Classes that will make use of <code>ClassLoaderMethodCaller</code> are;
* <ul>
*    <li> <code>IrregularMapping</code> objects for their methods. Also, <code>IrregularMapping</code>s
* will be used in granularityLattice, which is still in design stage. </li>
*    <li> <code>Calendar</code> because of <b>regular</b> methods. <b>regular</b> functions 
* refer to two functions, which all <code>Calendar</code>s should have: "<i>granuleToFields</i> 
* and <i>fieldsToGranule</i>". </li>
*    <li> <code>FVFunction</code> because of Field Value functions.</li>
* </ul>
* </p>
*
* @status Design complete, implementation not started
* @author  Bedirhan Urgun and Curtis Dyreson
* @version 0.1, 10/10/02
* @see tauzaman.calendar.IrregularMapping
* @see tauzaman.calendar.Calendar
* @see tauzaman.field.FVFunction
*/

/*

1. An IrregularMapping has one CLMC.
   An IrregularMapping may have either one class and one or more methods. Or
   and IrregularMapping may have one or more class and one or more methods.
   However, method names in an IrregularMapping should be unique through out
   the classes!
2. An FVFunction has one CLMC.
   An FVFunction has one class and two methods (fix names).
   Therefore, method names are unique.
3. A Calendar has one CLMC.
   A Calendar has one class and two methods (fix names).
   Therefore, method names are unique.
   
So, based on above statements, a CLMC is designed;

  1. It does not need to keep class names, since method names are unique through out a CLMC.
  2. It has a Hashtable, which maps method names to actual loaded classes.
  3. When its formed, callee will call its constructor with url (ends with / or .jar) and
     later will load its className,methodName pairs.
  4. Then callee only needs to keep method names and CLMC object. In the future if callee
     wants to call any method, then all he/she has to do is; 
          (CLMC object).invokeMethod(methodName, parameters[]);

*/

public class ClassLoaderMethodCaller extends URLClassLoader{
  
  /**
  * A Hashtable, which maps methods of this CLMC to loaded classes.
  */
  private Hashtable methodsToClass = null;
  
  /**
  * <p>
  * Constructs a <code>ClassLoaderMethodCaller</code> object with specified URLs.
  * Any URL that ends with a '/' is assumed to refer to a directory. Otherwise, 
  * the URL is assumed to refer to a JAR file which will be downloaded and opened 
  * as needed.
  * </p> <p>
  * Although constructor takes an array of URLs, we only use first URL in this array
  * since urls in the system are always either contain a single class or point to a
  * directory or a .jar file, which contain multiple classes.
  * </p>
  * @param urls array of URLs 
  */
  public ClassLoaderMethodCaller(URL urls[]){
      super(urls);
      methodsToClass = new Hashtable();
  }

  /**
  * Finds and loads the class with the specified name from the URL search path.
  * Method name is given for mapping purposes. If the class is already loaded
  * then keep silent and use it. 
  *
  * @param className name of the class to be searched and loaded 
  * @param methodName name of the method related to loaded class
  * 
  * @throws Exception if any abnormal condition occurs when loading a class,
  * Exception may further be specialized
  */
  public void loadClass(String className, String methodName) throws DynamicLoadException{
      Class c = findLoadedClass(className);
      if(c == null){
          try{
              // it is not loaded. Load it.
              c = findClass(className);
          }
          catch(ClassNotFoundException cnfe){
              throw new DynamicLoadException(c + "Exception when dynamically loading class", cnfe);
          }
      } 
      // put it to hashtable
      methodsToClass.put(methodName, c);
  }

  /**
  * Calls method with specified method name with specified actual 
  * parameters. Returns return value of the method as an Object. Instance of
  * the class that contains this method will be formed here. 
  * 
  *
  * @param methodName name of the <code>Method</code> to be called
  * @param parameterTypes the list of parameters. This is passed as a parameter
  * instead of having fix names (which can also be done) to allow generality for
  * a possible changes in future time.
  * @param args the arguments used for the method call 
  * 
  * @throws Exception if any abnormal condition occurs when loading a class,
  * Exception may further be specialized
  */
  public Object callMethod(String methodName, Class parameterTypes [], Object args []) throws DynamicLoadException {
      
       Object returnValue = null;

       //get Class corresponding to this method
       if(methodsToClass.containsKey(methodName)){

           //class is found, get it by method name
           Class c = (Class)methodsToClass.get(methodName);

           Object classInstance = null;

           try{
               //get an instance of class
               classInstance = c.newInstance();
           }
           catch(IllegalAccessException iae){
               throw new DynamicLoadException("Exception when dynamically loading class", iae);
           }
           catch(InstantiationException ie){
               throw new DynamicLoadException("Exception when dynamically loading class", ie);
           }

           Method method = null;

           try{ 
               //get method with parameter types
               method = c.getMethod(methodName, parameterTypes);
           }
           catch(NoSuchMethodException nsme){
               throw new DynamicLoadException("Exception when dynamically loading class", nsme);
           }

           try{
               //invoke the method with arguments
               returnValue = method.invoke(classInstance, args);
           }
           catch(InvocationTargetException ite){
               throw new DynamicLoadException("Exception when dynamically loading class", ite);
           }
           catch(IllegalAccessException iae){
               throw new DynamicLoadException("Exception when dynamically loading class", iae);
           }

       }
       return returnValue;

  }

  /**
  * Returns string representation of method name - class name mapping
  * of this <code>ClassLoaderMethodCaller</code>.
  *
  * @return String string representation of this <code>ClassLoaderMethodCaller</code>
  */
  public String toString(){
      return methodsToClass.toString();
  }

}
