package tauzaman.tests.latticetests;

import java.net.URL;
import tauzaman.calendricsystem.CalendricSystem;
import tauzaman.calendricsystem.granularitylattice.*;
import tauzaman.calendar.*;
import tauzaman.timestamp.*;

public class UofACalendricSystemTests
{
  public static void main(String[] args) throws Exception
  {
    // ----------------------- Test construction ------------------------------
    System.out.println("**** Test 1: Visually inspected the construction of the lattice and the induction of regular mappings ****");
    /*"file:///C:/Documents%20and%20Settings/Registered%20User/My%20Documents/scule/spr03/research/code/calendarImplementations/UofALmtCalSysTest/mine/home/UofALimitedCalendricSystem.xml"*/
    URL UofALmtdCalendricSystemUrl = new URL(args[0]);
    //URL UofALmtdCalendricSystemUrl = new URL("file:///C:/Document/scule/spr03/research/code/calendarImplementations/UofALmtCalSysTest/mine/laptop/UofALimitedCalendricSystem.xml");
    //URL UofALmtdCalendricSystemUrl = new URL("file:///home/jessica/dbResearch/code/calendarImplementations/UofALmtCalSysTest/mine/school/UofALimitedCalendricSystem.xml");
    CalendarRepository cr = new CalendarRepository();
    CalendricSystem cs    = new CalendricSystem(cr, UofALmtdCalendricSystemUrl);
    cs.printGranularityLattice();

    Calendar gregCal = cs.getCalendar("ADGregorian");
    Calendar uofaCal = cs.getCalendar("UofACalendar");

    boolean boolRes;


    // ----------------------- Test isFiner ------------------------------------
    System.out.println("**** Test 2: Test isFiner ****");

    System.out.print("ADday finer than ADyear? ");
    boolRes = cs.isFiner(gregCal.getGranularityByLocalName("day"),
                         gregCal.getGranularityByLocalName("year"));
    System.out.print(boolRes + " ... ");
    System.out.println((boolRes) ? "PASSED" : "FAILED");

    System.out.print("ADyear finer than ADday? ");
    boolRes = cs.isFiner(gregCal.getGranularityByLocalName("year"),
                         gregCal.getGranularityByLocalName("day"));
    System.out.print(boolRes + " ... ");
    System.out.println((boolRes) ? "FAILED" : "PASSED");

    System.out.print("ADday finer than UofAday? ");
    boolRes = cs.isFiner(gregCal.getGranularityByLocalName("day"),
                         uofaCal.getGranularityByLocalName("day"));
    System.out.print(boolRes + "...");
    System.out.println((boolRes) ? "FAILED" : "PASSED");

    System.out.print("UofAhour finer than UofAweek? ");
    boolRes = cs.isFiner(uofaCal.getGranularityByLocalName("hour"),
                         uofaCal.getGranularityByLocalName("week"));
    System.out.print(boolRes + "...");
    System.out.println((boolRes) ? "PASSED" : "FAILED");

    System.out.print("UofAweek finer than UofAhour? ");
    boolRes = cs.isFiner(uofaCal.getGranularityByLocalName("week"),
                         uofaCal.getGranularityByLocalName("hour"));
    System.out.print(boolRes + "...");
    System.out.println((boolRes) ? "FAILED" : "PASSED");


    // ----------------------- Test isCoarser ----------------------------------
    System.out.println("\n\n**** Test 3: Test isCoarser ****");

    System.out.print("ADday coarser than ADyear? ");
    boolRes = cs.isCoarser(gregCal.getGranularityByLocalName("day"),
                           gregCal.getGranularityByLocalName("year"));
    System.out.print(boolRes + " ... ");
    System.out.println((boolRes) ? "FAILED" : "PASSED ");

    System.out.print("ADyear coarser than ADday? ");
    boolRes = cs.isCoarser(gregCal.getGranularityByLocalName("year"),
                           gregCal.getGranularityByLocalName("day"));
    System.out.print(boolRes + " ... ");
    System.out.println((boolRes) ? "PASSED" : "FAILED");

    System.out.print("ADday coarser than UofAday? ");
    boolRes = cs.isCoarser(gregCal.getGranularityByLocalName("day"),
                           uofaCal.getGranularityByLocalName("day"));
    System.out.print(boolRes + "...");
    System.out.println((boolRes) ? "FAILED" : "PASSED");

    System.out.print("UofAhour coarser than UofAweek? ");
    boolRes = cs.isCoarser(uofaCal.getGranularityByLocalName("hour"),
                           uofaCal.getGranularityByLocalName("week"));
    System.out.print(boolRes + "...");
    System.out.println((boolRes) ? "FAILED" : "PASSED");

    System.out.print("UofAweek coarser than UofAhour? ");
    boolRes = cs.isCoarser(uofaCal.getGranularityByLocalName("week"),
                           uofaCal.getGranularityByLocalName("hour"));
    System.out.print(boolRes + "...");
    System.out.println((boolRes) ? "PASSED" : "FAILED");


    // ----------------------- Test isEquivalent -------------------------------
    System.out.println("\n\n**** Test 4: Test isEquivalent ****");

    System.out.print("ADday equivalent to UofAday? ");
    boolRes = cs.isEquivalent(gregCal.getGranularityByLocalName("day"),
                              uofaCal.getGranularityByLocalName("day"));
    System.out.print(boolRes + " ... ");
    System.out.println((boolRes) ? "FAILED" : "PASSED ");

    System.out.print("ADhour equivalent to UofAhour? ");
    boolRes = cs.isEquivalent(gregCal.getGranularityByLocalName("hour"),
                              uofaCal.getGranularityByLocalName("hour"));
    System.out.print(boolRes + " ... ");
    System.out.println((boolRes) ? "PASSED" : "FAILED");


    // ----------------------- Test isIncomparable -----------------------------
    System.out.println("\n\n**** Test 5: Test isIncomparable ****");

    System.out.print("ADday incomparable to UofAday? ");
    boolRes = cs.isIncomparable(gregCal.getGranularityByLocalName("day"),
                                uofaCal.getGranularityByLocalName("day"));
    System.out.print(boolRes + " ... ");
    System.out.println((boolRes) ? "PASSED" : "FAILED");

    System.out.print("ADhour incomparable to UofAhour? ");
    boolRes = cs.isIncomparable(gregCal.getGranularityByLocalName("hour"),
                                uofaCal.getGranularityByLocalName("hour"));
    System.out.print(boolRes + " ... ");
    System.out.println((boolRes) ? "FAILED" : "PASSED");

    System.out.print("UofAacademicYear incomparable to ADyear? ");
    boolRes = cs.isIncomparable(uofaCal.getGranularityByLocalName("academicYear"),
                                gregCal.getGranularityByLocalName("year"));
    System.out.print(boolRes + " ... ");
    System.out.println((boolRes) ? "PASSED" : "FAILED");


    Granule granule;
    long castRes;

    // --------------------- Test simple path instant casts --------------------
    System.out.println("\n\n**** Test 6: Test instant casts that do not require a V-path ****");

    System.out.println("    * Simple casts using one given regular mapping:");
      // coarser to finer
    granule  = new Granule(gregCal.getGranularityByLocalName("year"), 1978);
    System.out.print("        cast(1978 ADyears, ADmonths) = ");
    castRes = cs.castDeterminantInstant(granule,
                                        gregCal.getGranularityByLocalName("month")).getGranule().getValue();
    System.out.print(castRes + " ... ");
    System.out.println((23725 == castRes) ? "PASSED" : "FAILED");

      // finer to coarser
    granule  = new Granule(uofaCal.getGranularityByLocalName("term"), 9);
    System.out.print("        cast(9 UofAterms, UofAacademicYear) = ");
    castRes = cs.castDeterminantInstant(granule,
                                        uofaCal.getGranularityByLocalName("academicYear")).getGranule().getValue();
    System.out.print(castRes + " ... ");
    System.out.println((2 == castRes) ? "PASSED" : "FAILED");


    System.out.println("    * Simple casts using given regular/irregular mappings:");
      // coarser to finer
    granule  = new Granule(gregCal.getGranularityByLocalName("year"), 1978);
    System.out.print("        cast(1978 ADyears, ADhours) = ");
    castRes = cs.castDeterminantInstant(granule,
                                        gregCal.getGranularityByLocalName("hour")).getGranule().getValue();
    System.out.print(castRes + " ... ");
    System.out.println((17330017 == castRes) ? "PASSED" : "FAILED");

      // finer to coarser
    granule = new Granule(uofaCal.getGranularityByLocalName("day"), 378);
    System.out.print("        cast(378 UofAdays, UofAacademicYear) = ");
    castRes = cs.castDeterminantInstant(granule,
                                        uofaCal.getGranularityByLocalName("academicYear")).getGranule().getValue();
    System.out.print(castRes + " ... ");
    System.out.println((1 == castRes) ? "PASSED" : "FAILED");


    System.out.println("    * Simple casts using given regular/irregular and induced regular mappings:");
      // coarser to finer
    granule  = new Granule(gregCal.getGranularityByLocalName("week"), 103155);
    System.out.print("        cast(103155 ADweeks, ADseconds) = ");
    castRes = cs.castDeterminantInstant(granule,
                                        gregCal.getGranularityByLocalName("second")).getGranule().getValue();
    System.out.print(castRes + " ... ");
    System.out.println((62387539207l == castRes) ? "PASSED" : "FAILED");

      // finer to coarser
    granule  = new Granule(gregCal.getGranularityByLocalName("second"), 62387539207l);
    System.out.print("        cast(62387539207 ADseconds, ADWeeks) = ");
    castRes = cs.castDeterminantInstant(granule,
                                        gregCal.getGranularityByLocalName("week")).getGranule().getValue();
    System.out.print(castRes + " ... ");
    System.out.println((103155 == castRes) ? "PASSED" : "FAILED");

    granule = new Granule(uofaCal.getGranularityByLocalName("hour"), 9873);
    System.out.print("        cast(9873 UofAhours, UofAterms) = ");
    castRes = cs.castDeterminantInstant(granule,
                                        uofaCal.getGranularityByLocalName("term")).getGranule().getValue();
    System.out.print(castRes + " ... ");
    System.out.println((11 == castRes) ? "PASSED" : "FAILED");


    // ---------------------- Test V-path instant casts ------------------------
    System.out.println("\n\n**** Test 7: Test instant casts that do require a V-path ****");

    // finer -> coarser V-path
    granule  = new Granule(gregCal.getGranularityByLocalName("minute"), 1053326000);
    System.out.print("        cast(1053326000 ADminutes, UofAacademicYears) = ");
    castRes = cs.castDeterminantInstant(granule,
                                        uofaCal.getGranularityByLocalName("academicYear")).getGranule().getValue();
    System.out.print(castRes + " ... ");
    System.out.println((3 == castRes) ? "PASSED" : "FAILED");

    granule  = new Granule(gregCal.getGranularityByLocalName("hour"), 17555435);
    System.out.print("        cast(17555435 ADhour, terms) = ");
    castRes = cs.castDeterminantInstant(granule,
                                        uofaCal.getGranularityByLocalName("term")).getGranule().getValue();
    System.out.print(castRes + " ... ");
    System.out.println((12 == castRes) ? "PASSED" : "FAILED");

    granule  = new Granule(uofaCal.getGranularityByLocalName("hour"), 0);
    System.out.print("        cast(0 UofAhours, ADyears) = ");
    castRes = cs.castDeterminantInstant(granule,
                                        gregCal.getGranularityByLocalName("year")).getGranule().getValue();
    System.out.print(castRes + " ... ");
    System.out.println((2000 == castRes) ? "PASSED" : "FAILED");

    // coarser -> finer V-path
    granule  = new Granule(uofaCal.getGranularityByLocalName("term"), 11);
    System.out.print("        cast(11 UofAterms, ADseconds) = ");
    castRes = cs.castDeterminantInstant(granule,
                                        gregCal.getGranularityByLocalName("second")).getGranule().getValue();
    System.out.print(castRes + " ... ");
    System.out.println((63189180023l == castRes) ? "PASSED" : "FAILED");

    // coarser -> finer -> coarser V-path
    granule  = new Granule(uofaCal.getGranularityByLocalName("academicYear"), 0);
    System.out.print("        cast(0 UofAacademicYear, ADyears) = ");
    castRes = cs.castDeterminantInstant(granule,
                                        gregCal.getGranularityByLocalName("year")).getGranule().getValue();
    System.out.print(castRes + " ... ");
    System.out.println((2000 == castRes) ? "PASSED" : "FAILED");

    granule  = new Granule(gregCal.getGranularityByLocalName("month"), 2);
    System.out.print("        cast(2 ADmonths, ADweeks) = ");
    castRes = cs.castDeterminantInstant(granule,
                                        gregCal.getGranularityByLocalName("week")).getGranule().getValue();
    System.out.print(castRes + " ... ");
    System.out.println((5 == castRes) ? "PASSED" : "FAILED");


    // ----------------------- Test lattice caches -----------------------------
    System.out.println("\n\n**** Test 8: Test caches  ****");
    // to perform these tests set CACHE_DEBUG flag in GranularityLattice to true
    GranularityLattice.CACHE_DEBUG = true;
      // clear all caches of contents from test before this one
    cs.clearCaches();

    System.out.println("  * below should see one cache miss (one for ADmonth predecessors): ");
    granule  = new Granule(gregCal.getGranularityByLocalName("month"), 1978);
    castRes = cs.castDeterminantInstant(granule,
                                        gregCal.getGranularityByLocalName("day")).getGranule().getValue();

    System.out.println("  * below should see one cache hit (one for ADmonth -> ADday mapping): ");
    granule  = new Granule(gregCal.getGranularityByLocalName("month"), 1978);
    castRes = cs.castDeterminantInstant(granule,
                                        gregCal.getGranularityByLocalName("day")).getGranule().getValue();

    System.out.println("  * below should see three cache misses (finer preds of UofAacademicYear, coarser preds of ADhour, and finer preds of ADyear): ");
    granule  = new Granule(uofaCal.getGranularityByLocalName("academicYear"), 0);
    castRes = cs.castDeterminantInstant(granule,
                                        gregCal.getGranularityByLocalName("year")).getGranule().getValue();

    System.out.println("  * below should see eight more finer pred cache misses: ");
    granule  = new Granule(gregCal.getGranularityByLocalName("month"), 1);
    castRes = cs.castDeterminantInstant(granule,
                                        gregCal.getGranularityByLocalName("week")).getGranule().getValue();

    granule  = new Granule(gregCal.getGranularityByLocalName("day"), 1);
    castRes = cs.castDeterminantInstant(granule,
                                        uofaCal.getGranularityByLocalName("term")).getGranule().getValue();

    granule  = new Granule(gregCal.getGranularityByLocalName("hour"), 1);
    castRes = cs.castDeterminantInstant(granule,
                                        uofaCal.getGranularityByLocalName("week")).getGranule().getValue();

    granule  = new Granule(gregCal.getGranularityByLocalName("minute"), 1);
    castRes = cs.castDeterminantInstant(granule,
                                        uofaCal.getGranularityByLocalName("day")).getGranule().getValue();

    granule  = new Granule(gregCal.getGranularityByLocalName("second"), 1);
    castRes = cs.castDeterminantInstant(granule,
                                        gregCal.getGranularityByLocalName("minute")).getGranule().getValue();

    System.out.println("  * now finer pred cache should have had to kick out oldest entry; since ADmonth has been hit,\n    UofAacademicYear should be oldest entry, so below should be cache miss for UofAacademicYear: ");
    granule  = new Granule(uofaCal.getGranularityByLocalName("academicYear"), 3);
    castRes = cs.castDeterminantInstant(granule,
                                        uofaCal.getGranularityByLocalName("term")).getGranule().getValue();

    GranularityLattice.CACHE_DEBUG = false;


    // --------------------- Test simple path interval casts --------------------
    System.out.println("\n\n**** Test 9: Test interval casts that do not require a V-path ****");

    System.out.println("    * Simple interval casts using one given regular mapping:");
      // coarser to finer
    granule  = new Granule(gregCal.getGranularityByLocalName("year"), 501);
    System.out.print("        cast(501 ADyears, ADmonths) = ");
    castRes = cs.castDeterminantInterval(granule,
                                        gregCal.getGranularityByLocalName("month")).getGranule().getValue();
    System.out.print(castRes + " ... ");
    System.out.println((6001 == castRes) ? "PASSED" : "FAILED");

    // finer to coarser
    granule = new Granule(uofaCal.getGranularityByLocalName("term"), 9);
    System.out.print("        cast(9 UofAterms, UofAacademicYear) = ");
    castRes = cs.castDeterminantInterval(granule,
                                        uofaCal.getGranularityByLocalName("academicYear")).getGranule().getValue();
    System.out.print(castRes + " ... ");
    System.out.println((2 == castRes) ? "PASSED" : "FAILED");


    System.out.println("    * Simple interval casts using given regular/irregular mappings:");
      // coarser to finer
    granule  = new Granule(gregCal.getGranularityByLocalName("year"), 3);
    System.out.print("        cast(3 ADyears, ADhours) = ");
    castRes = cs.castDeterminantInterval(granule,
                                        gregCal.getGranularityByLocalName("hour")).getGranule().getValue();
    System.out.print(castRes + " ... ");
    System.out.println((17521 == castRes) ? "PASSED" : "FAILED");

      // finer to coarser
    granule = new Granule(uofaCal.getGranularityByLocalName("day"), 311);
    System.out.print("        cast(311 UofAdays, UofAterm) = ");
    castRes = cs.castDeterminantInterval(granule,
                                        uofaCal.getGranularityByLocalName("term")).getGranule().getValue();
    System.out.print(castRes + " ... ");
    System.out.println((5 == castRes) ? "PASSED" : "FAILED");


    System.out.println("    * Simple casts using given regular/irregular and induced regular mappings:");
      // coarser to finer
    granule  = new Granule(gregCal.getGranularityByLocalName("week"), 4);
    System.out.print("        cast(4 ADweeks, ADseconds) = ");
    castRes = cs.castDeterminantInterval(granule,
                                        gregCal.getGranularityByLocalName("second")).getGranule().getValue();
    System.out.print(castRes + " ... ");
    System.out.println((1814401 == castRes) ? "PASSED" : "FAILED");

    // ---------------------- Test V-path interval casts -----------------------
    System.out.println("\n\n**** Test 10: Test interval casts that do require a V-path ****");

    // finer -> coarser V-path
    granule  = new Granule(gregCal.getGranularityByLocalName("minute"), 86405);
    System.out.print("        cast(86405 ADminutes, UofAdays) = ");
    castRes = cs.castDeterminantInterval(granule,
                                        uofaCal.getGranularityByLocalName("day")).getGranule().getValue();
    System.out.print(castRes + " ... ");
    System.out.println((44 == castRes) ? "PASSED" : "FAILED");

    granule  = new Granule(gregCal.getGranularityByLocalName("hour"), 3360);
    System.out.print("        cast(3360 ADhour, UofAterms) = ");
    castRes = cs.castDeterminantInterval(granule,
                                        uofaCal.getGranularityByLocalName("term")).getGranule().getValue();
    System.out.print(castRes + " ... ");
    System.out.println((2 == castRes) ? "PASSED" : "FAILED");

    granule  = new Granule(uofaCal.getGranularityByLocalName("hour"), 234);
    System.out.print("        cast(234 UofAhours, ADday) = ");
    castRes = cs.castDeterminantInterval(granule,
                                        gregCal.getGranularityByLocalName("day")).getGranule().getValue();
    System.out.print(castRes + " ... ");
    System.out.println((23 == castRes) ? "PASSED" : "FAILED");

    // coarser -> finer V-path
    granule  = new Granule(uofaCal.getGranularityByLocalName("term"), 2);
    System.out.print("        cast(2 UofAterms, ADminute) = ");
    castRes = cs.castDeterminantInterval(granule,
                                        gregCal.getGranularityByLocalName("minute")).getGranule().getValue();
    System.out.print(castRes + " ... ");
    System.out.println((50341 == castRes) ? "PASSED" : "FAILED");

    // coarser -> finer -> coarser V-path
    granule  = new Granule(gregCal.getGranularityByLocalName("month"), 2);
    System.out.print("        cast(2 ADmonths, weeks) = ");
    castRes = cs.castDeterminantInterval(granule,
                                        uofaCal.getGranularityByLocalName("week")).getGranule().getValue();
    System.out.print(castRes + " ... ");
    System.out.println((4 == castRes) ? "PASSED" : "FAILED");
  }
}
