package tauzaman.tests.iotests;

import tauzaman.*;
import java.net.*;
import java.util.*;
import org.w3c.dom.*;


public class TestBaseParser{

  private URL url = null;

  private Element root = null;

  private XMLParser parser = null;

  public TestBaseParser(URL url){

      this.url = url;

      parser = new XMLParser();

      try{
          root = parser.parseURL(url);
      }
      catch(XMLParseException xpe){
          System.out.println("Problem with XML test base parsing: " + xpe);
          System.exit(1);
      }

  }

  public String [] getDeterminateInstants(){
     return getData("determinateInstant");
  }

  public String [] getIndeterminateInstants(){
     return getData("indeterminateInstant");
  }

  public String [] getNowRelativeInstants(){
     return getData("nowRelativeInstant");
  }

  public String [] getIntervals(){
     return getData("interval");
  }

  public String [] getDeterminatePeriods(){
     return getData("determinatePeriod");
  }

  public String [] getIndeterminatePeriods(){
     return getData("indeterminatePeriod");
  }

  public URL [] getPropertyUrls(){
     return getUrls("propertyUrls");
  }

  public URL [] getCalendricSystemUrls(){
     return getUrls("calendricSystemUrls");
  }

  public String [] getServerUrls(){
     return getStrings("serverUrls");
  }

  /* urlType is "serverURL" or "calendricSystemURL" or "propertyURL" */
  private URL [] getUrls(String urlType){

      String strings[] = getStrings(urlType);

      URL urls [] = new URL[strings.length];

      for(int i = 0; i < strings.length; i++){
          try{
              urls[i] = new URL(strings[i]);
          }
          catch(MalformedURLException mue){
              System.out.println("Bad url in " + urlType + " element!" + mue);
              System.exit(1);
          }
      }

      return urls;
  }

  /* dataType is "determinateInstant", "indeterminateInstant", "NowRelativeInstant"
     , "Interval", "Period" */
  private String [] getData(String dataType){

      String data [] = null;

      Vector nodes = parser.locator(root, dataType);

      if(nodes.size() >= 1){
          data = new String[nodes.size()];
          for(int i = 0; i < nodes.size(); i++)
              data[i] = parser.getElementContent((Element)(nodes.elementAt(i)));
      }
      else{
          System.out.println("testBase.xml should contain at least one " + dataType + " element!");
          System.exit(1);
      }

      if(data.length == 0){
          System.out.println("There are no " + dataType + " data in testBase file!");
          System.exit(1);
      }

      return data;
  }


  /* urlType is "serverURL" or "calendricSystemURL" or "propertyURL" */
  private String [] getStrings(String urlType){

      String strings [] = null;

      Vector nodes = parser.locator(root, urlType);

      if(nodes.size() == 1){
          Element node = (Element)(nodes.elementAt(0));
          Node urlsNode = node.getFirstChild();
          if(urlsNode.getNodeType() != Node.TEXT_NODE){
              System.out.println(urlType + " element should contain one and only one Text Node");
              System.exit(1);
          }
          String urlsString = urlsNode.getNodeValue();
          StringTokenizer st = new StringTokenizer(urlsString);

          /* initialize the String array */
          strings = new String[st.countTokens()];

          int index = 0;
          while(st.hasMoreTokens())
              strings[index++] = new String(st.nextToken());

      }
      else{
          System.out.println("testBase.xml should contain only one " + urlType + " element!");
          System.exit(1);
      }

      if(strings.length == 0){
          System.out.println("There are no " + urlType + " urls in testBase file!");
          System.exit(1);
      }

      return strings;
  }

  public String toString(){
      return url.toExternalForm();
  }
}
