package tauzaman.tests;

import java.io.*;

/* use unix style directory delimiters */

public class UpdateSpecFiles{

 private static String absolutePath = null;

 public static void main(String args[]) throws Exception{

     if(args.length != 1){
         System.out.println("usage: java UpdateSpecFiles <absolute path of tauzaman>");
         System.out.println("note: use unix style directory delimiters");
         System.exit(1);
     }

     absolutePath = args[0];

     if( absolutePath.lastIndexOf('/') == (absolutePath.length() - 1 ) )
         absolutePath = absolutePath.substring(0, absolutePath.length() - 1);


     String fileContent = readFile("/iotests/files/base/propertyTable7base.xml");

     writeFile(fileContent.replaceAll("\\Q...absolute path goes here...\\E", absolutePath),
               "/iotests/files/propertyTable7.xml");
 
     fileContent = readFile("/iotests/files/base/propertyTable8base.xml");
    
     writeFile(fileContent.replaceAll("\\Q...absolute path goes here...\\E", absolutePath),
               "/iotests/files/propertyTable8.xml");

     fileContent = readFile("/iotests/files/base/propertyTable1base.xml");
    
     writeFile(fileContent.replaceAll("\\Q...absolute path goes here...\\E", absolutePath),
               "/iotests/files/propertyTable1.xml");

     fileContent = readFile("/iotests/files/base/UofALimitedCalendricSystembase.xml");

     writeFile(fileContent.replaceAll("\\Q...absolute path goes here...\\E", absolutePath),
               "/iotests/files/UofALimitedCalendricSystem.xml");

     fileContent = readFile("/iotests/files/base/UofACalendarbase.xml");

     writeFile(fileContent.replaceAll("\\Q...absolute path goes here...\\E", absolutePath),
               "/iotests/files/UofACalendar.xml");

     fileContent = readFile("/iotests/files/base/ADGregorianCalendarbase.xml");

     writeFile(fileContent.replaceAll("\\Q...absolute path goes here...\\E", absolutePath),
               "/iotests/files/ADGregorianCalendar.xml");

     fileContent = readFile("/iotests/files/base/Makefilebase");

     writeFile(fileContent.replaceAll("\\Q...absolute path goes here...\\E", absolutePath),
               "/iotests/Makefile");

     fileContent = readFile("/application/base/Makefilebase");

     writeFile(fileContent.replaceAll("\\Q...absolute path goes here...\\E", absolutePath),
               "/application/Makefile");

     fileContent = readFile("/iotests/files/base/testBasebase.xml");

     writeFile(fileContent.replaceAll("\\Q...absolute path goes here...\\E", absolutePath),
               "/iotests/testBase.xml");

     

 }

 private static String readFile(String fileName) throws Exception{
      
     BufferedReader input = new BufferedReader(
                                new InputStreamReader(
                                   new FileInputStream(absolutePath + fileName)));

     StringBuffer buffer = new StringBuffer();
     String line;
        
     while ((line = input.readLine()) != null) {
       buffer.append(line + "\n");
     }
        
     input.close();
        
     buffer = buffer.deleteCharAt(buffer.length()-1);
            
     return buffer.toString();
  }

  private static void writeFile(String outputStr, String fileName) throws Exception{

      BufferedWriter output = new BufferedWriter(
                               new OutputStreamWriter(
                                 new FileOutputStream(absolutePath + fileName)));

      output.write(outputStr, 0, outputStr.length());

      output.flush();
      output.close();
  }

}
