package tauzaman.property;

import java.net.*;
import org.w3c.dom.*;

/**
* <code>ImportFormat</code> class represents a import format information 
* that is used to parse a value which was parsed using other
* property. (indirection) 
*
* Some properties make usage of other properties (for example;
* now relative instant input format using instant input format)
* by importing them inside their values.
*
* @author  Curtis Dyreson and Bedirhan Urgun
* @version 0.1, 11/15/02
* @see     tauzaman.property.Property
* @status design complete, implementation complete
*/

public class ImportFormat{
  
  /** Variable name that is stored in format string **/
  private String variable = null;

  /** Name of the property content of the variable will be parsed with **/
  private String name = null;

  /** Url of property to be used **/
  private URL url = null;
  
  /**
  * Constructs a <code>Format</code> object, from given DOM node parsed
  * from Property Specification file.
  *
  * @param root DOM Element 
  * @param url URL of Property Specification file this ImportFormat is gotten
  *
  * @throws PropertyFormationException if any problem occurs
  * when parsing the property specification file
  */ 
  public ImportFormat(Element root, URL url) throws PropertyFormationException{
      formImportFormat(root, url); 
  }

  /**
  * Initializes this <code>ImportFormat</code> from DOM Node, which points to
  * a importFormat element in the Property Specification file.
  *
  * @param root DOM Element 
  * @param url URL of Property Specification file this ImportFormat is gotten
  *
  * @throws PropertyFormationException if any problem occurs
  * when parsing the property specification file
  */
  private void formImportFormat(Element root, URL url) throws PropertyFormationException {

      if(root.hasAttribute("variable"))
          variable = root.getAttribute("variable");
      else
          throw new PropertyFormationException("Exception when parsing xml file in: " + 
                                      url.toExternalForm() + " no variable is defined!");

      if(root.hasAttribute("name"))
          name = root.getAttribute("name");
      else
          throw new PropertyFormationException("Exception when parsing xml file in: " + 
                                          url.toExternalForm() + " no name is defined!");

      if(root.hasAttribute("using")){
          try{
              this.url = new URL(root.getAttribute("using"));
          }
          catch(MalformedURLException e){
              throw new PropertyFormationException("Exception when parsing xml file in: " + 
                                                      url.toExternalForm() + " bad URL!", e);
          }
      }
      else
          this.url = url;
  }


  /* Accessor methods */

  /** 
  * Returns the name of the variable 
  * @return name of the variable in property format
  **/
  public String getVariableName(){
      return variable;
  }

  /** 
  * Returns the name of the field value
  * @return name of the field name in property format 
  **/
  public String getFormatName(){
      return name;
  }

  /** 
  * Returns the url of property 
  * @return url of the property format
  **/
  public URL getFormatPropertyUrl(){
      return url;
  }

  /** 
  * toString method
  * @return string representation of this object 
  **/
  public String toString(){
      /* return as string all three String variables */
      return "ImportFormat: " + getVariableName() + " " + getFormatName() + " " + 
                                           getFormatPropertyUrl().toExternalForm() ;
  }
  
}
