package tauzaman.property;
import org.w3c.dom.*;
import java.util.*;

import tauzaman.XMLParser;

/**  
* <code>Format</code> class represents a formatting information
* of an input or output temporal constant.
* @author  Curtis Dyreson and Bedirhan Urgun
* @version 0.1, 11/15/02
* @see     tauzaman.property.Property
* @see     tauzaman.property.ImportFormat
* @status design complete, implementation complete
*/


public class Format{
  
  /** Content of the format **/
  private String formatString = null;

  /** Determines whether this format is whitespace friendly or not 
  *   if it is false then it is not whitespace friendly, o.w. it is true.   
  */
  private boolean formatWhitespace = true;
  
  /**
  * Constructs a <code>Format</code> object, from given DOM node parsed
  * from Property Specification file.
  *
  * @param root DOM Element
  */
  public Format(Element root){
      formFormat(root);
  }

  /**
  * Initializes this <code>Format</code> from DOM Node, which points to
  * a format element in the Property Specification file.
  *
  */ 
  private void formFormat(Element root){

      String whitespaceAttrValue = (root.getAttribute("whitespace").trim()).toLowerCase();
      if(whitespaceAttrValue.equals("no"))
          formatWhitespace = false;

      XMLParser parser = new XMLParser();
      formatString = (parser.getElementContent(root))/*.trim()*/;
  }


  /* Accessor Methods*/
  
  /** 
  * Returns whether this format is whitespace friendly or not 
  * @return whitespace friendly attribute of this Format
  */
  public boolean isFormatWhitespaceFriendly(){
      return formatWhitespace;
  }

  /** 
  * Returns the formatString of this format 
  * @return this Format as a string
  */
  public String getFormatString(){
      return formatString;
  }
    
  /**
  * toString method
  * @return string representation of this object
  */
  public String toString(){
      /* returns formatString */
      return "Format: " + getFormatString(); 
  }
}
