package tauzaman.field;

import java.net.*;  
import java.lang.reflect.*;
import java.lang.*;
import org.w3c.dom.*;

import tauzaman.field.fvsupport.FVSupport;
import tauzaman.*;

/** 
* <code>FVFunction</code> class represents a generic table 
* class for Field Value functions. 
*
*
* @author  Bedirhan Urgun and Curtis Dyreson
* @version 0.1, 10/10/02
* @see     tauzaman.ClassLoaderMethodCaller
* @status design complete, implementation complete
*/

/* no regex for fvfunction. but easy to put one */

public class FVFunction extends FVSupport{

  /**
  * An instance of <code>ClassLoaderMethodCaller</code>, which will provide
  * access to field value functions, which are loaded dynamically.
  */
  private ClassLoaderMethodCaller clmc = null;

  /** 
  * Constructs a <code>FVFunction</code> object form a given label, url and 
  * a regex for this Function strings from Field Value Function XML file.
  *
  * @param url URL of actual information
  * @param regex regular expression that will be used to parse a temporal
  * constant input string
  *
  * @throws FVFormationException if any problem happens during formation of
  * dynamic class loading pointed by url  
  * @see tauzaman.calendricsystem.CalendricSystem 
  */
  public FVFunction(URL url) throws FVFormationException{
      this.url = url;
      formFVFunction();
  }
 
  /**
  * Forms a FVFunction from url, which contains a java class file that includes
  * actual content of this <code>FVFunction</code>.  
  *
  * @throws FVFormationException if any problem happens during formation of
  * dynamic class loading pointed by url  
  */
  private void formFVFunction() throws FVFormationException{

      String stringUrl = url.toExternalForm();

      /* form CLMC instance here by using implUrl */
      URL urls[] = new URL[1];
      
      String classUrl = null, className = null;
      
      /* we are sure that stringUrl ends with .class but still... */
    
      //get the useful part of URL
      if(stringUrl.endsWith(".class")){
          classUrl = stringUrl.substring(0, stringUrl.lastIndexOf('/') + 1);
          className = stringUrl.substring(stringUrl.lastIndexOf('/') + 1, stringUrl.length());
          className = className.substring(0, className.lastIndexOf(".class"));
      }
      else
          throw new FVFormationException("Exception when forming calendar: "+ url.toExternalForm() +
                                                                   " should end with .class: " + stringUrl);
      /* form the url array */
      try{ urls[0] = new URL(classUrl); }
      catch(MalformedURLException e){
          throw new FVFormationException("Exception when forming URL from: " + classUrl + " bad URL!", e);
      }

      /* form instance of CLMC */
      clmc = new ClassLoaderMethodCaller(urls);
      
      /* load the class in CLMC */
      try{
          /* fix method names */
          clmc.loadClass(className, "indexToString");
          clmc.loadClass(className, "stringToIndex");
      }
      catch(DynamicLoadException dle){
          throw new FVFormationException("Exception when loading class:" + className +
                                                                    " in: " + url.toExternalForm(), dle);
      }
  }

  /** 
  * Converts a given string to corresponding index.
  * <pre>
  * <i>Given</i> <b>January</b> for Gregorian calendar and using 
  * a table called "EnglishMonthNames", this method returns
  * <b>1</b> as the index of <b>January</b>.
  * </pre>
  *
  * @param string string representation of input
  *
  * @return long which is corresponding index of a string
  *
  * @throws FVServiceException if any problem occurs during process
  * of dynamically loaded method
  *
  * @see tauzaman.field.FVFunction#indexToString
  */  
  public long stringToIndex(String string) throws FVServiceException{
      long index;

      Class parameterTypes [] = new Class [1];

      try{
          parameterTypes[0] = Class.forName("java.lang.String");
      }
      catch(ClassNotFoundException cnfe){
          throw new FVServiceException("Exception in FVFunction's stringToIndex method: package corrupted", cnfe);
      }

      try{

          Object args[] = new Object[1];   
          args[0] = string;

          Object returnValue = clmc.callMethod("stringToIndex", parameterTypes, args);
       
          index = ((Long)returnValue).longValue();

      }
      catch(DynamicLoadException dle){
          throw new FVServiceException("Exception in FVFunction's stringToIndex method: " +
                                                               url.toExternalForm(), dle);
      }

      return index;
  }

  /** 
  * Converts a given integer to corresponding string.
  * <pre>
  * <i>Given</i> <b>1</b> for Gregorian calendar and using 
  * a table called "EnglishMonthNames", this method returns
  * <b>January</b> as the string corresponding of <b>1</b>.
  * </pre>
  *
  * @throws FVServiceException if any problem occurs during process
  * of dynamically loaded method
  *
  * @return String string corresponding of long index
  *
  * @param index integer representation of input 
  * @see tauzaman.field.FVFunction#stringToIndex
  */  
  public String indexToString(long index) throws FVServiceException{
      String string = null;

      Class parameterTypes [] = new Class [1];

      try{
          parameterTypes[0] = Class.forName("java.lang.Long");
      }
      catch(ClassNotFoundException cnfe){
          throw new FVServiceException("Exception in FVFunction's indexToString method: package corrupted", cnfe);
      }

      try{

          Object args[] = new Object[1];   
          args[0] = new Long(index);

          Object returnValue = clmc.callMethod("indexToString", parameterTypes, args);
       
          string = (String)returnValue;

      }
      catch(DynamicLoadException dle){
          throw new FVServiceException("Exception in FVFunction's indexToString method: " + 
                                                                 url.toExternalForm(), dle);
      }

      return string;
  }  
 
  /**
  * toString method, which produces string representation of
  * this <code>FVFunction</code>.
  * 
  * @return a String, which is a representation of this <code>FVFunction</code>
  */
  public String toString(){
      String result = "FVFunction: " + url.toExternalForm();
      result = result.concat("\n\tLoaded class and methods: \n\t  " + clmc.toString());

      return result;
  }
}
