package tauzaman.calendricsystem;

import tauzaman.calendar.*;

import java.net.URL;
import java.util.*;

/*
 do we want this class to be public?
*/


/**  
* <code> CalendricSystemRepositoryr </code> class is the entrance point of calendric 
* systems and calendars that they contain. It forms and maintains  
* new <code>CalendricSystem</code> and <code>Calendar</code>s 
* through a <code>CalendarRepository</code>. For a user to use services of 
* <b><i>tauzaman</i></b> there are two main registration process. One of them is
* done once, which is registering to system. And the other one, is registering 
* to a service of a particular <code>CalendricSystem</code>. Latter can be done
* for a limited number of times depending on the maximum number of different 
* <code>CalendricSystem</code>s that can be used.
*        
* @author  Curtis Dyreson and Bedirhan Urgun
* @version 0.1, 11/15/02
* @see     tauzaman.calendricsystem.CalendricSystem
* @see     tauzaman.calendar.Calendar
* @status design complete, implementation complete
*/  


public class CalendricSystemRepository{

  /** 
  * A Hashtable, whose keys are URLs of <code>CalendricSystem</code>s and values are
  * <code>CalendricSystem</code> handles.
  */
  private Hashtable calendricSystems = null;

  /**
  * A handle to unique <code>CalendarRepository</code> that this
  * <code>CalendricSystemRepository</code> uses.
  */
  private CalendarRepository cr = null;

  /** 
  * Constructs a Calendric System Manager and  
  * allocates memory for database of <code>CalendricSystem</code>.
  * @param cr unique <code>CalendarRepository</code> that this
  * <code>CalendricSystemRepository</code> uses
  */
  public CalendricSystemRepository(CalendarRepository cr){

     /* allocate memory for calendric system list */
     calendricSystems = new Hashtable();

     this.cr = cr;
  }

  /**
  * Loads a <code>CalendricSystem</code>, given its URL and returns a handle to loaded 
  * <code>CalendricSystem</code>. If a <code>CalendricSystem</code> with given URL already
  * exists in the database, then just return a handle without further loading.
  * 
  * @param url URL of <code>CalendricSystem</code> specification to be loaded
  * 
  * @throws CalendricSystemFormationException if there is any problem occurs
  * when parsing the specification file pointed by URL 
  *
  * @return a handle to loaded <code>CalendricSystem</code>
  *
  */
  /* @see tauzaman.calendricsystem.CalendricSystemRepository#unloadCalendricSystem */
  public CalendricSystem loadCalendricSystem(URL url) throws CalendricSystemFormationException{
      /* check the hashtable, if it exists, return, else get it and add it to database and return */ 
      CalendricSystem cs = null;
 

      if(calendricSystems.containsKey(url)){
          cs = (CalendricSystem)calendricSystems.get(url);
      }
      else{
          cs = new CalendricSystem(cr, url);
          calendricSystems.put(url, cs);
      }

      return cs;
  }

  /**
  * Unloads an already registered <code>CalendricSystem</code> given its URL. Below criterias should be
  * met in order this method to unload <code>CalendricSystem</code> given it's URL.
  * 
  * <ul>
  *  <li>
  *     <code>CalendricSystem</code> should exists in database. 
  *  </li> 
  *  <li>
  *     <code>CalendricSystem</code> should be idle, in other words, no other user (local or remote) uses it.
  *  </li> 
  *  <li>
  *   ...
  *  </li> 
  * </ul> 
  *
  * 
  * Should this criteria met, according to the current load of this tauZaman system, an algorithm 
  * here can decide, which algorithm to remove this <code>CalendricSystem</code> will be used. 
  *
  * @param url URL of <code>CalendricSystem</code> to be unloaded
  *
  * @see tauzaman.calendricsystem.CalendricSystemRepository#loadCalendricSystem
  */
//  public void unloadCalendricSystem(URL url) {
//  
//  }

  /**
  * Returns urls of all <code>CalendricSystem</code>s in the database.
  *
  * @return array of URLs
  */
  public URL [] getAllCalendricSystemUrls(){
      return null;
  }


  /** 
  * Returns a handle to <code>CalendricSystem</code> in the database. Returns
  * null if there is no such <code>CalendricSystem</code> in the system.
  *
  * @param url URL of the <code>CalendricSystem</code> that is looked for. 
  * @return a handle to <code>CalendricSystem</code> found in the database.
  */
  private CalendricSystem getCalendricSystem(URL url) {
      return null;
  }

  /** 
  * Returns urls of all <code>CalendricSystem</code>s.
  * 
  * @return a string representation of URLs
  */
  public String toString(){

     String s = "CalendricSystems: ";

     Enumeration urls = calendricSystems.keys();
     
     while(urls.hasMoreElements()){
        URL url = (URL)urls.nextElement();
        s = s.concat("\n" + ((CalendricSystem)calendricSystems.get(url)).toString());
     }
    
     return s;
  }

}
