package tauzaman.calendar;

import java.net.URL;
import java.util.Hashtable;

/**
* <code>CalendarRepository</code> class manages a collection of Calendar(s).  
* For example:
* <pre>
*    CalendarRepository cr = new CalendarRepository();
*    cr.loadCalendar(new URL("http://www.eecs.wsu.edu/greg.xml"));
* </pre>
*
* @author  Curtis Dyreson and Bedirhan Urgun
* @version 0.1, 11/15/02
* @see     tauzaman.calendar.Calendar
* @status design complete, implementation complete
*/

public class CalendarRepository {

  /** 
  * Currently loaded <code>Calendar</code>s in this <code>CalendarRepository</code> 
  */
  private Hashtable calendarCache = null;
 
  /**
  * Constructs a <code>CalendarRepository</code> object. 
  * It also forms a Hashtable, in which keys are URLs and values 
  * are <code>Calendar</code> objects.
  */
  public CalendarRepository() {
      calendarCache = new Hashtable();
  }

  /**
  * <p>Loads a <code>Calendar</code> into this <code>CalendarRepository</code>. If
  * Calendar with given URL does not exist in this <code>CalendarRepository</code>
  * then URL will chased and <code>Calendar</code> that it points will be loaded and
  * a handle to loaded <code>Calendar</code> will be returned. </p><p> 
  * Otherwise, if Calendar with given URL exists in this <code>CalendarRepository</code>
  * then a a handle to existing <code>Calendar</code> will be returned.</p> That's, keep 
  * silent.
  * 
  *
  * @param url Url of Calendar specification file.
  * @return a handle to loaded <code>Calendar</code>  
  * 
  * @throws CalendarFormationException if there is any problem with
  * parsing the file that given URL points
  * 
  */
  public Calendar loadCalendar(URL url) throws CalendarFormationException{
      
      Calendar calendar = null;

      /* check whether calendarCache has it */
      if(calendarCache.containsKey(url))
          calendar = (Calendar)calendarCache.get(url);
      else{
          /* load the calendar and put it into repository */
          calendar = new Calendar(url);
          calendarCache.put(url, calendar);
      }

      return calendar;
  }

  /** 
  * Unload a <code>Calendar</code> from this <code>CalendarRepository</code>, the 
  * <code>Calendar</code> is specified by an URL. 
  * If there is no <code>CalendricSystem</code> referencing this <code>Calendar</code> 
  * and unloading behaviour is "deep", then remove the <code>Calendar</code>.
  * Otherwise <code>Calendar</code> remains. 
  * If there is no such <code>Calendar</code> in the system, then keep silent.
  * 
  * @param url URL of Calendar Specification file
  * @param b boolean, determines the behaviour of unloading
  *
  * @see tauzaman.calendar.CalendarRepository
  */
//  public void unloadCalendar(URL url, boolean deep){
     /*
        if calendar.getRefCount == 0 && b == true
           remove calendar
        else
           can throw and exception  
        removing a calendar without removing all CS that it points is unacceptable
     */
//  }

  /** 
  * Returns true if a <code>Calendar</code> specified with its URL exists in this
  * <code>CalendarRepository</code>, false otherwise.
  *
  * @param url URL of Calendar Specification file
  * @return a boolean, which is true if a <code>Calendar</code> 
  * specified with its URL exists in this<code>CalendarRepository</code>, 
  * false otherwise.
  */
//  public boolean calendarExists(URL url) {
//    return false;
//  }

  /** 
  * This refresh refreshes all the <code>Calendar</code>s in this <code>CalendarRepository<>.
  * 
  * @throws CalendarFormationException if there is any problem with
  * parsing the file that given URL points
  * 
  */
//  public void refresh() throws CalendarFormationException{
//  }

  /** 
  * Refresh checks the modification time of the <code>Calendar</code> given its URL and
  * reloads the <code>Calendar</code> if it has been modified since the last load.
  *
  * @param url URL of Calendar Specification file
  *
  * @throws CalendarFormationException if there is any problem with
  * parsing the file that given URL points
  */
//  public void refresh(URL url) throws CalendarFormationException{
//  }

  /**
  * Returns all URLs in this <code>CalendarRepository<>.
  * 
  * @return String representation of urls tokenized with a blankspace
  */
  public String toString(){
     return null;
  }
}
