package tauzaman;

import java.rmi.server.*;
import java.rmi.*;
import java.net.*;
import java.io.*;
import tauzaman.*;

import tauzaman.property.*;                         
import tauzaman.calendricsystem.*;        

/**
* <p>
* <code>TauZamanRemoteServiceHandlerImpl</code> class implemets 
* <code>TauZamanRemoteServiceHandler</code> interface, which enables a
* <code>TauZamanSystem</code> to be set as a server. Once this class
* is initialized and set, then clients can connect and fetch
* <code>TauZamanRemoteService</code>s from this class.</p><p>
* <code>TauZamanRemoteServiceHandlerImpl</code> is itself a remote class. 
* </p>
*
* @author Curtis Dyreson and Bedirhan Urgun
* @version 0.1. 01/27/02
* @status design complete, implementation complete
*
* @see tauzaman.TauZamanRemoteServiceHandler
* @see tauzaman.TauZamanSystem
* @see tauzaman.TauZamanRemoteService
*/

public class TauZamanRemoteServiceHandlerImpl extends UnicastRemoteObject implements TauZamanRemoteServiceHandler{

  /** A handle to parent <code>TauZamanSystem</code> **/
  private TauZamanSystem parentSystem = null;

  /**
  * Constructs a <code>TauZamanRemoteServiceHandlerImpl</code>.
  * 
  * @param parentSystem parent <code>TauZamanSystem</code> form which
  * this class is instantiated
  * @param log a boolean value, which determines if this server will keep logs
  * of remote calls. If it is true, server keeps log, o.w. server will not keep log
  *
  * @throws RemoteException if an abnormal condition occurs during remote connection
  * @throws FileNotFoundException if log file can not be opened
  */
  protected TauZamanRemoteServiceHandlerImpl(TauZamanSystem parentSystem, boolean log) throws RemoteException, FileNotFoundException{
     super();
     this.parentSystem = parentSystem;
     if(log){
         // no append
         FileOutputStream myLog = new FileOutputStream("logs.txt");
         setLog(new BufferedOutputStream(myLog));
     }
  }

  /**
  * Returns a <code>TauZamanRemoteService</code> with a default <code>CalendricSystem</code>
  * and <code>Property</code> list.
  *
  * @param calendricSystemName String name, given by user, which loaded default <code>CalendricSystem</code>
  * will be referred as
  * @param calendricSystemUrl default <code>CalendricSystem</code> for this <code>TauZamanService</code>
  * @param defaultPropertiesUrl default <code>Properties</code> related to default <code>CalendricSystem</code>
  *
  * @return a <code>TauZamanRemoteService</code> ready to serve
  *
  * @throws RemoteException if an abnormal condition occurs during remote connection
  *
  * @throws CalendricSystemFormationException if any abnormal condition occurs when loading
  * default <code>CalendricSystem</code> for the fetched remote service
  *
  * @throws PropertyFormationException if any abnormal condition occurs when loading       
  * default <code>Property</code> list for the fetched remote service  
  */
  public TauZamanRemoteService getService(String calendricSystemName, URL calendricSystemUrl, URL defaultPropertyListUrl) 
                                   throws RemoteException, CalendricSystemFormationException, PropertyFormationException{

      return new TauZamanRemoteServiceImpl(parentSystem, calendricSystemName, calendricSystemUrl, defaultPropertyListUrl);

  }
}
