package tauzaman;

/**
* <code>TauZamanException</code> class represents a throwable object 
* which is the root of tauZaman system's Exception hieararchy. All other
* exceptions are derived from this class. This is a <b>checked</b> exception.
* 
* @author Curtis Dyreson and Bedirhan Urgun
* @version 0.1. 01/06/02
* @status Design complete, implementation complete
*/

public class TauZamanException extends Exception{
 
  /**
  * Constructs a <code>TauZamanException</code> object given a detailed explanation of
  * abnormal condition in String message.
  *
  * @param message a detailed explanation of abnormal condition
  */
  public TauZamanException(String message){
      super(message);
  }

  /**
  * Constructs a <code>TauZamanException</code> object given a detailed explanation of
  * abnormal condition in String message and another exception, which
  * is the immediate cause of this exception.
  *
  * @param message a detailed explanation of abnormal condition
  * @param cause a Throwable object, which is the cause of this exception
  */
  public TauZamanException(String message, Throwable cause){
      super(message, cause);
  }

}
