/**
 * 
 */
package cs.arizona.util;


// Import log4j classes.
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Level;

/**
 * @author Stephen W. Thomas
 * Class to output debugging information in a standard, easy way. 
 * Example use in code:
 * TauLogger.logger.info("My error message!");
 * Output in console:
 * INFO [cs.arizona.tau.xml.Primitives::glueItemsFromTwoVersions] 
 *   My error message!
 *
 */
public class TauLogger {

	public static Logger logger = Logger.getLogger(TauLogger.class);
	private static Boolean isInitialized = Boolean.FALSE;


	public static void init(){
		if (isInitialized == Boolean.FALSE){
			isInitialized = Boolean.TRUE;
		
		    String pattern = "INFO [%C::%M] %n";
		    pattern +=       "    %m %n %n"; 
			PatternLayout layout 	 = new PatternLayout(pattern);
		    ConsoleAppender appender = new ConsoleAppender(layout);
		    logger.addAppender(appender);
		}
		
	}
	
	public static void setLevel(int l){
		switch (l){
			case 0: logger.setLevel((Level)Level.OFF); 		break;
			case 1: logger.setLevel((Level)Level.FATAL); 	break;
			case 2: logger.setLevel((Level)Level.ERROR); 	break;
			case 3: logger.setLevel((Level)Level.DEBUG); 	break;
			case 4: logger.setLevel((Level)Level.ALL); 		break;
		}
		
	}
	
}
