/**
 * 
 */
package cs.arizona.util;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Enumeration; 

import org.apache.bcel.generic.GETSTATIC;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.*;

import cs.arizona.tau.xml.TXSchemaConstants;
 
/**
 * @author Alex Henniges
 *
 * Class will replace SchemaPathEvaluator.
 */
public class TargetIdentifier {

	Document schemaDoc;			//Stores the DOM tree for Normalized Snapshot Schema
	String xmlSchemaName = TXSchemaConstants.SCHEMA_NAME_PREFIX; 		//The variable stores the name given to W3C specification schema "http://www.w3.org/2001/XMLSchema"
	//String xmlSchemaName = "xsd:"; // for temporary fix
	Hashtable<String, Element> elementTable;
	Hashtable<String, Element> groupTable;
	Hashtable<String, Element> complexTypeTable;
	Hashtable<String, Element> attributeGroupTable;
	
	
	
	/**
	 * @schemaDoc - is the Document tree for the schema for which SchemaPath expressions will be evaluated. 
	 */
	public TargetIdentifier(Document schemaDoc){
		this.schemaDoc = schemaDoc;
		fillHashTables();
	}
	
        /**
         * Returns the element given by elementName.
         *
         * @elementName - The name of the element in the schema document.
         * @return - Element found with elementName. Null if not found.
         */
	public Element getTarget(String elementName) {
		Element schemaElement = schemaDoc.getDocumentElement();
		Element topLevelElement = null;
		NodeList nl = schemaElement.getElementsByTagName(xmlSchemaName + "element");
 		for(int i = 0; i < nl.getLength(); i++) {
	       		Element e = (Element) nl.item(i);
			String name = e.getAttribute("name");
			if(name.equals(elementName) && e.getAttribute("ref").equals("") ) {
				return e;
			}
        }
		return null;	
	}
	
	// TODO: Not Working. Add functionality here.
	public boolean validateField(Element element, String fieldPath){
		if (fieldPath.equals("/text")){
			return true;
		}else
		if (fieldPath.startsWith("/@")){
			NodeList nl = element.getElementsByTagName(xmlSchemaName + "attribute");
			for (int i=0 ; i<nl.getLength() ; i++){
				if (fieldPath.substring(2).equals(((Element)nl.item(i)).getAttribute("name"))){
					return true;
				}
			}
			TauLogger.logger.error("Target path \"" + fieldPath + "\" was not found.");
			return false;
		}else{
			TauLogger.logger.error("Target path \"" + fieldPath + "\" does not start wtih \"/@\".");
			return false;
		}
	}
	
	/**
	 * The function returns the top element in the document.
	 * @return
	 */
	public Element getTopLevelElement(){
		Hashtable<String, Element> tempElementTable = new Hashtable<String, Element>();
		Enumeration<String> elementKeys = elementTable.keys();

		//Replicate elementTable into tempElementTable
		while (elementKeys.hasMoreElements()){
			String key = elementKeys.nextElement();
			tempElementTable.put(key,elementTable.get(key));
		}
		Element schemaElement = schemaDoc.getDocumentElement();
		Element topLevelElement = null;
		NodeList nl = schemaElement.getElementsByTagName(xmlSchemaName + "element");
		for (int i=0 ; i<nl.getLength() ; i++){
			if (nl.item(i).getNodeType() == Node.ELEMENT_NODE ){
				Element currentElement = (Element)nl.item(i);
				
				//Want to remove "element" elements that are actually just refs
				if (currentElement.getAttribute("ref")!=""){
					tempElementTable.remove(currentElement.getAttribute("ref"));
				}
			}
		}
		
		Enumeration<Element> enumeration = tempElementTable.elements();
		while (enumeration.hasMoreElements()){
			topLevelElement = (Element)enumeration.nextElement();	
		}
		return topLevelElement;
	}
	
	/* The function returns the child attribute elements for the given element */
	public Hashtable<String, Element> getChildAttributes(String elementName){

		Hashtable<String, Element> attributeTable = new Hashtable<String, Element>();
		Element e = getTarget(elementName);
		// If getTarget returned null, return empty table.
                if(e == null) {
                  return attributeTable;
                }

		// Check attributeGroup children of element
		NodeList nl = e.getElementsByTagName(xmlSchemaName + "attributeGroup");	
		for (int i=0 ; i<nl.getLength() ; i++){
			
			Element attrGroupElement = (Element)nl.item(i);
			attrGroupElement = (Element)attributeGroupTable.get(attrGroupElement.getAttribute("ref"));

			NodeList nl1 = attrGroupElement.getElementsByTagName(xmlSchemaName + "attribute");
			for (int j=0 ; j<nl.getLength() ; j++){
				Element attrElement = (Element)nl1.item(i);
				attributeTable.put(attrElement.getAttribute("name"), attrElement);
			}
		}
		
                // Check attribute children of element
		nl = e.getElementsByTagName(xmlSchemaName + "attribute");
		for (int i=0 ; i<nl.getLength() ; i++){
			Element attrElement = (Element)nl.item(i);
			attributeTable.put(attrElement.getAttribute("name"), attrElement);
		}
		return attributeTable;
	}
	
	/* The function returns the immediate child elements of the given element
	 * TODO: The function right now supports only <sequence> element.
	 * 		 Either need to be modified or need to write a new function that would return 
	 * 		 elements enclosed in <choice> and <all>
	 */
	public ArrayList<Element> getChildElements(String elementName){
		ArrayList<Element> childElementList = new ArrayList<Element>();
		Element e = getTarget(elementName);
		// If getTarget returned null, return empty list.
                if(e == null)
                {
                   return childElementList;
                }
		if (null != e.getAttribute("type")){
			e = (Element)complexTypeTable.get(e.getAttribute("type"));
		}

		addGroupElements(childElementList, e);
		
		NodeList nl = e.getElementsByTagName(xmlSchemaName + "element"); 
		for (int i=0 ; i<nl.getLength() ; i++){
			Element childElement = (Element)nl.item(i);
			childElementList.add(childElement);
		}
		
		return childElementList;
	}
	

	/* Given a element, the function adds all the elements in all the nested groups recursively to the childElementList */ 
	private void addGroupElements(ArrayList childElementList, Element e){
		NodeList nl = e.getElementsByTagName(xmlSchemaName + "group"); 
		
		for (int i=0 ; i<nl.getLength() ; i++){
			
			Element groupElement = (Element)nl.item(i);
			groupElement = (Element)groupTable.get(groupElement.getAttribute("ref"));
			
			addGroupElements(childElementList, groupElement);

			NodeList nl1 = groupElement.getElementsByTagName(xmlSchemaName + "element");
			for (int j=0 ; j<nl.getLength() ; j++){
				Element childElement = (Element)nl1.item(i);
				childElementList.add(childElement);
			}
		}
	}
	
	/**
	 * The function stores the name given to W3C specification schema "http://www.w3.org/2001/XMLSchema" in xmlSchemaName.
	 * 
	 */
	private void getXMLSchemaName(){
		//Get attributes of topmost element (which is schema in this case)	
		NamedNodeMap attributes = schemaDoc.getDocumentElement().getAttributes();
		for (int i=0 ; i<attributes.getLength() ; i++){
			Attr attr = (Attr)attributes.item(i);
			String attrName = attr.getName();
			String attrValue = attr.getValue();
			//If attribute's name contains xmlns, check whether its value is "http://www.w3.org/2001/XMLSchema". If yes, store the name in 
			//variable xmlSchemaName
			if (attrName.indexOf("xmlns") != -1){
				if (attrValue.equals("http://www.w3.org/2001/XMLSchema")){
					xmlSchemaName=attrName.substring(attrName.indexOf(":")+1) + ":";
				}
			}
		}
	}
	
	private void fillHashTables(){
		elementTable = new Hashtable<String, Element>();
		groupTable = new Hashtable<String, Element>();
		complexTypeTable = new Hashtable<String, Element>();
		attributeGroupTable = new Hashtable<String, Element>();
		Element schemaElement= schemaDoc.getDocumentElement();
		NodeList nl= schemaElement.getChildNodes();
		for (int i=0 ; i<nl.getLength() ; i++){
			if (nl.item(i).getNodeType() == Node.ELEMENT_NODE ){
				Element element = (Element)nl.item(i);
				if ("element".equals(element.getLocalName())){
					elementTable.put(element.getAttribute("name"),element);
				}else
					if ("group".equals(element.getLocalName())){
						groupTable.put(element.getAttribute("name"),element);
					}else
						if ("complexType".equals(element.getLocalName())){
							complexTypeTable.put(element.getAttribute("name"),element);
						}else
							if ("attributeGroup".equals(element.getLocalName())){
								attributeGroupTable.put(element.getAttribute("name"),element);
							}
			}
		}
	}
	
        private String printTable(char c) {
                switch(c) {
                   case 'e': return elementTable.toString();
                   case 'g': return groupTable.toString();
                   case 'c': return complexTypeTable.toString();
                   case 'a': return attributeGroupTable.toString();
                   default: return "";
                }
        }
}
