package cs.arizona.tau.xml.temporalconstraint;

import java.util.HashSet;
import java.util.Set;
import java.util.Vector;

import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;

import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import cs.arizona.tau.xml.TXSchemaConstants;
import cs.arizona.util.ConventionalParser;

public class SequencedConstraintChecker {

  public static boolean CheckSequencedConstraints(
      String temporal_data_dir, String temporal_document_name,
      String temporalSchema, String conventional_schema,
      Document schema_doc) {
    int passed = 0;
    int num_fails = 0;
    long st = System.currentTimeMillis();
    ConventionalParser cp = ConventionalParser.getInstance();
    Document temporal_document =
    cp.parseDocument(temporal_data_dir + "/" + temporal_document_name,
                     null, conventional_schema,
                     false);
    //ExtractSeqConstraintRelatedContent(temporal_document);
    Vector<String> constraint_collection = new Vector<String>();
    /*
    constraint_collection.add("//catalog//item//attributes//ISBN");
    constraint_collection.add("//catalog//item//attributes//number_of_pages");
    constraint_collection.add("//catalog//authors//author");
    constraint_collection.add("//catalog//item//related_items//related_item//item_id");
    */
    /*
    constraint_collection.add("ISBN");
    constraint_collection.add("number_of_pages");
    constraint_collection.add("author");
    constraint_collection.add("item_id");
    */
    constraint_collection =
        SequencedConstraintChecker.ExtractConstraintTokens(schema_doc);
    //long st0 = System.currentTimeMillis();
    Vector<Set<String>> path_nodes = GetAllPath(temporal_document,
                                                constraint_collection);
    //System.out.println("Get all paths: " + (System.currentTimeMillis() - st0));
    //st0 = System.currentTimeMillis();
    Node root_node = FilterDocument(path_nodes, temporal_document);
    //System.out.println("Reduce Document: " + (System.currentTimeMillis() - st0));
    //cp.writeElement((Element)root_node, "/home/ruizhang/Desktop/root.xml");
    Vector<Document> all_slices = RealUnSquash.PerformRealUnSquash(
        temporal_data_dir, root_node, conventional_schema);
//      String schemaLang = "http://www.w3.org/2001/XMLSchema";
    /*
    SchemaFactory factory = SchemaFactory.newInstance(
        XMLConstants.W3C_XML_SCHEMA_NS_URI);
    try {
      Schema schema = factory.newSchema(new StreamSource(conventional_schema));
      Validator validator = schema.newValidator();
      validator.setErrorHandler(new MyErrorHandler());
      for (int i = 0; i < all_slices.size(); ++i) {
//        ConventionalParser.getInstance().writeDocument(
//            all_slices.get(i), "/tmp/temp_doc_" + i + ".xml");
        try {
          validator.validate(new DOMSource(all_slices.get(i)));
      ++passed;
        } catch (SAXException sax_ex) {
          System.err.println(
              "sequenced constraint violation found in slice #" + passed);
        System.err.println("Details: " + sax_ex.getMessage());
        ++num_fails;
        } catch (Exception ex) {
          System.err.println(
              "sequenced constraint violation found in slice #" + passed);
      System.err.println("Details: " + ex.getMessage());
        }
      }
    } catch (SAXException sax_ex) {
      sax_ex.printStackTrace();
    }
    */
    long et = System.currentTimeMillis();
    System.out.println(
        "Checking Sequenced Constraints: " + ((et - st)/1000.0) + " sec.");
    return (num_fails == 0);
  }

  
  public static Vector<String> ExtractConstraintTokens(
      Document schema_doc) {
    Set<String> constraint_tokens = new HashSet<String>();
    NodeList key_def = schema_doc.getElementsByTagName(
        TXSchemaConstants.SCHEMA_NAME_PREFIX + "key");
    for (int i = 0; i < key_def.getLength(); ++i) {
      Element key_element = (Element)(key_def.item(i));
      Element selector_element =
          (Element)(key_element.getElementsByTagName(
              TXSchemaConstants.SCHEMA_NAME_PREFIX + "selector").item(0));
      Element field_element =
      (Element)(key_element.getElementsByTagName(
              TXSchemaConstants.SCHEMA_NAME_PREFIX + "field").item(0));
      String selector_string =
      selector_element.getAttribute("xpath").toString();
      String field_string = field_element.getAttribute("xpath").toString();
      selector_string = selector_string.replaceAll("/", " ");
      field_string = field_string.replaceAll("/", " ");
      String[] selector_tokens = selector_string.split(" ");
      //for (int j = 0; j < selector_tokens.length; ++j) {
        String token = selector_tokens[selector_tokens.length - 1].trim();
        if (token.length() > 0 && (!token.equals(".")) &&
            (!token.startsWith("@"))) {
          constraint_tokens.add(token);
        }
      //}
      String[] field_tokens = field_string.split(" ");
      //for (int j = 0; j < field_tokens.length; ++j) {
        token = field_tokens[field_tokens.length - 1].trim();
        if (token.length() > 0 && (!token.equals(".")) &&
            (!token.startsWith("@"))) {
          constraint_tokens.add(token);
        }
      //}
    }
    NodeList keyref_def = schema_doc.getElementsByTagName(
        TXSchemaConstants.SCHEMA_NAME_PREFIX + "keyref");
    for (int i = 0; i < keyref_def.getLength(); ++i) {
      Element keyref_element = (Element)(keyref_def.item(i));
      Element selector_element =
          (Element)(keyref_element.getElementsByTagName(
              TXSchemaConstants.SCHEMA_NAME_PREFIX + "selector").item(0));
      Element field_element =
      (Element)(keyref_element.getElementsByTagName(
              TXSchemaConstants.SCHEMA_NAME_PREFIX + "field").item(0));
      String selector_string =
      selector_element.getAttribute("xpath").toString();
      String field_string = field_element.getAttribute("xpath").toString();
      selector_string = selector_string.replaceAll("/", " ");
      field_string = field_string.replaceAll("/", " ");
      String[] selector_tokens = selector_string.split(" ");
      //for (int j = 0; j < selector_tokens.length; ++j) {
        String token = selector_tokens[selector_tokens.length - 1].trim();
        if (token.length() > 0 && (!token.equals(".")) &&
            (!token.startsWith("@"))) {
          constraint_tokens.add(token);
        }
      //}
      String[] field_tokens = field_string.split(" ");
      //for (int j = 0; j < field_tokens.length; ++j) {
        token = field_tokens[field_tokens.length - 1].trim();
        if (token.length() > 0 && (!token.equals(".")) &&
            (!token.startsWith("@"))) {
          constraint_tokens.add(token);
        }
      //}
    }
    NodeList unique_def = schema_doc.getElementsByTagName(
            TXSchemaConstants.SCHEMA_NAME_PREFIX + "unique");
        for (int i = 0; i < unique_def.getLength(); ++i) {
          Element unique_element = (Element)(unique_def.item(i));
          Element selector_element =
              (Element)(unique_element.getElementsByTagName(
                  TXSchemaConstants.SCHEMA_NAME_PREFIX + "selector").item(0));
          Element field_element =
          (Element)(unique_element.getElementsByTagName(
                  TXSchemaConstants.SCHEMA_NAME_PREFIX + "field").item(0));
          String selector_string =
          selector_element.getAttribute("xpath").toString();
          String field_string = field_element.getAttribute("xpath").toString();
          selector_string = selector_string.replaceAll("/", " ");
          field_string = field_string.replaceAll("/", " ");
          String[] selector_tokens = selector_string.split(" ");
          //for (int j = 0; j < selector_tokens.length; ++j) {
            String token = selector_tokens[selector_tokens.length - 1].trim();
            if (token.length() > 0 && (!token.equals(".")) &&
                (!token.startsWith("@"))) {
              constraint_tokens.add(token);
            }
          //}
          String[] field_tokens = field_string.split(" ");
          //for (int j = 0; j < field_tokens.length; ++j) {
            token = field_tokens[field_tokens.length - 1].trim();
            if (token.length() > 0 && (!token.equals(".")) &&
                (!token.startsWith("@"))) {
              constraint_tokens.add(token);
            }
          //}
        }
    //XPath xpath = XPathFactory.newInstance().newXPath();
    //xpath.evaluate("@maxOccurs")
    NodeList other_def = schema_doc.getElementsByTagName(
        TXSchemaConstants.SCHEMA_NAME_PREFIX + "element");
    for (int i = 0; i < other_def.getLength(); ++i) {
      Element other_element = (Element)(other_def.item(i));
      if (other_element.hasAttribute("minOccurs")) {
        String min_occurs = other_element.getAttribute("minOccurs");
        if (!min_occurs.equals("unbounded")) {
          String ref_string = other_element.getAttribute("ref");
          String[] ref_tokens = ref_string.split(" ");
          //for (int j = 0; j < ref_tokens.length; ++j) {
            String token = ref_tokens[ref_tokens.length - 1].trim();
            if (token.length() > 0 && (!token.equals(".")) &&
                (!token.startsWith("@"))) {
              constraint_tokens.add(token);
            }
          //}
        }
      }
      if (other_element.hasAttribute("maxOccurs")) {
        String min_occurs = other_element.getAttribute("maxOccurs");
        if (!min_occurs.equals("unbounded")) {
          String ref_string = other_element.getAttribute("ref");
          String[] ref_tokens = ref_string.split(" ");
          //for (int j = 0; j < ref_tokens.length; ++j) {
            String token = ref_tokens[ref_tokens.length - 1].trim();
            if (token.length() > 0 && (!token.equals(".")) &&
                (!token.startsWith("@"))) {
              constraint_tokens.add(token);
            }
          //}
          String name_string = other_element.getAttribute("name");
          String[] name_tokens = name_string.split(" ");
          token = name_tokens[name_tokens.length - 1].trim();
          if (token.length() > 0 && (!token.equals(".")) &&
              (!token.startsWith("@"))) {
            constraint_tokens.add(token);
          }
        }
      }
      if (other_element.hasAttribute("type")) {
        String type_string = other_element.getAttribute("type");
        if (!type_string.equals("xs:string")) {
          constraint_tokens.add(other_element.getAttribute("name"));
        }
      }
    }
    return new Vector<String>(constraint_tokens);
  }
  
  
  private static Vector<Set<String>> GetAllPath(
      Document input_document, Vector<String> xpath_queries) {
//    XPath xpath = XPathFactory.newInstance().newXPath();
    try {
      Vector<Set<String>> all_path_nodes = new Vector<Set<String>>();
      for (int i = 0; i < xpath_queries.size(); ++i) {
      Vector<String> path_nodes = new Vector<String>();
      String xpath_query = xpath_queries.get(i);
      //NodeList nl = (NodeList) xpath.evaluate(xpath_query, input_document, XPathConstants.NODE);
      NodeList nl = input_document.getElementsByTagName(xpath_query);
      Node tmp_node = nl.item(0);
      Node par_node = null;
      do {
        path_nodes.add(tmp_node.getNodeName());
        if (tmp_node.getNodeType() == Node.ATTRIBUTE_NODE) {
          par_node = (Node)((Attr)tmp_node).getOwnerElement();
        } else {
          par_node = tmp_node.getParentNode();
        }
        tmp_node = par_node;
      } while (par_node.getNodeType() != Node.DOCUMENT_NODE);
      if (i == 0) {
        for (int j = path_nodes.size() - 1; j >= 0; --j) {
          Set<String> new_set = new HashSet<String>();
          new_set.add(path_nodes.get(j));
          all_path_nodes.add(new_set);
        }
      } else {
        int current_level = 0;
        for (int j = path_nodes.size() - 1; j >= 0; --j) {
          if (current_level < all_path_nodes.size()) {
            Set<String> tmp_path_nodes = all_path_nodes.get(current_level);
            tmp_path_nodes.add(path_nodes.get(j));
          } else {
            Set<String> new_set = new HashSet<String>();
            new_set.add(path_nodes.get(j));
            all_path_nodes.add(new_set);
            }
            ++current_level;
          }
        }
      }
      return all_path_nodes;
    } catch (Exception e) {
      e.printStackTrace();
    }
    return null;
  }
  
  
  private static void ReduceDocument(
      Vector<Set<String>> path_nodes, int node_level,
      int max_level, Node node) {
    if (node_level == max_level) {
      return;
    }
    NodeList nl = node.getChildNodes();
    Vector<Node> remove_nodes = new Vector<Node>();
    for (int i = 0; i < nl.getLength(); ++i) {
      Node tmp_node = nl.item(i);
      if ((tmp_node.getNodeType() != Node.TEXT_NODE) &&
          (!path_nodes.get(node_level).contains(tmp_node.getNodeName()))) {
        remove_nodes.add(tmp_node);
      } else {
        ReduceDocument(path_nodes, node_level + 1, max_level, tmp_node);
      }
    }
    for (int i = 0; i < remove_nodes.size(); ++i) {
      node.removeChild(remove_nodes.get(i));
    }
  }
  
  
  private static Node FilterDocument(Vector<Set<String>> path_nodes,
                                     Document input_document) {
    Node root = input_document.getDocumentElement();
    int num_nodes = path_nodes.size();
    int node_level = 1;
    ReduceDocument(path_nodes, node_level, num_nodes, root);
    return root;
  }
}
