package cs.arizona.tau.xml.temporalconstraint;

import java.util.TreeSet;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

import cs.arizona.tau.xml.TXSchemaConstants;

/**
 * The <code>ReferentialIntegrityConstraint</code> sub-class extending
 * <code>Constraint</code>
 * @author ruizhang
 *
 */
public class ReferentialIntegrityConstraint extends Constraint {
  protected String conventional_constraint_;
  protected String refer_;
  protected String ref_selector_;
  protected String ref_field_;
  
  /**
   * Constructing the <code>IndentyConstraint</code> instance with its
   * specific attributes, which are <code>conventional_constraint</code>,
   * <code>refer</code>, <code>ref_selector</code> and <code>ref_field</code>.
   * Note that <code>ref_selector</code> and <code>ref_field</code> are
   * not specified directly in the annotation but retrieved from the snapshot
   * schema by evaluating the
   * <code>refer</code>/<code>conventional_constraint</code> field
   * @param name
   * @param dimension
   * @param selector
   * @param field
   * @param evaluation_window
   * @param slide_size
   * @param applicability
   * @param conventional_constraint
   * @param refer
   * @param ref_selector
   * @param ref_field
   */
  public ReferentialIntegrityConstraint(
      String name, String item_target, String item_identifier,
      String dimension, String selector,
      String field, int evaluation_window, int slide_size,
	  Applicability applicability,
	  String conventional_constraint, String refer,
	  String ref_selector, String ref_field) {
    super(name, item_target, item_identifier,
          dimension, selector, field, evaluation_window, slide_size,
          applicability);
    if (refer != null && !refer.equals("")) {
      refer_ = refer;
    }
    conventional_constraint_ = conventional_constraint;
    ref_selector_ = ref_selector;
    ref_field_ = ref_field;
    if (ref_selector_ != null) {
      if (ref_selector_.startsWith(".//")) {
        ref_selector_ = ref_selector_.substring(1, ref_selector_.length());
      } else if (ref_selector_.startsWith("/")) {
        ref_selector_ = ref_selector_.replaceFirst("/", "//");
      } else if (ref_selector_.equals(".")) {
      	ref_selector_ = "";
      } else if (!ref_selector_.startsWith("//")) {
        ref_selector_ = "//" + ref_selector_;
      }
    }
    if (ref_field_ != null) {
      if (ref_field_.startsWith("/")) {
        ref_field_ = ref_field_.replaceFirst("/", "//");
      } else if (ref_field_.equals(".")) {
      	
      } else if (!ref_field_.startsWith("//")) {
        //ref_field_ = "//" + ref_field_;
      }
    }
  }

  
  public String getConventionalConstraint() {
    return conventional_constraint_;
  }
  
  
  public String getRefer() {
    return refer_;
  }
  
  
  public String getRefSelector() {
    return ref_selector_;
  }
  
  
  public String getRefField() {
    return ref_field_;
  }
  
  
  /**
   * Checking constraint 6.2 the <code>NonSeqKeyRef</code> constraint
   * @param temporal_doc the temporal document
   * @param constraints the list of defined <code>NonSeqKeyRef</code>
   * constraints
   */
  public static boolean CheckNonSeqKeyRef(
      Document temporal_doc, Document schema_doc,
      Vector<Constraint> constraints) {
  if (constraints == null) {
      return true;
    }
    for (Constraint c : constraints) {
      for (Applicability app : c.eval_windows_) {
        try {
          String keynode_query = TemporalConstraintValidator.PrepareXPathString(
                ((ReferentialIntegrityConstraint)(c)).getRefSelector(),
                ((ReferentialIntegrityConstraint)(c)).getRefField());
          // should the keys be limited by evaluation window?
          Vector<String> all_key_nodes =
        	  TemporalConstraintValidator.GetCandidateNodes(
                  temporal_doc, keynode_query,
                  null, null, app);
          TreeSet<String> key_value_set = new TreeSet<String>();
          for (String n : all_key_nodes) {
            key_value_set.add(n);
          }
    	  
          String xpath_query = TemporalConstraintValidator.PrepareXPathString(
              c.getSelector(), c.getField());
          //xpath_query += "|" +  c.getItemIdentifier();
          Vector<String> result_nodes =
              TemporalConstraintValidator.GetCandidateNodes(
                  temporal_doc, xpath_query,
                  c.getItemTarget(), c.getItemIdentifier(), app);
          for (String n : result_nodes) {
            String[] key_value = n.split(TXSchemaConstants.DELIMITER);
            if (!key_value_set.contains(key_value[1])) {
              System.err.println(
                  "In period " + app.toString() +
                  " [" + c.getName() + "] nonSeqKeyref violation: " +
                  "Key " + key_value[1] + " can't " +
                  "be found by keyref definition");
              return false;
            }
          }
          if (result_nodes == null) {
            return false;
          }
        } catch (Exception ex) {
          ex.printStackTrace();
          return false;
        }
      }
    }
    return true;
  }
}
