package cs.arizona.tau.xml.temporalconstraint;

import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import cs.arizona.util.ConventionalParser;

class Slicer implements Runnable {
	
  public Slicer(Vector<Node> dd, String current_time,
                Document result_document) {
    //input_document_ = copyDocument(input_document);
    in_dd_ = dd;
    current_time_ = current_time;
    result_document_ = result_document;
  }

  
  public void run() {
    Slice();
  }
  
 
  public void Slice() {
    //NodeList dd = input_document_.getElementsByTagName("item_Version");
    for (int j = 0; j < in_dd_.size(); j++){
      Element cur = (Element)in_dd_.get(j);
      String e = cur.getAttribute("end");
      String b = cur.getAttribute("begin");
      // If this item is alive...
      if (e.compareTo(current_time_) > 0 && b.compareTo(current_time_) <= 0){
        //Node curItem1 = ((Node) cur).getFirstChild();
        Node curItem1 = cur.getElementsByTagName("item").item(0);
        Node curItem = result_document_.importNode(curItem1, true);
        // Should only be one authors
        Element curAuthors = null;
  
        NodeList dd1 = ((Element) curItem).getElementsByTagName("authors");
            
        //NodeList dd1 = getAllNodesXPath(".//authors", curItem);
        for (int i=0; i< dd1.getLength(); i++){
          curAuthors = (Element)dd1.item(i);
	              
          NodeList dd2 = curAuthors.getElementsByTagName("author_Version");
	              
          //NodeList dd2 = getAllNodesXPath(".//author_Version", curAuthors);
          for (int k=0; k< dd2.getLength(); k++){
            Element curAuthorVersion = (Element)dd2.item(k);
            String e1 = curAuthorVersion.getAttribute("end");
            String b1 = curAuthorVersion.getAttribute("begin");
            //Node curAuthor = ((Node) curAuthorVersion).getFirstChild();
            Node curAuthor = curAuthorVersion.getElementsByTagName("author").item(0);
            if (e1.compareTo(current_time_) > 0 && b1.compareTo(current_time_) <= 0){
              curAuthors.appendChild(curAuthor);
            } else {
              curAuthorVersion.removeChild(curAuthor);
            }
          }
        }

        NodeList dd2 = ((Element)curItem).getElementsByTagName("publisher_Version");
	            
        //NodeList dd2 = getAllNodesXPath(".//publisher_Version", curItem);
        for (int k=0; k< dd2.getLength(); k++){
          Element curPV = (Element)dd2.item(k);
          String e1 = curPV.getAttribute("end");
          String b1 = curPV.getAttribute("begin");
          //Node curPublisher = ((Node) curPV).getFirstChild();
          Node curPublisher = curPV.getElementsByTagName("publisher").item(0);
          if (e1.compareTo(current_time_) > 0 && b1.compareTo(current_time_) <= 0){
            curItem.appendChild(curPublisher);
          } else {
          }
        }
	            
        dd2 = ((Element)curItem).getElementsByTagName("related_items_Version");
	            
        //dd2 = getAllNodesXPath(".//related_items_Version", curItem);
        for (int k=0; k< dd2.getLength(); k++){
          Element curPV = (Element)dd2.item(k);
          String e1 = curPV.getAttribute("end");
          String b1 = curPV.getAttribute("begin");
          //Node curRI = ((Node) curPV).getFirstChild();
          Node curRI = curPV.getElementsByTagName("related_items").item(0);
          if (e1.compareTo(current_time_) > 0 && b1.compareTo(current_time_) <= 0){
            //System.out.println(e1+ " is less than " + ct + ": " + ((Element)curRI).getAttribute("related_items_id"));
            curItem.appendChild(curRI);
          } else {
    
          }
        }
        // Remove all old author_items elements (they are empty; content already moved)
	            
        dd1 = ((Element) curItem).getElementsByTagName("authors");
           
        //dd1 = getAllNodesXPath(".//authors", curItem);
        for (int i=0; i< dd1.getLength(); i++){
          Node curA = dd1.item(i);
          for(Node childNode = curA.getFirstChild(); childNode!=null;){
            Node nextChild = childNode.getNextSibling();
            if (childNode.getNodeName().equals("author_RepItem")){
              curA.removeChild(childNode);
            }
            childNode = nextChild;
          }
        }
        // Remove all old publisher_items and related_items_items
        for(Node childNode = curItem.getFirstChild(); childNode!=null;){
          Node nextChild = childNode.getNextSibling();
          if (childNode.getNodeName().equals("publisher_RepItem")){
            curItem.removeChild(childNode);
          } else if (childNode.getNodeName().equals("related_items_RepItem")){
            curItem.removeChild(childNode);
          }
          childNode = nextChild;
        }
        //Node n = slice.importNode((Node)curItem, true);
        result_document_.getDocumentElement().appendChild(curItem);
      }
    }
  }
	
  public Document GetResultDocument() {
    return result_document_;
  }
  
  private Document input_document_;
  private Document result_document_;
  private String current_time_;
  private Vector<Node> in_dd_;
}


public class RealUnSquash {
  
  private static NodeList getAllNodesXPath(String path, Object p) {
	try{
      NodeList e = (NodeList)xpath.evaluate(path, p, XPathConstants.NODESET);
      return e;
    } catch (Exception e){System.out.println(e);};
    return null;
  }

  private static Document copyDocument(Document d1){
    DocumentBuilderFactory factory;
    DocumentBuilder loader;
    Document d2 = null;
    try {
      factory = DocumentBuilderFactory.newInstance();
      loader  = factory.newDocumentBuilder();
      d2 = loader.newDocument();
      d2.appendChild(d2.importNode((Node)d1.getDocumentElement(), true));
    } catch(Exception e){}
    return d2;
  }

  
  private static Document getXmlSlice(Document doc, String ct) {
    Document d = copyDocument(doc); // the copy of doc
    Document slice= null;
    Element root1 =null;
    DocumentBuilderFactory factory;
    DocumentBuilder loader;
    try {
      factory = DocumentBuilderFactory.newInstance();
      loader = factory.newDocumentBuilder();
      slice = loader.newDocument();
      root1 = slice.createElement("catalog");
      //root1.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
      //root1.setAttribute("xsi:noNamespaceSchemaLocation", "DCSD.xsd");
      slice.appendChild(root1);
    } catch (ParserConfigurationException ex) {
      //handleError(ex);
      ex.printStackTrace();
    } catch (FactoryConfigurationError ex) {
      //handleError(ex);
      ex.printStackTrace();
    }
    NodeList dd = d.getElementsByTagName("item_Version");
    for (int j=0; j< dd.getLength(); j++){
      Element cur = (Element)dd.item(j);
      String e = cur.getAttribute("end");
      String b = cur.getAttribute("begin");
      // If this item is alive... 
      if (e.compareTo(ct) > 0 && b.compareTo(ct) <= 0){
        //Node curItem1 = ((Node) cur).getFirstChild();
        Node curItem1 = cur.getElementsByTagName("item").item(0);
        Node curItem = slice.importNode(curItem1, true);
        // Should only be one authors
        Element curAuthors = null;
        // NodeList dd1 = ((Element) curItem).getElementsByTagName("authors");
        NodeList dd1 = getAllNodesXPath(".//authors", curItem);
        for (int i=0; i< dd1.getLength(); i++){
          curAuthors = (Element)dd1.item(i);
          //NodeList dd2 = curAuthors.getElementsByTagName(".author_Version");
          NodeList dd2 = getAllNodesXPath(".//author_Version", curAuthors);
          for (int k=0; k< dd2.getLength(); k++){
            Element curAuthorVersion = (Element)dd2.item(k);
            String e1 = curAuthorVersion.getAttribute("end");
            String b1 = curAuthorVersion.getAttribute("begin");
            //Node curAuthor = ((Node) curAuthorVersion).getFirstChild();
            Node curAuthor = curAuthorVersion.getElementsByTagName("author").item(0);
            if (e1.compareTo(ct) > 0 && b1.compareTo(ct) <= 0){
              curAuthors.appendChild(curAuthor);
            } else {
              curAuthorVersion.removeChild(curAuthor);
            }
          }
        }
        //NodeList dd2 = ((Element)curItem).getElementsByTagName("publisher_Version");
        NodeList dd2 = getAllNodesXPath(".//publisher_Version", curItem);
        for (int k=0; k< dd2.getLength(); k++){
          Element curPV = (Element)dd2.item(k);
          String e1 = curPV.getAttribute("end");
          String b1 = curPV.getAttribute("begin");
          //Node curPublisher = ((Node) curPV).getFirstChild();
          Node curPublisher = curPV.getElementsByTagName("publisher").item(0);
          if (e1.compareTo(ct) > 0 && b1.compareTo(ct) <= 0){
            curItem.appendChild(curPublisher);
          } else {
          }
        }
        //dd2 = ((Element)curItem).getElementsByTagName("related_items_Version");
        dd2 = getAllNodesXPath(".//related_items_Version", curItem);
        for (int k=0; k< dd2.getLength(); k++){
          Element curPV = (Element)dd2.item(k);
          String e1 = curPV.getAttribute("end");
          String b1 = curPV.getAttribute("begin");
          //Node curRI = ((Node) curPV).getFirstChild();
          Node curRI = curPV.getElementsByTagName("related_items").item(0);
          if (e1.compareTo(ct) > 0 && b1.compareTo(ct) <= 0){
            //System.out.println(e1+ " is less than " + ct + ": " + ((Element)curRI).getAttribute("related_items_id"));
            curItem.appendChild(curRI);
          } else {
    
          }
        }
        // Remove all old author_items elements (they are empty; content already moved)
        //dd1 = ((Element) curItem).getElementsByTagName("authors");
        dd1 = getAllNodesXPath(".//authors", curItem);
        for (int i=0; i< dd1.getLength(); i++){
          Node curA = dd1.item(i);
          for(Node childNode = curA.getFirstChild(); childNode!=null;){
            Node nextChild = childNode.getNextSibling();
            if (childNode.getNodeName().equals("author_RepItem")){
              curA.removeChild(childNode);
            }
            childNode = nextChild;
          }
        }
        // Remove all old publisher_items and related_items_items
        for(Node childNode = curItem.getFirstChild(); childNode!=null;){
          Node nextChild = childNode.getNextSibling();
          if (childNode.getNodeName().equals("publisher_RepItem")){
            curItem.removeChild(childNode);
          } else if (childNode.getNodeName().equals("related_items_RepItem")){
            curItem.removeChild(childNode);
          }
          childNode = nextChild;
        }
        //Node n = slice.importNode((Node)curItem, true);
        root1.appendChild(curItem);
      }
    }
    return slice;
  }
  
  
  private static Vector<Document> GetAllSlices(Document doc, Set<String> end_time_tags) {
    Document d = copyDocument(doc); // the copy of doc
    Vector<String> all_times = new Vector<String>(end_time_tags);
    Vector<Document> result_documents = new Vector<Document>();
    DocumentBuilderFactory factory;
    DocumentBuilder loader;
    long st = System.currentTimeMillis();
    try {
      Document slice= null;
      Element root1 =null;
      for (int i = 0; i < all_times.size(); ++i) {
        factory = DocumentBuilderFactory.newInstance();
        loader = factory.newDocumentBuilder();
        slice = loader.newDocument();
        root1 = slice.createElement("catalog");
        slice.appendChild(root1);
        result_documents.add(slice);
      }
    } catch (ParserConfigurationException ex) {
      //handleError(ex);
      ex.printStackTrace();
    } catch (FactoryConfigurationError ex) {
      //handleError(ex);
      ex.printStackTrace();
    }
    long et = System.currentTimeMillis();
    System.err.println("step 1: " + (et - st) + " msec.");
    
    st = System.currentTimeMillis();
    NodeList dd = d.getElementsByTagName("item_Version");
    for (int j = 0; j < dd.getLength(); j++){
      Element cur = (Element)dd.item(j);
      String e = cur.getAttribute("end");
      String b = cur.getAttribute("begin");
      // If this item is alive...
      for (int nn = 0; nn < result_documents.size(); ++nn) {
    	Document tmp_slice = result_documents.get(nn);
    	String current_time = all_times.get(nn);
    	if (e.compareTo(current_time) > 0 && b.compareTo(current_time) <= 0){
            //Node curItem1 = ((Node) cur).getFirstChild();
            Node curItem1 = cur.getElementsByTagName("item").item(0);
            Node curItem = tmp_slice.importNode(curItem1, true);
            // Should only be one authors
            Element curAuthors = null;
            
            NodeList dd1 = ((Element) curItem).getElementsByTagName("authors");
            
            //NodeList dd1 = getAllNodesXPath(".//authors", curItem);
            for (int i=0; i< dd1.getLength(); i++){
              curAuthors = (Element)dd1.item(i);
              
              NodeList dd2 = curAuthors.getElementsByTagName("author_Version");
              
              //NodeList dd2 = getAllNodesXPath(".//author_Version", curAuthors);
              for (int k=0; k< dd2.getLength(); k++){
                Element curAuthorVersion = (Element)dd2.item(k);
                String e1 = curAuthorVersion.getAttribute("end");
                String b1 = curAuthorVersion.getAttribute("begin");
                //Node curAuthor = ((Node) curAuthorVersion).getFirstChild();
                Node curAuthor = curAuthorVersion.getElementsByTagName("author").item(0);
                if (e1.compareTo(current_time) > 0 && b1.compareTo(current_time) <= 0){
                  curAuthors.appendChild(curAuthor);
                } else {
                  curAuthorVersion.removeChild(curAuthor);
                }
              }
            }
            
            NodeList dd2 = ((Element)curItem).getElementsByTagName("publisher_Version");
            
            //NodeList dd2 = getAllNodesXPath(".//publisher_Version", curItem);
            for (int k=0; k< dd2.getLength(); k++){
              Element curPV = (Element)dd2.item(k);
              String e1 = curPV.getAttribute("end");
              String b1 = curPV.getAttribute("begin");
              //Node curPublisher = ((Node) curPV).getFirstChild();
              Node curPublisher = curPV.getElementsByTagName("publisher").item(0);
              if (e1.compareTo(current_time) > 0 && b1.compareTo(current_time) <= 0){
                curItem.appendChild(curPublisher);
              } else {
              }
            }
            
            dd2 = ((Element)curItem).getElementsByTagName("related_items_Version");
            
            //dd2 = getAllNodesXPath(".//related_items_Version", curItem);
            for (int k=0; k< dd2.getLength(); k++){
              Element curPV = (Element)dd2.item(k);
              String e1 = curPV.getAttribute("end");
              String b1 = curPV.getAttribute("begin");
              //Node curRI = ((Node) curPV).getFirstChild();
              Node curRI = curPV.getElementsByTagName("related_items").item(0);
              if (e1.compareTo(current_time) > 0 && b1.compareTo(current_time) <= 0){
                //System.out.println(e1+ " is less than " + ct + ": " + ((Element)curRI).getAttribute("related_items_id"));
                curItem.appendChild(curRI);
              } else {
        
              }
            }
            // Remove all old author_items elements (they are empty; content already moved)
            
            dd1 = ((Element) curItem).getElementsByTagName("authors");
            
            //dd1 = getAllNodesXPath(".//authors", curItem);
            for (int i=0; i< dd1.getLength(); i++){
              Node curA = dd1.item(i);
              for(Node childNode = curA.getFirstChild(); childNode!=null;){
                Node nextChild = childNode.getNextSibling();
                if (childNode.getNodeName().equals("author_RepItem")){
                  curA.removeChild(childNode);
                }
                childNode = nextChild;
              }
            }
            // Remove all old publisher_items and related_items_items
            for(Node childNode = curItem.getFirstChild(); childNode!=null;){
              Node nextChild = childNode.getNextSibling();
              if (childNode.getNodeName().equals("publisher_RepItem")){
                curItem.removeChild(childNode);
              } else if (childNode.getNodeName().equals("related_items_RepItem")){
                curItem.removeChild(childNode);
              }
              childNode = nextChild;
            }
            //Node n = slice.importNode((Node)curItem, true);
            tmp_slice.getDocumentElement().appendChild(curItem);
          }
      }
    }
    et = System.currentTimeMillis();
    System.err.println("step 2: " + (et - st) + " msec.");
    return result_documents;
  }
  
  
  
  private static Vector<Document> GetAllSlicesParallel(
      Document doc, Set<String> end_time_tags) {
    Vector<String> all_times = new Vector<String>(end_time_tags);
    Vector<Document> result_documents = new Vector<Document>();
    long st = System.currentTimeMillis();
    Vector<Slicer> all_slicers = new Vector<Slicer>();
    Vector<Thread> all_slicer_threads = new Vector<Thread>();
    NodeList dd = doc.getElementsByTagName("item_Version");
    Vector<Node> item_nodes = new Vector<Node>();
    for (int i = 0; i < dd.getLength(); ++i) {
      item_nodes.add(dd.item(i));
    }
    Element root1 =null;
    DocumentBuilderFactory factory;
    DocumentBuilder loader = null;
    factory = DocumentBuilderFactory.newInstance();
    try {
      loader = factory.newDocumentBuilder();
    } catch (ParserConfigurationException ex) {
      ex.printStackTrace();
      return null;
    } catch (FactoryConfigurationError ex) {
      ex.printStackTrace();
      return null;
    }
    for (int i = 0; i < all_times.size(); ++i) {
        Document result_doc = loader.newDocument();
        root1 = result_doc.createElement("catalog");
        result_doc.appendChild(root1);
        Slicer slicer = new Slicer(item_nodes, all_times.get(i), result_doc);
        all_slicers.add(slicer);
        Thread slicer_thread = new Thread(slicer);
        all_slicer_threads.add(slicer_thread);
        slicer_thread.start();
    }
    for (int i = 0; i < all_slicer_threads.size(); ++i) {
      try {
		all_slicer_threads.get(i).join();
	  } catch (InterruptedException e) {
		// TODO Auto-generated catch block
		e.printStackTrace();
	  }
    }
    for (int i = 0; i < all_slicers.size(); ++i) {
      result_documents.add(all_slicers.get(i).GetResultDocument());
    }
    long et = System.currentTimeMillis();
    System.out.println("get all slices: " + ((et - st)/1000.0) + " sec.");
    return result_documents;
  }
  
  /**
   * Extract all the end times from the temporal document, which
   * constructs the whole slices.
   * @param temporal_document The temporal document to be processed
   * @return All the end time tags extracted from the temporal document.
   */
  protected static Set<String> FindAllSlices(Node temporal_document) {
    Set<String> end_time_tags = new TreeSet<String>();
    String xpath_query = "//@end";
    NodeList nl = getAllNodesXPath(xpath_query, temporal_document);
    for (int i = 0; i < nl.getLength(); ++i) {
      Node tmp_node = nl.item(i);
      end_time_tags.add(tmp_node.getNodeValue());
    }
    return end_time_tags;
  }
  
  
  public static Vector<Document> PerformRealUnSquash(
      String temporal_data_dir, Node temporal_document,
      String conventional_schema) {
    Set<String> end_times = FindAllSlices(temporal_document);
    Vector<Document> all_slices = new Vector<Document>();
    SliceValidator sv = new SliceValidator(temporal_document);
    sv.SliceNValidate(conventional_schema, end_times);
    //all_slices = GetAllSlices(temporal_document, end_times);
    //all_slices = GetAllSlicesParallel(temporal_document, end_times);
    /*
    for (String end_time : end_times) {
      Document doc_ele = getXmlSlice(temporal_document, end_time);
      all_slices.add(doc_ele);
    }
    System.out.println("Totaling " + all_slices.size() + " slices");
    */
    return all_slices;
  }

  static XPath xpath = XPathFactory.newInstance().newXPath();
}
