package cs.arizona.tau.xml.temporalconstraint;

import static org.junit.Assert.*;


import java.io.File;
import java.util.Vector;

import junit.framework.Assert;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.w3c.dom.Document;

import cs.arizona.util.ConventionalParser;

public class IdentityConstraintTest {
  Document temporal_doc_;
  Document annotation_doc_;
  Document schema_doc_;
  Applicability default_applicability_;
  Vector<Constraint> nonseqkey_constraints_;
  Vector<Constraint> nonsequnique_constraints_;
  Vector<Constraint> uniquenullrestricted_constraints_;
  TemporalConstraintValidator tcv_;
	  
	@BeforeClass
	public static void setUpBeforeClass() throws Exception {
	}

	@AfterClass
	public static void tearDownAfterClass() throws Exception {
	}

	@Before
	public void setUp() throws Exception {
		nonseqkey_constraints_ = new Vector<Constraint>();
		nonsequnique_constraints_ = new Vector<Constraint>();
		uniquenullrestricted_constraints_ = new Vector<Constraint>();
	    String temporalSchema =
	        "test_suites/ts_identity.xml";
	    Document input_temporal_doc =
	  	    ConventionalParser.getInstance().parseDocument(
	  			"test_suites/output.final.xml", null, null, false);
	    tcv_ = new TemporalConstraintValidator(
	        input_temporal_doc, temporalSchema);
	    temporal_doc_ = tcv_.GetTemporalDocument();
	    annotation_doc_ = tcv_.GetAnnotationDocument();
	    tcv_.ExtractConstraints(
	        annotation_doc_.getDocumentElement(), "nonSeqKey",
	        nonseqkey_constraints_);
	    tcv_.ExtractConstraints(
	        annotation_doc_.getDocumentElement(), "nonSeqUnique",
	        nonsequnique_constraints_);
	    tcv_.ExtractConstraints(
	        annotation_doc_.getDocumentElement(), "uniqueNullRestricted",
	        uniquenullrestricted_constraints_);
	}

	@After
	public void tearDown() throws Exception {
	}

	@Test
	public void testCheckNonSeqKey() {
      int num_constraints = nonseqkey_constraints_.size();
      Assert.assertEquals(1, num_constraints);
      Vector<Constraint> constraint1 = new Vector<Constraint>();
      constraint1.add(nonseqkey_constraints_.get(0));
      boolean val1 = IdentityConstraint.CheckNonSeqKey(
          temporal_doc_, constraint1);
      Assert.assertTrue(val1);
	}

	@Test
	public void testCheckNonSeqUnique() {
      int num_constraints = nonsequnique_constraints_.size();
      Assert.assertEquals(0, num_constraints);
      /*
      Vector<Constraint> constraint1 = new Vector<Constraint>();
      constraint1.add(nonsequnique_constraints_.get(0));
      boolean val1 = IdentityConstraint.CheckNonSeqUnique(
          temporal_doc_, constraint1);
      Assert.assertTrue(val1);
      Vector<Constraint> constraint2 = new Vector<Constraint>();
      constraint2.add(nonsequnique_constraints_.get(1));
      boolean val2 = IdentityConstraint.CheckNonSeqUnique(
          temporal_doc_, constraint2);
      Assert.assertFalse(val2);
      */
	}

	@Test
	public void testCheckUniqueNullRestricted() {
      int num_constraints = uniquenullrestricted_constraints_.size();
      Assert.assertEquals(0, num_constraints);
    }
}
