package cs.arizona.tau.xml.temporalconstraint;

import java.util.*;

/**
 * The base <code>Constraint</code> class
 * @author ruizhang
 *
 */
public class Constraint {
  protected String selector_;
  protected String field_;
  
  protected String name_;
  protected String dimension_;
  protected int evaluation_window_ = -1;
  protected int slide_size_ = 1;
  protected Applicability general_applicability_;
  protected String item_identifier_;
  protected String item_target_;
  
  protected Vector<Applicability> eval_windows_;

  /**
   * Constructing a <code>Constraint</code> instance with the basic
   * attributes.
   * @param name
   * @param dimension
   * @param selector
   * @param field
   * @param evaluation_window
   * @param slide_size
   * @param applicability
   */
  public Constraint(String name, String item_target, String item_identifier,
                    String dimension, String selector,
                    String field, int evaluation_window, int slide_size,
                    Applicability applicability) {
    name_ = name;
    dimension_ = dimension;
    selector_ = selector;
    field_ = field;
    evaluation_window_ = evaluation_window;
    slide_size_ = slide_size;
    general_applicability_ = applicability;
    item_identifier_ = item_identifier;
    item_target_ = item_target;
    
    if (selector_ != null) {
      if (selector_.startsWith("/")) {
        selector_ = selector_.replaceFirst("/", "//");
      } else if (selector.equals(".")) {
      	selector_ = "";
      } else if (selector.startsWith(".//")) {
    	selector_ = selector.substring(1);  
      } else if (!selector_.startsWith("//")) {
        selector_ = "//" + selector_;
      }
    }
    if (field_ != null) {
      if (field_.startsWith("/")) {
        field_ = field_.replaceFirst("/", "//");
      } else if (field_.equals(".") || field_.startsWith("@")) {
      	
      } else if (!field_.startsWith("//")) {
        //field_ = "//" + field_;
      }
    }
    LoadEvaluationWindow(general_applicability_);
  }
  
  
  /**
   * Computing all the evaluation period based on slideSize and
   * evaluationWindow
   * @param applicability the default applicability defining the
   * whole time period
   */
  public void LoadEvaluationWindow(Applicability applicability) {
    eval_windows_ = new Vector<Applicability>();
    if (evaluation_window_ == -1) {
      eval_windows_.add(new Applicability(applicability.GetStartTime(),
                                          applicability.GetEndTime()));
      return;
    }
    String start = applicability.GetStartTime();
    String end = applicability.GetEndTime();
    String current_begin = start;
    String current_end = "";
    while (true) {
      current_end = Applicability.GetPeriodBound(current_begin,
                                                 evaluation_window_);
      if (Applicability.CompareTime(current_end, end) >= 0) {
        eval_windows_.add(new Applicability(current_begin, end));
        return;
      }
      eval_windows_.add(new Applicability(current_begin, current_end));
      current_begin = Applicability.GetPeriodBound(current_begin, slide_size_);
    }
  }
  
  
  public String getName() {
    return name_;
  }
  
  
  public String getDimension() {
    return dimension_;
  }
  
    
  public String getSelector() {
    return selector_;
  }
    
    
  public String getField() {
    return field_;
  }
  
  
  public int getEvaluationWindow() {
    return evaluation_window_;
  }
  
  
  public int getSlideSize() {
    return slide_size_;
  }
  
  
  public Applicability getApplicability() {
    return general_applicability_;
  }
  
  
  public String getItemIdentifier() {
    return item_identifier_;
  }
  
  
  public String getItemTarget() {
    return item_target_;
  }
  
  
  public String toString() {
    StringBuffer content_buf = new StringBuffer();
    content_buf.append(getName() + ": ");
    content_buf.append(getDimension() + " - ");
    content_buf.append(getSelector() + " - ");
    content_buf.append(getField());
    if (general_applicability_ != null) {
      content_buf.append(" [" + general_applicability_.GetStartTime() + ", " +
                         general_applicability_.GetEndTime() + "]");
    }
    if (eval_windows_.size() > 0) {
      content_buf.append(" - evals: " + eval_windows_.toString());
    }
    return content_buf.toString();
  }
}
