/**
 * 
 */
package cs.arizona.tau.xml;

import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;

import org.w3c.dom.Element;


import cs.arizona.tau.time.ITimePeriod;
import cs.arizona.util.ConventionalParser;


import cs.arizona.util.TauLogger;



/**
 * @author shailesh
 *
 */
public class UnSquash {

	
	/**
	 * @param args
	 */
	public static void main(String[] args) {

	    long t1 = System.nanoTime();
		Hashtable snapshots;
		ConventionalParser cp = ConventionalParser.getInstance();
		String snapshotFile= "", start="", end="";
		//String configFile="";
		boolean schemaVersioningFlag = false;

	
		// Debug output
		TauLogger.init();
		TauLogger.setLevel(1);
	
		/* Parse command line args */
		if (args.length < 1){
			System.out.println("usage: unsquash [-r] [-o outFile] [-d debugLevel] temporal_document");
			System.exit(1);
		} 

		for (int i = 0; i < args.length; ++i){
			if (args[i].equals("-o")){
				//TODO: outName = args[i+1];
				++i;
			} 
			if (args[i].equals("-s")){
				schemaVersioningFlag = Boolean.parseBoolean(args[i+1]);
				++i;
			}
			else if (args[i].equals("-d")){
				TauLogger.setLevel(Integer.parseInt(args[i+1]));
				++i;
			} else if (args[i].equals("-r")) {
              LocalRepSchema = true;
			}
		}

		String file_path = args[args.length - 1];
		String tempDataDir = ".";
		String tempDataFile = file_path;
		if (file_path.contains("/")) {
          int dir_separator_index = file_path.lastIndexOf("/");
          tempDataDir = file_path.substring(0, dir_separator_index);
		  tempDataFile = file_path.substring(dir_separator_index + 1,
              file_path.length());  
		}
		Common.checkFileExists(file_path);

		TauLogger.logger.info("Unsquashing documents (schemaVersioningFlag = " + schemaVersioningFlag + ")...");
		
		IRepresentationFactory iRepFactory 	= new DecomposedRepresentationFactory();
		IDoUnSquashing doUnSquashing 		= iRepFactory.createUnSquashingObj(tempDataDir, tempDataFile, schemaVersioningFlag);

		//String configDir 	= Common.getDirectory(temporalDocument);
		//String baseFileName = Common.getFileName(temporalDocument);
		
		snapshots = doUnSquashing.unSquash(tempDataDir, tempDataFile);
		
		if (snapshots == null){
			TauLogger.logger.fatal("No snapshots could be created.");
			System.exit(2);
		}
		
		// Now loop through snapshots and output each one.
		Enumeration enumeration = snapshots.keys();
		int i = 0;
		while (enumeration.hasMoreElements()){
			ITimePeriod tp = (ITimePeriod)enumeration.nextElement();
			Element e = (Element)snapshots.get(tp);

			start = Common.formatDate(tp.getBeginDate());
			end   = Common.formatDate(tp.getEndDate());
			snapshotFile = tempDataDir + "/slice" + "_" + start + "_" + end + ".xml";
	
			cp.writeElement(e, snapshotFile);
			++i;
		}
		
		// Debug output
		TauLogger.logger.info("Done.");	
	    long t2 = System.nanoTime();
		Common.printElaspedTime("Unsquash", t1, t2);
	}
	
	public static boolean LocalRepSchema = false;
}
