package cs.arizona.tau.xml;

import cs.arizona.util.ConventionalParser;
import cs.arizona.util.TauLogger;

/**
 * @author shailesh
 * @author sthomas
 * Simple command-line interface for TemporalValidator (aka tXMLLint)
 */
public class TemporalValidator {

	public static void main(String[] args) {
	    long t1 = System.nanoTime();

		boolean schemaVersioningFlag = false;
		ConventionalParser cp = ConventionalParser.getInstance();
		
		// Debug output
		TauLogger.init();
		TauLogger.setLevel(1);
		
		/* Parse command line args */
		if (args.length < 1){
			System.out.println("usage: txmllint [-s schemaVersFlag] [-d debugLevel] temporal_document");
			System.exit(1);
		}
		for (int i = 0; i < args.length; ++i){
			if (args[i].equals("-s")){
				schemaVersioningFlag = Boolean.parseBoolean(args[i+1]);
				++i;
			}
			else if (args[i].equals("-d")){
				TauLogger.setLevel(Integer.parseInt(args[i+1]));
				++i;
			}
		}		
		
		String file_path = args[args.length - 1];
		String tempDataDir = ".";
		String tempDataFile = file_path;
		if (file_path.contains("/")) {
          int dir_separator_index = file_path.lastIndexOf("/");
          tempDataDir = file_path.substring(0, dir_separator_index);
		  tempDataFile = file_path.substring(dir_separator_index + 1,
              file_path.length());  
		}
		Common.checkFileExists(file_path);

		TauLogger.logger.info("Validating document " + file_path + "...");

		IRepresentationFactory iRepFactory = new DecomposedRepresentationFactory();
		IDoTemporalValidation doTemporalValidation = iRepFactory.createTemporalValidationObj(tempDataDir, tempDataFile, schemaVersioningFlag);
		
		// Mimic xmllint output
		if (doTemporalValidation.validate(tempDataDir, tempDataFile)){
			System.out.println(file_path + " validates");
		}else{
			System.out.println(file_path + " fails to validate");
		}
	    long t2 = System.nanoTime();
		Common.printElaspedTime("tXMLLint", t1, t2);
	}
}
