/**
 * 
 */
package cs.arizona.tau.xml;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;

import org.apache.xpath.domapi.XPathEvaluatorImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.xpath.XPathEvaluator;
import org.w3c.dom.xpath.XPathNSResolver;
import org.w3c.dom.xpath.XPathResult;

import cs.arizona.util.SchemaPathEvaluator;
import cs.arizona.util.TargetIdentifier;


/**
 * @author shailesh
 *
 */
public class SchemaItem {

	private ArrayList itemList = new ArrayList();
	
	public void SchemaItem(){
	}
	
	/*
	 * Given a item fragment, the function tries to check whether it can be bridged with this item.
	 */
	public boolean canBeBridged(Item dataItem, ArrayList itemIdCorrList, int numScp){
		/* Get the Item Identifiere Correspondence Map for schema constant period numScp */
		Hashtable itemIdCorrMap = (Hashtable)itemIdCorrList.get(numScp);
		ItemIdentifierCorr itemIdCorr;
		Item itemFragment = (Item)itemList.get(numScp - 1);
		/* If the item identifier correspondence for the new item name exists in the item itentifier correspondence map */
		if (null != (itemIdCorr = (ItemIdentifierCorr)itemIdCorrMap.get(dataItem.getItemIdentifier().getName()))){
			/* If yes, check whether the name of item fragment's item identifier is equal to getOldRef.
			 * i.e. If the item identifier correspondence exists.
			 */
			if (itemFragment.getItemIdentifier().getName().equals(itemIdCorr.getOldRef())){
				/* If item identifier correspondence exists, check whether supplied dataItem can be bridged with this 
				 * item fragment.
				 */
				return canBeBridged(itemFragment, dataItem, itemIdCorr.getMappingType());
			}else{
				return false;
			}
		}else if (itemFragment.getItemIdentifier().equals(dataItem.getItemIdentifier())){	/* If no mapping exists, the names of item identifiers should be same in both the scp's */
			return true;
		}else{
			return false;
		}
	}
	
	/* Given old and new data item fragments, function checks whether the two items can be bridged */
	private boolean canBeBridged(Item oldDataItem, Item newDataItem, String mappingType){
		if ("useOld".equals(mappingType)){
			Element newVersion = newDataItem.getVersion(0);
			return canBeBridged(oldDataItem.getItemIdentifier(), newVersion);
		}else if ("useNew".equals(mappingType)){
			Element oldVersion = oldDataItem.getVersion(oldDataItem.getVersionCount() - 1);
			return canBeBridged(newDataItem.getItemIdentifier(), oldVersion);
		}else if ("useBoth".equals(mappingType)){
			return oldDataItem.getItemIdentifier().getFieldValue().equals(newDataItem.getItemIdentifier().getFieldValue());
		}else{				/* replace is not supported in the this initial implementation */
			return false;
		}
	}

	private boolean canBeBridged(ItemIdentifier ii, Element version){
		XPathEvaluator evaluator = new XPathEvaluatorImpl(version.getOwnerDocument());
		XPathNSResolver resolver = evaluator.createNSResolver(version.getOwnerDocument());
		Hashtable fieldTable = ii.getFieldTable();
		Enumeration enum1 = fieldTable.keys();
		while (enum1.hasMoreElements()){
			String fieldPath = (String)enum1.nextElement();
			
			if (fieldPath.endsWith("text")){
				fieldPath = fieldPath + "()";
				String tempFieldValue = "";
				XPathResult result = (XPathResult)evaluator.evaluate(fieldPath,version,resolver,XPathResult.ORDERED_NODE_ITERATOR_TYPE,null);
				Node n;
				if ((n = result.iterateNext())!= null){
						tempFieldValue = tempFieldValue + n.getNodeValue();
				}
				if (!tempFieldValue.equals(fieldTable.get(fieldPath))){
					return false;
				}
			}else{
				XPathResult result = (XPathResult)evaluator.evaluate(fieldPath,version,resolver,XPathResult.ORDERED_NODE_ITERATOR_TYPE,null);
				Node n;
				if ((n = result.iterateNext())!= null){
						if(!n.getNodeValue().equals(fieldTable.get(fieldPath))){
							return false;
						}
				}
			}
		}
		return true;
	}

	public void addItem(Item dataItem, int scpIndex){
		if (itemList.size() < scpIndex){
			for (int i= itemList.size(); i < scpIndex ; i++){
				itemList.add(i, null);
			}
		}
		itemList.add(scpIndex, dataItem);
	}

	public boolean validate(ArrayList<TargetIdentifier> tiList, ArrayList<LogicalAnnotationValidator> tavList, Hashtable itemFragmentItemMap){

		boolean valid = true;
		int i=0, j=0;
		Item dataItem1 = null, dataItem2 = null;
		TargetIdentifier ti1, ti2;
		LogicalAnnotationValidator tav1, tav2;
		
		Iterator itr = itemList.iterator();
		
		/* Get first not null item fragment */
		while (itr.hasNext() && (null == (dataItem2 = (Item)itr.next()))){
			j++;
		}
		
		while (itr.hasNext()){
			dataItem1 = dataItem2;
			i = j;
			dataItem2 = null;	
			while (itr.hasNext() && (null == (dataItem2 = (Item)itr.next()))){
				j++;
			}

			if (null == dataItem2){
				break;
			}
			
			if (BaseItem.CONTENT_CONSTANT == dataItem1.getContent() && BaseItem.CONTENT_CONSTANT == dataItem2.getContent()){
				ti1 = tiList.get(i);
				ti2 = tiList.get(j);
				tav1 = tavList.get(i);
				tav2 = tavList.get(j);
				
				if (haveConstantSchemas(dataItem1.getTarget(), dataItem2.getTarget(), ti1, ti2, tav1, tav2)){
					valid = areContentConstant(dataItem1.getVersion(dataItem1.getVersionCount() -1 ), dataItem2.getVersion(dataItem2.getVersionCount() -1 ),
												tav1, tav2, itemFragmentItemMap);
				}else{
					valid = true;
				}
			}
		}
		return valid;
	}

	public boolean existsVersion(int index){
		if (null != itemList.get(index)){
			return true;
		}else{
			return false;
		}
	}
	
	public Item getItemFragment(int numScp){
		return (Item)itemList.get(numScp);
	}
	
	private boolean haveConstantSchemas(String path1, String path2, 
								TargetIdentifier ti1, TargetIdentifier ti2,
								LogicalAnnotationValidator tav1, LogicalAnnotationValidator tav2){
		
		boolean areConstant = true;
		Hashtable ht1, ht2;
		ht1 = ti1.getChildAttributes(path1);
		ht2 = ti2.getChildAttributes(path2);
		
		/* Check whether all the attribute elements in ht1 also exist in ht2.
		 * And for every matching attribute, compare whether those attribute elements are the same,
		 * indicating that their attributes (e.g. type, required etc) are the same.
		 */
		
		Enumeration enum1 = ht1.keys();
		while (enum1.hasMoreElements() && areConstant){
			String attrName = (String)enum1.nextElement();
			Element attrElement1 = (Element)ht1.get(attrName);
			Element attrElement2 = (Element)ht2.get(attrName);
			areConstant = areSameElements(attrElement1, attrElement2);
		}
		/* If all the attributes are same, then only go ahead and check the elements */
		if (areConstant){
			/* Get child elements */
			ArrayList elementList1 = ti1.getChildElements(path1);
			ArrayList elementList2 = ti1.getChildElements(path1);
			
			/* If the list sizes are the same */
			if (elementList1.size() == elementList2.size()){
				/* Only <sequence> is handled, so the sequence of elements should be the same. */
				for (int i=0 ; i<elementList1.size() && areConstant; i++){
					Element e1 = (Element)elementList1.get(i);
					Element e2 = (Element)elementList2.get(i);
					
					/* Check whether the elements are the same */	
					if (areSameElements(e1, e2)){
						String newPath1 = path1 + "/" + e1.getLocalName();
						String newPath2 = path2 + "/" + e2.getLocalName();

						/* The elements at the newPath should either both be items or not. i.e. should have same status */	
						if (tav1.containsTarget(newPath1) == tav2.containsTarget(newPath2)){
							/* If they are not items, then only go down the tree to check its children.
							 * Otherwise stop there, since the content of an item include all the descendents
							 * till the descendent is an item.
							 */
							if (!tav1.containsTarget(newPath1)){
								areConstant = haveConstantSchemas(newPath1, newPath2, ti1, ti2, tav1, tav2);
							}
						}else{
							areConstant = false;
						}
					}
				}
			}else{
				areConstant = false;
			}
		}

		return areConstant;
	}
	
	private boolean areContentConstant(Element e1, Element e2,
										LogicalAnnotationValidator tav1, LogicalAnnotationValidator tav2,
										Hashtable itemFragmentItemMap){
		
		String targetName1 = "", targetName2 = "";
		if ("y".equals(e1.getAttribute("isItem"))){
			targetName1 = e1.getAttribute("originalElement");
			targetName2 = e2.getAttribute("originalElement");
		}else{
			targetName1 = e1.getLocalName();
			targetName2 = e2.getLocalName();
		}
		
		if (("y".equals(e1.getAttribute("isItem"))) && ("y".equals(e2.getAttribute("isItem")))){
			Item item1 = tav1.getItemPrototype(targetName1);
			RepItem repItem1 = new RepItem(e1,targetName1);
			item1.addVersionAll(repItem1.getVersions(),repItem1.getTemporalElement());
			item1.getItemIdentifier().updateFieldValues(item1.getVersion(0));
			Item item2 = tav2.getItemPrototype(targetName2);
			RepItem repItem2 = new RepItem(e2,targetName2);
			item2.addVersionAll(repItem2.getVersions(),repItem2.getTemporalElement());
			item2.getItemIdentifier().updateFieldValues(item2.getVersion(0));

			if (itemFragmentItemMap.get(item1) == itemFragmentItemMap.get(item2)){
				return true;
			}else{
				return false;
			}
		}else{
			NodeList nl = e1.getChildNodes();
			ArrayList nonAttrNodes1 = new ArrayList();
			//Create ArrayList of Element and text nodes.
			//While doing same, verify whether the other element has same attributes or not.
			for (int i=0 ; i<nl.getLength()  ; i++){
				if ((nl.item(i).getNodeType() == Node.ELEMENT_NODE) || (nl.item(i).getNodeType() == Node.TEXT_NODE)){
					nonAttrNodes1.add(nl.item(i));
				}
			}
			NamedNodeMap nnm = e1.getAttributes();
			Attr attr = null;
			for (int i=0 ; i<nnm.getLength() ; i++){
				attr = (Attr)nnm.item(i);
				if (!(e2.getAttribute(attr.getName()).equals(attr.getValue()))){
					return false;
				}
			}

			nl = e2.getChildNodes();
			ArrayList nonAttrNodes2 = new ArrayList();
			//Create ArrayList of Elemetn and text nodes.
			//While doing same veryfy whether the other element has same attributes or not.
			for (int i=0 ; i<nl.getLength()  ; i++){
				if ((nl.item(i).getNodeType() == Node.ELEMENT_NODE) || (nl.item(i).getNodeType() == Node.TEXT_NODE)){
					nonAttrNodes2.add(nl.item(i));
				}
			}
			nnm = e1.getAttributes();
			attr = null;
			for (int i=0 ; i<nnm.getLength() ; i++){
				attr = (Attr)nnm.item(i);
				if (!(e2.getAttribute(attr.getName()).equals(attr.getValue()))){
					return false;
				}
			}			
			
			//Check whether the text collected in previous 2 looops are equal
			//If the node is of type ELEMENT_TYPE, check whether their names are the same.
			if (nonAttrNodes1.size() == nonAttrNodes2.size()){
				for (int i=0 ; i<nonAttrNodes1.size() ; i++){
					Node n = (Node)nonAttrNodes1.get(i);
					Node m = (Node)nonAttrNodes2.get(i);
					if (n.getNodeType() == Node.TEXT_NODE){
						if (m.getNodeType() == Node.TEXT_NODE ){
							if (!(m.getNodeValue().equals(n.getNodeValue()))){
								return false;
							}
						}else{
							return false;
						}
					}else{
						if (!(m.getNodeName().equals(n.getNodeName()))){
							return false;
						}else{
							//sthomas - Signiture was wrong? Adding Hash arg at end.
							if (areContentConstant((Element)n,(Element)m, tav1, tav2, itemFragmentItemMap) == false){
								return false;
							}
						}
					}
				}
			}else{
				return false;
			}
		}
		return true;
	}
	
	private boolean areSameElements(Element e1, Element e2){
		
		NodeList nl = e1.getChildNodes();
		ArrayList nonAttrNodes1 = new ArrayList();
		//Create ArrayList of Element and text nodes.
		//While doing same, verify whether the other element has same attributes or not.
		for (int i=0 ; i<nl.getLength()  ; i++){
			if ((nl.item(i).getNodeType() == Node.ELEMENT_NODE) || (nl.item(i).getNodeType() == Node.TEXT_NODE)){
				nonAttrNodes1.add(nl.item(i));
			}
		}
		NamedNodeMap nnm = e1.getAttributes();
		Attr attr = null;
		for (int i=0 ; i<nnm.getLength() ; i++){
			attr = (Attr)nnm.item(i);
			if (!(e2.getAttribute(attr.getName()).equals(attr.getValue()))){
				return false;
			}
		}

		nl = e2.getChildNodes();
		ArrayList nonAttrNodes2 = new ArrayList();
		//Create ArrayList of Elemetn and text nodes.
		//While doing same veryfy whether the other element has same attributes or not.
		for (int i=0 ; i<nl.getLength()  ; i++){
			if ((nl.item(i).getNodeType() == Node.ELEMENT_NODE) || (nl.item(i).getNodeType() == Node.TEXT_NODE)){
				nonAttrNodes2.add(nl.item(i));
			}
		}
		nnm = e1.getAttributes();
		attr = null;
		for (int i=0 ; i<nnm.getLength() ; i++){
			attr = (Attr)nnm.item(i);
			if (!(e2.getAttribute(attr.getName()).equals(attr.getValue()))){
				return false;
			}
		}			
		
		//Check whether the text collected in previous 2 looops are equal
		//If the node is of type ELEMENT_TYPE, check whether their names are the same.
		if (nonAttrNodes1.size() == nonAttrNodes2.size()){
			for (int i=0 ; i<nonAttrNodes1.size(); i++){
				Node n = (Node)nonAttrNodes1.get(i);
				Node m = (Node)nonAttrNodes2.get(i);
				if (n.getNodeType() == Node.TEXT_NODE){
					if (m.getNodeType() == Node.TEXT_NODE ){
						if (!(m.getNodeValue().equals(n.getNodeValue()))){
							return false;
						}
					}else{
						return false;
					}
				}else{
					if (!(m.getNodeName().equals(n.getNodeName()))){
						return false;
					}
				}
			}
		}else{
			return false;
		}
	return true;
	}
}
