/**
 * 
 */
package cs.arizona.tau.xml;

import org.w3c.dom.*;
import org.w3c.dom.ls.*;

import cs.arizona.util.*;

import org.w3c.dom.xpath.XPathEvaluator;
import org.w3c.dom.xpath.XPathNSResolver;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Hashtable;

import cs.arizona.tau.time.ITimePeriod;
import cs.arizona.tau.time.TimePeriod;
import cs.arizona.tau.time.ITemporalRegion;
import cs.arizona.tau.time.TemporalRegion;
import cs.arizona.tau.time.ITemporalElement;
import cs.arizona.tau.time.TemporalElement;
import cs.arizona.tau.time.ITime;
import cs.arizona.util.ConventionalParser;
import cs.arizona.util.SchemaPathEvaluator;
import cs.arizona.util.TauLogger;
import cs.arizona.util.ValidatorProperties;


/**
 * @author spjoshi
 * @author sthomas
 *
 */
public class Primitives{
	
	private Document 					bundleDoc;
	private String   					temporalBundle;
	private Document 					temporalDoc;	

	private TargetIdentifier 			ti;
	private LogicalAnnotationValidator tav;
	private PhysicalAnnotationValidator pav;

	private XPathEvaluator 				evaluator;
	private XPathNSResolver 			resolver;
	
	private ConventionalParser 			cp;
	private ValidatorProperties 		vp;
	
	private String repSchemaNameAlias;

    private int cnt = 0;
	
	public Primitives(Document bundleDoc, String repSchemaNameAlias) {
		this.bundleDoc = bundleDoc;
		this.repSchemaNameAlias = repSchemaNameAlias;
	}
	
	public Primitives(TargetIdentifier ti, LogicalAnnotationValidator tav, PhysicalAnnotationValidator pav, String repSchemaNameAlias){
		this.ti = ti;
		this.tav = tav;
		this.pav = pav;
		init();
		this.repSchemaNameAlias = repSchemaNameAlias;
	}
	
	/**
	 * Initializes lsParser and lsSerializer objects to be used later for parsing.
	 */
	private void init(){
		cp = ConventionalParser.getInstance();
		vp = ValidatorProperties.getInstance();
	}

	
	
	
	/**
	 * Transforms from physical to temporal representation.
	 */
	public Element physicalToTemporalConversion_Rui(Document temporalDoc){
		
		this.temporalDoc = temporalDoc;
		Element temporalRoot = temporalDoc.getDocumentElement();
		ITimePeriod tp = new TimePeriod(temporalRoot.getAttribute("begin"), temporalRoot.getAttribute("end"));
		
		// Find the original root from the non-temporal documents.
		// Here again we are assuming that there would be only one element 
		// below <temporalRoot>, which is true if a_timeVarying is not used.
		Element originalRoot = null;
		NodeList nl = temporalRoot.getChildNodes();
		for(int i=0 ; i<nl.getLength() ; i++){
			if (Common.isElement(nl.item(i))){
				originalRoot = (Element)nl.item(i);
				TauLogger.logger.info("Found original root of non-temp document: " + originalRoot.getNodeName());
				break;
			}
		}
		
       	long t1p = System.nanoTime();
		TauLogger.logger.info("Marking items");
		markItems(originalRoot,tp,"");
       	long t2p = System.nanoTime();
	   	Common.printElaspedTime("      MarkItems", t1p, t2p);
		
		String target = "";
		Element newRoot = null;
		
		/**
		 * If the top element is present in the physical annotation, then it would already have repItem structure.
		 * Create RepItem using that element and then call function pushDown on that.
		 * If the top element is not present in the physical annotation, it would not have repItem structure.
		 * In that case, create a new RepItem and add the top element as one version of that repItem and then call 
		 * function pushDown on that repItem.
		 */
		if ("y".equals(originalRoot.getAttribute("isItem"))){
			target = originalRoot.getAttribute("originalElement");
			RepItem rootRepItem = new RepItem(originalRoot,target);
			TauLogger.logger.info("Pushing down RepItem with  " + originalRoot.getNodeName() + ", " + target + ", " +  rootRepItem.toString());
       		long t1c = System.nanoTime();
			newRoot = pushDown(rootRepItem);
       	    long t2c = System.nanoTime();
	   		Common.printElaspedTime("      PushDown", t1c, t2c);
			//System.out.println(     "      PushDown called " + cnt +" times");
		}else{
			target = originalRoot.getLocalName();
			RepItem rootRepItem = new RepItem(target, ITimePeriod.TRANSACTION_TIME, ITimePeriod.EXTENT_REP);
			rootRepItem.addVersion(originalRoot, tp);
			TauLogger.logger.info("Pushing down RepItem with  " + originalRoot.getNodeName() + ", " + target + ", " +  rootRepItem.toString());
       		long t1c = System.nanoTime();
			newRoot = pushDown(rootRepItem);
       	    long t2c = System.nanoTime();
	   		Common.printElaspedTime("      PushDown", t1c, t2c);
		}	
		/* Replace the original top element by the new element returned by pushDown function. */
		temporalRoot.replaceChild(newRoot, originalRoot);

		
       	long t1c = System.nanoTime();
		coalsceDocument(newRoot);	

       	long t2c = System.nanoTime();
	   	Common.printElaspedTime("      Coalesce", t1c, t2c);
		return temporalRoot;
	}
	
	
  public Element physicalToTemporalConversion(Document temporalDoc){
		
		this.temporalDoc = temporalDoc;
		Element temporalRoot = temporalDoc.getDocumentElement();
		ITimePeriod tp = new TimePeriod(temporalRoot.getAttribute("begin"), temporalRoot.getAttribute("end"));
		
		// Find the original root from the non-temporal documents.
		// Here again we are assuming that there would be only one element 
		// below <temporalRoot>, which is true if a_timeVarying is not used.
		Element originalRoot = null;
		NodeList nl = temporalRoot.getChildNodes();
		for(int i=0 ; i<nl.getLength() ; i++){
			if (nl.item(i).getNodeName().equals("temporalSchemaSet")) {
				continue;
			}
			if (Common.isElement(nl.item(i))){
				originalRoot = (Element)nl.item(i);
				TauLogger.logger.info("Found original root of non-temp document: " + originalRoot.getNodeName());
				break;
			}
		}
		
       	long t1p = System.nanoTime();
		TauLogger.logger.info("Marking items");
		markItems(originalRoot,tp,"");
       	long t2p = System.nanoTime();
	   	Common.printElaspedTime("      MarkItems", t1p, t2p);
		
		String target = "";
		Element newRoot = null;
		
		/**
		 * If the top element is present in the physical annotation, then it would already have repItem structure.
		 * Create RepItem using that element and then call function pushDown on that.
		 * If the top element is not present in the physical annotation, it would not have repItem structure.
		 * In that case, create a new RepItem and add the top element as one version of that repItem and then call 
		 * function pushDown on that repItem.
		 */
		if ("y".equals(originalRoot.getAttribute("isItem"))){
			target = originalRoot.getAttribute("originalElement");
			RepItem rootRepItem = new RepItem(originalRoot,target);
			TauLogger.logger.info("Pushing down RepItem with  " + originalRoot.getNodeName() + ", " + target + ", " +  rootRepItem.toString());
       		long t1c = System.nanoTime();
			newRoot = pushDown(rootRepItem);
       	    long t2c = System.nanoTime();
	   		Common.printElaspedTime("      PushDown", t1c, t2c);
			//System.out.println(     "      PushDown called " + cnt +" times");
		} else{
			target = originalRoot.getLocalName();
			RepItem rootRepItem = new RepItem(target, ITimePeriod.TRANSACTION_TIME, ITimePeriod.EXTENT_REP);
			rootRepItem.addVersion(originalRoot, tp);
			TauLogger.logger.info("Pushing down RepItem with  " + originalRoot.getNodeName() + ", " + target + ", " +  rootRepItem.toString());
       		long t1c = System.nanoTime();
			newRoot = pushDown(rootRepItem);
       	    long t2c = System.nanoTime();
	   		Common.printElaspedTime("      PushDown", t1c, t2c);
		}	
		/* Replace the original top element by the new element returned by pushDown function. */
		try {
		temporalRoot.replaceChild(newRoot, originalRoot);
		} catch (Exception ex) {
			System.err.println("Err in replacing: " + originalRoot.toString() +
                               " with " + newRoot.toString());
			System.err.println("not good");
		}

		
       	long t1c = System.nanoTime();
		coalsceDocument(newRoot);	

       	long t2c = System.nanoTime();
	   	Common.printElaspedTime("      Coalesce", t1c, t2c);
		return temporalRoot;
	}

	
	
	
	/**
	 * Steve's invention - just testing. Can this work? This is called from DoSquashing::squash.
	 */
	public Element rootToPhysicalConversion(Document temporalDoc){
		this.temporalDoc = temporalDoc;
		Element temporalRoot = temporalDoc.getDocumentElement();
		ITimePeriod tp = new TimePeriod(temporalRoot.getAttribute("begin"), temporalRoot.getAttribute("end"));

		Element originalRoot = null;
		NodeList nl = temporalRoot.getChildNodes();
		for(int i=0 ; i<nl.getLength() ; i++){
			if(nl.item(i).getNodeType() == Node.ELEMENT_NODE){
				originalRoot = (Element)nl.item(i);
				TauLogger.logger.info("Found original root of non-temp document: " + originalRoot.getNodeName());
				break;
			}
		}
				
		// Modifies originalRoot parameter.
		markItems2(originalRoot,tp,"");
		
		String targetName 	= "";
		Element newRoot = null;

		if ("y".equals(originalRoot.getAttribute("isItem"))){
			targetName = originalRoot.getAttribute("originalElement");
			RepItem rootRepItem = new RepItem(originalRoot,targetName);
			TauLogger.logger.info("Pushing down RepItem with  " + originalRoot.getNodeName() + " " + targetName);
			newRoot = pushDown2(rootRepItem);
		}else{
			targetName = originalRoot.getLocalName();
			RepItem rootRepItem = new RepItem(targetName, ITimePeriod.TRANSACTION_TIME, ITimePeriod.EXTENT_REP);
			rootRepItem.addVersion(originalRoot, tp);
			newRoot = pushDown2(rootRepItem);
		}
			
		/* Replace the original top element by the new element returned by pushDown function. */
		temporalRoot.removeChild(temporalRoot.getFirstChild());
		temporalRoot.appendChild(newRoot);
		//coalsceDocument(newRoot, "");
		return temporalRoot;
	}
	
	/**
	 * Steve's testing. Not a real function (yet).
	 * @param repItem
	 * Experimenting with this function. It is currently BROKEN.
	 */
	public void markItems2(Element e, ITime time1, String path ){
		//TauLogger.logger.info("Marking items of element " + e.getNodeName()); // e.getLocalName() );
		String newPath = "";
		if ("y".equals(e.getAttribute("isItem"))){
			newPath = path + "/" + e.getAttribute("originalElement");
		}else{
			newPath = path + "/" + e.getLocalName();
		}
		RepItem repItem = null;
		if (pav.containsTarget(newPath)){										/* If the newPath is present in the physical annotation */
			if (!newPath.equals("/inventory")){
				// Create new rep item
				Item item = new Item(e, true);		 
				item.getItemIdentifier().updateFieldValues(e,temporalDoc);		
				item.addVersion((Element)e.cloneNode(true),time1);				
				repItem = item.toRepItem(ITimePeriod.EXTENT_REP);
				//TauLogger.logger.info("Creating repItem for " + newPath + "");
				e.getParentNode().replaceChild(repItem.toXML(temporalDoc, repSchemaNameAlias),e);								/* Create repItem from given element and path */	
			} else {
				//TauLogger.logger.info("Creating repItem for " + newPath + "");
				repItem = new RepItem(e,newPath);
			}
			
			Iterator versionIterator = repItem.getVersionIterator();
			Iterator teIterator = repItem.getTemporalElement().iterator();
			while (versionIterator.hasNext()){
				Element currVersion = (Element)versionIterator.next();
				ITime currTime1 = (ITime)teIterator.next();
				NodeList nl = currVersion.getChildNodes();
				for (int i=0 ; i<nl.getLength() ; i++){
					
					if (Common.isElement(nl.item(i))){
						Element currElement = (Element)nl.item(i);
						markItems2(currElement,currTime1,newPath);
					}
				}
			}
		}else{
			//TauLogger.logger.info("PAV does not contain" + newPath);
			NodeList nl = e.getChildNodes();
			for (int i=0 ; i<nl.getLength() ; i++){
				if (Common.isElement(nl.item(i))){
					markItems2((Element)nl.item(i),time1,newPath);
				}
			}
		}
	}
	
	
	
	
	
	/**
	 * Steve's testing grounds. Not a real function.
	 * Experimenting with this function. It is currently BROKEN.
	 */
	public Element pushDown2(RepItem repItem){
		String path;
		path = repItem.getTarget();
		//TauLogger.logger.info("Pushing down RepItem with \"" + repItem.getTarget() + "\"");
		if (pav.containsTarget(path)){
			processChildElements(repItem);
			return repItem.toXML(temporalDoc, repSchemaNameAlias); 
		}else{
			if (repItem.getVersionCount() == 1){
				processChildElements(repItem);
			}else{
				// Need to merge the versions to create items and then call function pushDown on them.
				mergeVersions(repItem);
				processChildElements(repItem);
			}
			return repItem.getVersion(0);
		}
	}
	
	
	
	
	/**
	 * 
	 */

	
	
	
	
	/**
	 *  
	 * @param repItem
	 */
	private void processChildElements(RepItem repItem){
		String target = repItem.getTarget();
		TauLogger.logger.info("Processesing target " + target);
		Iterator versionIterator = repItem.getVersionIterator();
		Iterator teIterator = repItem.getTemporalElement().iterator();
		while(versionIterator.hasNext()){
			ArrayList childElementList = new ArrayList();
			Element ev = (Element)versionIterator.next();
			ITime time1 = (ITime)teIterator.next();
			NodeList nl = ev.getChildNodes();
			for (int i=0 ; i<nl.getLength() ; i++){
				if (nl.item(i).getNodeType() == Node.ELEMENT_NODE){
					Element currElement = (Element)nl.item(i);
					String targetName = "";
					if (currElement.getAttribute("isItem") == "y"){
						targetName = currElement.getAttribute("originalElement");
						//TauLogger.logger.info("Current element isItem and newPath is " + newPath);
						RepItem childRepItem = new RepItem(currElement,targetName);
						childElementList.add(pushDown(childRepItem)); 
					}else{
						targetName = currElement.getLocalName();
						//TauLogger.logger.info("Current element is NOT item and newPath is " + newPath);
						RepItem childRepItem = new RepItem(targetName,repItem.getTimeDimension(),repItem.getTimeRepresentation());
						childRepItem.addVersion(currElement,time1);
						childElementList.add(pushDown(childRepItem));
					}
				}
			}
			/**
			 * Now replace the original child elements from element version by these new elements from childElementList.
			 */
			int childElementListCounter = 0;
			for (int i=0 ; i<nl.getLength(); i++){
				if (nl.item(i).getNodeType() == Node.ELEMENT_NODE){
					Element e1 	= (Element)childElementList.get(childElementListCounter);
					Node e2 	= nl.item(i);
					//TauLogger.logger.info("Replacing  " + e1.getLocalName() + " with " + e2.getLocalName());
					ev.replaceChild(e1,e2);
					childElementListCounter++;
				}
			}
		}
	}

	
	
	
	
	/**
	 * 
	 * @param repItem
	 * This function outputs
	 */
	public void markItems_Rui(Element e, ITime time1, String target ){
		TauLogger.logger.info("Marking items of element " + e.getLocalName() );
		String targetName = "";
		if ("y".equals(e.getAttribute("isItem"))){
			targetName = e.getAttribute("originalElement");
		}else{
			targetName = e.getLocalName();
		}
		
		RepItem repItem = null;
		if (pav.containsTarget(targetName)){										/* If the newPath is present in the physical annotation */
			//TauLogger.logger.info("PAV contains " + newPath + "; creating repItem ");
			if (targetName.equals("person")) {
				System.out.println("Rui Stop");
			}
			repItem = new RepItem(e,targetName);									/* Create repItem from given element and path */	
		}else{
			//TauLogger.logger.info("PAV does not contain " + newPath );
			if (tav.containsTarget(targetName)){									/* If the element is present in the temporal annotation */
				//TauLogger.logger.info("TAV  contains " + newPath + "; creating repItem ");
				//TauLogger.logger.info("Creating repItem for " + newPath + "");
				Item item = tav.getItemPrototype(targetName);				 
				item.getItemIdentifier().updateFieldValues(e,temporalDoc);		/* Update itemIdentifier of the item prototype */ 
				item.addVersion((Element)e.cloneNode(true),time1);				/* Add current element as a version of the item prototype */
				repItem = item.toRepItem(ITimePeriod.EXTENT_REP);				/* Cast the item to repItem */ 				
				e.getParentNode().replaceChild(repItem.toXML(temporalDoc, repSchemaNameAlias),e);
			}
		}
		if ((tav.containsTarget(targetName)) || (pav.containsTarget(targetName))){
			//TauLogger.logger.info("TAV or PAV contains " + newPath);
			Iterator versionIterator = repItem.getVersionIterator();
			Iterator teIterator = repItem.getTemporalElement().iterator();
			while (versionIterator.hasNext()){
				Element currVersion = (Element)versionIterator.next();
				System.err.println(currVersion.getTagName() + ": " + currVersion.getTextContent());
				ITime currTime1 = (ITime)teIterator.next();
				NodeList nl = currVersion.getChildNodes();
				for (int i=0 ; i<nl.getLength() ; i++){
					if (nl.item(i).getNodeType() == Node.ELEMENT_NODE){
						markItems((Element)nl.item(i),currTime1,targetName);
					}
				}
			}
		}else{
			//TauLogger.logger.info("TAV or PAV does not contain" + newPath);
			NodeList nl = e.getChildNodes();
			for (int i=0 ; i<nl.getLength() ; i++){
				if (nl.item(i).getNodeType() == Node.ELEMENT_NODE){
					markItems((Element)nl.item(i),time1,targetName);
				}
			}
		}
	}
	
	public void markItems(Element e, ITime time1, String target ){
		TauLogger.logger.info("Marking items of element " + e.getLocalName() );
		String targetName = "";
		if ("y".equals(e.getAttribute("isItem"))){
			targetName = e.getAttribute("originalElement");
		}else{
			targetName = e.getLocalName();
		}
		
		RepItem repItem = null;
		if (pav.containsTarget(targetName)){										/* If the newPath is present in the physical annotation */
			//TauLogger.logger.info("PAV contains " + newPath + "; creating repItem ");
			repItem = new RepItem(e,targetName);									/* Create repItem from given element and path */	
		}else{
			//TauLogger.logger.info("PAV does not contain " + newPath );
			if (tav.containsTarget(targetName)){									/* If the element is present in the temporal annotation */
				//TauLogger.logger.info("TAV  contains " + newPath + "; creating repItem ");
				//TauLogger.logger.info("Creating repItem for " + newPath + "");
				Item item = tav.getItemPrototype(targetName);				 
				item.getItemIdentifier().updateFieldValues(e,temporalDoc);		/* Update itemIdentifier of the item prototype */ 
				item.addVersion((Element)e.cloneNode(true),time1);				/* Add current element as a version of the item prototype */
				repItem = item.toRepItem(ITimePeriod.EXTENT_REP);				/* Cast the item to repItem */ 				
				e.getParentNode().replaceChild(repItem.toXML(temporalDoc, repSchemaNameAlias),e);
			}
		}
		if ((tav.containsTarget(targetName)) || (pav.containsTarget(targetName))){
			//TauLogger.logger.info("TAV or PAV contains " + newPath);
			Iterator versionIterator = repItem.getVersionIterator();
			Iterator teIterator = repItem.getTemporalElement().iterator();
			while (versionIterator.hasNext()){
				Element currVersion = (Element)versionIterator.next();
				ITime currTime1 = (ITime)teIterator.next();
				NodeList nl = currVersion.getChildNodes();
				for (int i=0 ; i<nl.getLength() ; i++){
					if (nl.item(i).getNodeType() == Node.ELEMENT_NODE){
						markItems((Element)nl.item(i),currTime1,targetName);
					}
				}
			}
		}else{
			//TauLogger.logger.info("TAV or PAV does not contain" + newPath);
			NodeList nl = e.getChildNodes();
			for (int i=0 ; i<nl.getLength() ; i++){
				if (nl.item(i).getNodeType() == Node.ELEMENT_NODE){
					markItems((Element)nl.item(i),time1,targetName);
				}
			}
		}
	}
	
	
	
	
	/**
	 * Given a repItem which is not present in the temporal annotation, the function will try to merge different versions and
	 * convert that item to contain only a single version.
	 * @param repItem
	 */
	private void mergeVersions(RepItem repItem){
		
		TauLogger.logger.info("Merging Versions.");
		
		String target = repItem.getTarget();
		
		Iterator versionIterator = repItem.getVersionIterator();
		
		ArrayList versionToBeRemoved = new ArrayList();

		Element ev1 = null, ev2 = null;
		if (versionIterator.hasNext()){
			ev1 = (Element)versionIterator.next();
		}

		while (versionIterator.hasNext()){
			Hashtable ht = new Hashtable();
			ev2 = (Element)versionIterator.next();
			if (glueItemsFromTwoVersions(ev1,ev2,ht,target)== true){
				mergeTwoVersions(ev1,ht);
				versionToBeRemoved.add(ev2);
			}else{
				TauLogger.logger.debug("Couldn't glue two versions: " + ev1.toString() + " and " + ev2.toString());
				TauLogger.logger.fatal("Inconsistency between logical annotations, physical annotations, and/or slices.");
				System.exit(3);
			}
		}
		for (int i=0 ; i<versionToBeRemoved.size() ; i++){
			repItem.removeVersion((Element)versionToBeRemoved.get(i));
		}
	}
	
	
	
	
	
	/**
	 * 
	 */
	private void mergeTwoVersions(Element ev1, Hashtable ht){
		TauLogger.logger.info("Merging 2 Versions.");
		NodeList nl = ev1.getChildNodes();
		for (int i=0 ; i<nl.getLength() ; i++){
			if (nl.item(i).getNodeType() == Node.ELEMENT_NODE){
				Element e = (Element)nl.item(i);
				if (ht.containsKey(e)){
					Item item = (Item)ht.get(e);
					RepItem repItem = item.toRepItem(ITimePeriod.EXTENT_REP); 
					e.getParentNode().replaceChild(repItem.toXML(temporalDoc, repSchemaNameAlias),e);
//					return;
				}else{
					mergeTwoVersions(e,ht);
				}
			}
		}
	}
	
	
	
	
	
	/**
	 *  
	 * @param prevArr
	 * @param nextArr
	 * @return
	 */
	private boolean glueItemsFromTwoVersions(Element ev1, Element ev2, Hashtable ht, String target){
		String targetName = "";
		if ("y".equals(ev1.getAttribute("isItem"))){
			targetName = ev1.getAttribute("originalElement");
		}else{
			targetName = ev1.getLocalName();
		}
		if (tav.containsTarget(targetName)){
			if (("y".equals(ev1.getAttribute("isItem"))) && ("y".equals(ev2.getAttribute("isItem")))){
				Item item1 = tav.getItemPrototype(targetName);
				RepItem repItem1 = new RepItem(ev1,targetName);
				item1.addVersionAll(repItem1.getVersions(),repItem1.getTemporalElement());
				item1.getItemIdentifier().updateFieldValues(item1.getVersion(0),temporalDoc);
				Item item2 = tav.getItemPrototype(targetName);
				RepItem repItem2 = new RepItem(ev2,targetName);
				item2.addVersionAll(repItem2.getVersions(),repItem2.getTemporalElement());
				item2.getItemIdentifier().updateFieldValues(item2.getVersion(0),temporalDoc);

				if (item1.getItemIdentifier().equals(item2.getItemIdentifier())){
					item1.merge(item2);
					ht.put(ev1,item1);
					return true;
				}else{
					TauLogger.logger.info("Item identifiers not the same: \"" +item1.getItemIdentifier() + "\" and \"" + item2.getItemIdentifier() + "\"");
					return false;
				}
			}else{
				TauLogger.logger.info("Elements aren't items: \""+ev1.getNodeName() + "\" and \"" + ev2.getNodeName()  + "\"" );
				return false;
			}
		}else{
			NodeList nl = ev1.getChildNodes();
			ArrayList nonAttrNodes1 = new ArrayList();
			//Create ArrayList of Element and text nodes.
			//While doing same veryfy whether the other element has same attributes or not.
			for (int i=0 ; i<nl.getLength()  ; i++){
				if ((nl.item(i).getNodeType() == Node.ELEMENT_NODE) || (nl.item(i).getNodeType() == Node.TEXT_NODE)){
					nonAttrNodes1.add(nl.item(i));
				}
			}

			NamedNodeMap nnm = ev1.getAttributes();
			Attr attr = null;
			for (int i = 0 ; i<nnm.getLength() ; i++){
				attr = (Attr)nnm.item(i);
				if (!(ev2.getAttribute(attr.getName()).equals(attr.getValue()))){
					TauLogger.logger.info("Attribute names not the same: " + ev2.getAttribute(attr.getName()) + " and " +attr.getValue() );
					return false;
				}
			}
			
			nl = ev2.getChildNodes();
			ArrayList nonAttrNodes2 = new ArrayList();
			//Create ArrayList of Element and text nodes.
			//While doing same verify whether the other element has same attributes or not.
			for (int i=0 ; i<nl.getLength()  ; i++){
				if ((nl.item(i).getNodeType() == Node.ELEMENT_NODE) || (nl.item(i).getNodeType() == Node.TEXT_NODE)){
					nonAttrNodes2.add(nl.item(i));
				}
			}

			nnm = ev1.getAttributes();
			for (int i = 0 ; i<nnm.getLength() ; i++){
				attr = (Attr)nnm.item(i);
				if (!(ev2.getAttribute(attr.getName()).equals(attr.getValue()))){
					TauLogger.logger.info("Attribute names not the same: " + ev2.getAttribute(attr.getName()) + " and " +attr.getValue() );
					return false;
				}
			}
			
			//Check whether the text collected in previous 2 loops are equal
			//If the node is of type ELEMENT_TYPE, check whether their names are the same.
			if (nonAttrNodes1.size() == nonAttrNodes2.size()){
				for (int i=0 ; i<nonAttrNodes1.size() ; i++){
					Node n = (Node)nonAttrNodes1.get(i);
					Node m = (Node)nonAttrNodes2.get(i);
					if (n.getNodeType() == Node.TEXT_NODE){
						if (m.getNodeType() == Node.TEXT_NODE){
							String s1 = m.getNodeValue();
							String s2 = n.getNodeValue();
							if (!(s1.equals(s2))){
						    	TauLogger.logger.info("Two nodes values not equal (\"" + m.getNodeValue() + "\" !=  \"" + n.getNodeValue() + "\").");
						    	TauLogger.logger.info("First node name: \"" + m.getNodeName() + "\", second node name: \"" + n.getNodeName()+ "\".");
						    	return false;
							}
						}else{
							TauLogger.logger.info("M node not text, N is.");
							return false;
						}
					}else{
						if (!(m.getNodeName().equals(n.getNodeName()))){
							TauLogger.logger.info("Node names not equal");
							return false;
						}else{
							if (glueItemsFromTwoVersions((Element)n,(Element)m,ht,targetName) == false){
								TauLogger.logger.info("Can't glue n and m");
								return false;
							}
						}
					}
				}
			}
		}
		return true;
	}
	
	
	
	
	
	/**
	 * 
	 */
	private void coalsceDocument(Element e){
		String targetName = "";
		if ("y".equals(e.getAttribute("isItem"))){
			targetName = e.getAttribute("originalElement");
			Item item = tav.getItemPrototype(targetName);
			
			if (item == null){
				TauLogger.logger.info("Cannot coelesce document. Path \"" + targetName + "\" invalid.");	
				System.exit(3); //TODO: Something smarter.
			}
			
			RepItem repItem1 = new RepItem(e,targetName);
			item.addVersionAll(repItem1.getVersions(),repItem1.getTemporalElement());
			item.getItemIdentifier().updateFieldValues(item.getVersion(0),temporalDoc);
			item.coalsce(temporalDoc, tav, repSchemaNameAlias);
			
			Iterator versionIterator = item.getVersionIterator();
			while (versionIterator.hasNext()){
				Element ev = (Element)versionIterator.next(); 
				NodeList nl = ev.getChildNodes();
				for (int i=0 ; i<nl.getLength() ; i++){
					if (nl.item(i).getNodeType() == Node.ELEMENT_NODE){
						Element currElement = (Element)nl.item(i);
						coalsceDocument(currElement);
					}
				}
			}

			e.getParentNode().replaceChild(item.toRepItem(ITimePeriod.EXTENT_REP).toXML(temporalDoc, repSchemaNameAlias), e);
			
			// Oct 22 2008 - Do we need this?
			//cp.writeDocument(this.temporalDoc, strOutputDir + "/" + strBackFileNameBase + ".xml");
		}else{
			targetName = e.getLocalName();
			NodeList nl = e.getChildNodes();
			for (int i=0 ; i<nl.getLength() ; i++){
				if (nl.item(i).getNodeType() == Node.ELEMENT_NODE){
					Element currElement = (Element)nl.item(i);
					coalsceDocument(currElement);
				}
			}
		}
	}

	
	/**
	 * 
	 */
	public Element temporalToPhysicalConversion_Rui(Document temporalDoc){
		this.temporalDoc = temporalDoc;
		Element temporalRoot = temporalDoc.getDocumentElement();
		ITimePeriod tp = new TimePeriod(temporalRoot.getAttribute("begin"),temporalRoot.getAttribute("end"));
		
		// Here again we are assuming that there would be only one element below <temporalRoot>, 
		// which is true if a_timeVarying is not used.
		Element originalRoot = null;
/*		
		NodeList nl = temporalRoot.getChildNodes();
		for(int i=1 ; i<nl.getLength(); i++){
			if(nl.item(i).getNodeType() == Node.ELEMENT_NODE) {
				//String attr = ((Element)nl.item(i)).getAttribute("isItem");
				//if (attr != null && attr.equals("y")) {
				  originalRoot = (Element)nl.item(i);
				  break;
				//}
			}
		}
		
//		originalRoot = FindTemporalElement(temporalRoot);
		
		String targetName = "";
		RepItem rootRepItem  = null;
		if ("y".equals(originalRoot.getAttribute("isItem"))){
			targetName = originalRoot.getAttribute("originalElement");
			rootRepItem = new RepItem(originalRoot,targetName);
		}else{
			targetName = originalRoot.getLocalName();
			rootRepItem = new RepItem(targetName,ITimePeriod.TRANSACTION_TIME,ITimePeriod.EXTENT_REP);
			rootRepItem.addVersion(originalRoot,tp);
		}
		
		
		RepItem newRootRepItem = pushUp(rootRepItem);
		String originalRootName;

		if ("y".equals(originalRoot.getAttribute("isItem"))){
			originalRootName = originalRoot.getAttribute("originalElement");
		}else{
			originalRootName = originalRoot.getLocalName();
		}

		if (pav.containsTarget(originalRootName)){
			Element newRoot = newRootRepItem.toXML(temporalDoc, repSchemaNameAlias);
			//temporalRoot.replaceChild(newRoot, originalRoot);
			originalRoot.getParentNode().replaceChild(newRoot, originalRoot);
		}else{
			temporalRoot.replaceChild(newRootRepItem.getVersion(0),originalRoot);
		}
		
		return null;
		*/
		
		NodeList nl = temporalRoot.getChildNodes();
		for(int i=0 ; i<nl.getLength() ; i++){
			if (Common.isElement(nl.item(i))){
				originalRoot = (Element)nl.item(i);
				TauLogger.logger.info("Found original root of non-temp document: " + originalRoot.getNodeName());
				break;
			}
		}
		
       	long t1p = System.nanoTime();
		TauLogger.logger.info("Marking items");
		markItems(originalRoot,tp,"");
       	long t2p = System.nanoTime();
	   	Common.printElaspedTime("      MarkItems", t1p, t2p);
		
		String target = "";
		Element newRoot = null;
		
		/**
		 * If the top element is present in the physical annotation, then it would already have repItem structure.
		 * Create RepItem using that element and then call function pushDown on that.
		 * If the top element is not present in the physical annotation, it would not have repItem structure.
		 * In that case, create a new RepItem and add the top element as one version of that repItem and then call 
		 * function pushDown on that repItem.
		 */
		if ("y".equals(originalRoot.getAttribute("isItem"))){
			target = originalRoot.getAttribute("originalElement");
			RepItem rootRepItem = new RepItem(originalRoot,target);
			TauLogger.logger.info("Pushing up RepItem with  " + originalRoot.getNodeName() + ", " + target + ", " +  rootRepItem.toString());
       		long t1c = System.nanoTime();
			newRoot = pushUp(rootRepItem).toXML(temporalDoc, repSchemaNameAlias);
       	    long t2c = System.nanoTime();
	   		Common.printElaspedTime("      PushUp", t1c, t2c);
			//System.out.println(     "      PushDown called " + cnt +" times");
		}else{
			target = originalRoot.getLocalName();
			RepItem rootRepItem = new RepItem(target, ITimePeriod.TRANSACTION_TIME, ITimePeriod.EXTENT_REP);
			rootRepItem.addVersion(originalRoot, tp);
			TauLogger.logger.info("Pushing up RepItem with  " + originalRoot.getNodeName() + ", " + target + ", " +  rootRepItem.toString());
       		long t1c = System.nanoTime();
			newRoot = pushUp(rootRepItem).toXML(temporalDoc, repSchemaNameAlias);
       	    long t2c = System.nanoTime();
	   		Common.printElaspedTime("      PushUp", t1c, t2c);
		}	
		/* Replace the original top element by the new element returned by pushUp function. */
		temporalRoot.replaceChild(newRoot, originalRoot);
		return temporalRoot;
	}
	
	public Element temporalToPhysicalConversion(Document temporalDoc){
		this.temporalDoc = temporalDoc;
		Element temporalRoot = temporalDoc.getDocumentElement();
		ITimePeriod tp = new TimePeriod(temporalRoot.getAttribute("begin"),temporalRoot.getAttribute("end"));
		
		// Here again we are assuming that there would be only one element below <temporalRoot>, 
		// which is true if a_timeVarying is not used.
		Element originalRoot = null;
		NodeList nl = temporalRoot.getChildNodes();
		for(int i=0 ; i<nl.getLength() ; i++){
			if (nl.item(i).getNodeName().equals("temporalSchemaSet")) {
				continue;
			}
			if(nl.item(i).getNodeType() == Node.ELEMENT_NODE){
				originalRoot = (Element)nl.item(i);
				break;
			}
		}
		String targetName = "";
		RepItem rootRepItem  = null;
		if ("y".equals(originalRoot.getAttribute("isItem"))){
			targetName = originalRoot.getAttribute("originalElement");
			rootRepItem = new RepItem(originalRoot,targetName);
		}else{
			targetName = originalRoot.getLocalName();
			rootRepItem = new RepItem(targetName,ITimePeriod.TRANSACTION_TIME,ITimePeriod.EXTENT_REP);
			rootRepItem.addVersion(originalRoot,tp);
		}
		
		RepItem newRootRepItem = pushUp(rootRepItem);
		String originalRootName;

		if ("y".equals(originalRoot.getAttribute("isItem"))){
			originalRootName = originalRoot.getAttribute("originalElement");
		}else{
			originalRootName = originalRoot.getLocalName();
		}

		if (pav.containsTarget(originalRootName)){
			temporalRoot.replaceChild(newRootRepItem.toXML(temporalDoc, repSchemaNameAlias),originalRoot);
		}else{
			temporalRoot.replaceChild(newRootRepItem.getVersion(0),originalRoot);
		}
		return null;
	}
	
	
	public Element pushDown(RepItem repItem){
        cnt++;
		String target;
		target = repItem.getTarget();
		//TauLogger.logger.info("Pushing down RepItem with \"" + repItem.getTarget() + "\"");
		if (tav.containsTarget(target)){
			processChildElements(repItem);
			return repItem.toXML(temporalDoc, repSchemaNameAlias); 
		}else{
			if (repItem.getVersionCount() == 1){
				processChildElements(repItem);
			}else{
				// Need to merge the versions to create items and then call function pushDown on them.
				TauLogger.logger.info("Merging versions.");
				mergeVersions(repItem);
				TauLogger.logger.info("Processing child elements.");
				processChildElements(repItem);
			}
			return repItem.getVersion(0);
		}
	}
		
	
	/**
	 * 
	 */
	private RepItem pushUp(RepItem repItem){
		ArrayList newElementVersions = new ArrayList();
		ITemporalElement newTemporalElement = new TemporalElement();
		Iterator elementVersionIterator = repItem.getVersionIterator();
		Iterator teIterator = repItem.getTemporalElement().iterator(); 
		boolean hasChildItems = false;

		while ((elementVersionIterator.hasNext()) && (teIterator.hasNext())){
			ArrayList childItems = new ArrayList();
			Element ev = (Element)elementVersionIterator.next();
			ITime time1 = (ITime)teIterator.next();
			NodeList nl = ev.getChildNodes();
			for (int j=0 ;j<nl.getLength() ; j++){
				if (nl.item(j).getNodeType() == Node.ELEMENT_NODE){
					Element currElement = (Element)nl.item(j);
					if ("y".equals(currElement.getAttribute("isItem"))){
						String targetName = currElement.getAttribute("originalElement");
						RepItem newRepItem = new RepItem(currElement,targetName);
						childItems.add(pushUp(newRepItem));
						hasChildItems = true;
					}else{
						//Create a new RepItem of that element
						String targetName = currElement.getLocalName();
						RepItem newRepItem = new RepItem(targetName,repItem.getTimeDimension(), repItem.getTimeRepresentation());
						newRepItem.addVersion(currElement,time1);
						childItems.add(pushUp(newRepItem));
						hasChildItems = true;
					}
				}else{
					childItems.add(null);
				}
			}
			if (hasChildItems){
				splitVersions(ev,(ITimePeriod)time1,childItems,newElementVersions,newTemporalElement);
				hasChildItems = true;
			}
		}
		if (hasChildItems){
			repItem.clearVersions();
			Iterator it1 = newElementVersions.iterator(); Iterator it2 = newTemporalElement.iterator();
			while ((it1.hasNext()) && (it2.hasNext())){
				repItem.addVersion((Element)it1.next(),(ITime)it2.next());
			}
		}
		return repItem;
	}
	
	
	
	
	/**
	 * 
	 */
	private void splitVersions(Element versionElement, ITimePeriod tp, ArrayList childItems, ArrayList newElementVersions, ITemporalElement te){
//		te.setNumDimensions(1);
		ArrayList newVersions = new ArrayList();
		//Element tmp_ele = (Element)versionElement.cloneNode(true);
		newVersions.add(versionElement);
		ITemporalElement newTE = new TemporalElement();
		newTE.setNumDimensions(te.getNumDimensions());
		newTE.add(tp);
		
		for (int i=0 ; i<childItems.size() ; i++) {
			if (childItems.get(i) != null){
				RepItem currChildRepItem = (RepItem)childItems.get(i);
				if (!(pav.containsTarget(currChildRepItem.getTarget()))){
					//If the target is not present in the physical annotation, its parent should split and 
					//create different version for each version of childItem
					Iterator versionIterator = currChildRepItem.getVersionIterator();
					Iterator timePeriodIterator = currChildRepItem.getTemporalElement().iterator();
					while (versionIterator.hasNext()){
						TauLogger.logger.info("Calling replaceItemByVersion 1 on " + currChildRepItem.getTarget());
						replaceItemByVersion(newVersions,newTE,(Element)versionIterator.next(),(ITimePeriod)timePeriodIterator.next(), i);
					}
				}else{
					
                  // Rui: added this check since otherwise the same item appearing in both logical and
				  // physical annotations will cause chopping version to not properly functioning.
				  // however, this would ignore the case where the item is in both pav and tav.
				  /*if (!tav.containsTarget(currChildRepItem.getTarget())) {*/
					//If the target is present in the physical annotation.	
					TauLogger.logger.info("Calling replaceItemByVersion 2 on " + currChildRepItem.getTarget());
					Element ver_ele = currChildRepItem.toXML(temporalDoc, repSchemaNameAlias);
					replaceItemByVersion(newVersions,newTE, ver_ele, (ITimePeriod)currChildRepItem.getTemporalElement().getTimeSpan(),i);
					/*
				  } else {
				  
					  Iterator versionIterator = currChildRepItem.getVersionIterator();
						Iterator timePeriodIterator = currChildRepItem.getTemporalElement().iterator();
						while (versionIterator.hasNext()){
							TauLogger.logger.info("Calling replacteItemByVersion 1 on " + currChildRepItem.getTarget());
							replaceItemByVersion(newVersions,newTE,(Element)versionIterator.next(),(ITimePeriod)timePeriodIterator.next(), i);
						}
				  }
				  */
				}
			}
		}
		Iterator versionItr = newVersions.iterator();
		Iterator teItr = newTE.iterator();
		while (versionItr.hasNext()){
			newElementVersions.add(versionItr.next());
			te.add((ITime)teItr.next());
		}
	}

	
	
	
	/**
	 * 
	 */
	private void replaceItemByVersion(ArrayList parentVersions, ITemporalElement parentTemporalElement, Element childVersionElement, ITimePeriod childTP, int childIndex){

		ArrayList newParentVersions = new ArrayList();
		ITemporalElement newParentTemporalElement = new TemporalElement();
		newParentTemporalElement.setNumDimensions(parentTemporalElement.getNumDimensions());
		
		ArrayList parentVersionsToBeRemoved = new ArrayList();
		ITemporalElement parentTimePeriodsToBeRemoved = new TemporalElement();
		
		Element parentVersionElement = null;
		ITimePeriod parentTP = null;
		
		Iterator parentVersionIterator = parentVersions.iterator();
		Iterator parentTEIterator = parentTemporalElement.iterator();
		
		while (parentVersionIterator.hasNext()){
			parentVersionElement = (Element)parentVersionIterator.next();
			parentTP = (ITimePeriod)parentTEIterator.next();
			
			//TauLogger.logger.info("Parent Element: "  + parentVersionElement + " name: " + parentVersionElement.getNodeName());

			if (parentTP.getRelationship(childTP) > ITimePeriod.NO_OVERLAP){
				Iterator splitPeriodIterator = parentTP.split(childTP);
				while (splitPeriodIterator.hasNext()){
					ITimePeriod tp = (TimePeriod)splitPeriodIterator.next();
					if (tp.getRelationship(childTP) == ITimePeriod.A_EQUALS_B){
						Element cloneParentVersionElement = (Element)parentVersionElement.cloneNode(true);
						//Find the Element node at index 'childIndex' and then replace it by childVersionElement 
						NodeList nl = cloneParentVersionElement.getChildNodes();
						for (int i=0 ; i<nl.getLength() ; i++){ 
							Node n = nl.item(i);
							//TauLogger.logger.fatal("Looping through " + n.getNodeName() + " : " + n.getFirstChild());
							if (childIndex == i){
                              if (Common.isElement(nl.item(i))){
								//Element e = (Element)nl.item(i);
								//TauLogger.logger.info("replacing child with " + e.getNodeName());
								//cloneParentVersionElement.replaceChild(childVersionElement,(Element)nl.item(i));
							    // Rui changed this. The cloned element solved the problem of missing childNode in the calling function.
                                Element new_ch_ele = (Element)childVersionElement.cloneNode(true);
                                //if the 3rd bug is indeed a bug, this replace needs to be fixed.
                                // the new_ch_ele contains the e.g., projectSet with versioned childnodes
                                // however, the replaced node is the projectSet_RepItem/projectSet_item
							    cloneParentVersionElement.replaceChild(new_ch_ele,(Element)nl.item(i));
							  } else {
								TauLogger.logger.fatal("Unsquash error: " + n.getNodeName() + " : " + n.getTextContent());
								System.exit(2);
							  }
							}
						}
						chopChildItems(cloneParentVersionElement, tp);
						newParentVersions.add(cloneParentVersionElement);
						newParentTemporalElement.add(tp);
					}else{
						Element cloneParentVersionElement = (Element)parentVersionElement.cloneNode(true);
						chopChildItems(cloneParentVersionElement, tp);
						newParentVersions.add(cloneParentVersionElement);
					    newParentTemporalElement.add(tp);
					}
				}
				parentVersionsToBeRemoved.add(parentVersionElement); 
				parentTimePeriodsToBeRemoved.add(parentTP);
			}
		}
		
		Iterator versionItr = parentVersionsToBeRemoved.iterator();
		Iterator teItr = parentTimePeriodsToBeRemoved.iterator();
		while (versionItr.hasNext()){
			parentVersions.remove(versionItr.next());
			parentTemporalElement.remove((ITime)teItr.next());
		}
		
		versionItr = newParentVersions.iterator();
		teItr = newParentTemporalElement.iterator();
		while (versionItr.hasNext()){
			parentVersions.add(versionItr.next());
			parentTemporalElement.add((ITime)teItr.next());
		}
	}

	
	
	
	
	/*
	 * The function traverses the subtree rooted at e in in-order fashion and finds out whether it contains any item
	 * which extends beyond tp, All such versions are removed from the item. Thus the containment property is satisfied. 
	 * 
	 */
	private void chopChildItems(Element e, ITimePeriod tp){
		NodeList nl = e.getChildNodes();
		String targetName;
		Element newElement;
		for (int i=0 ; i< nl.getLength() ; i++){
			if (nl.item(i).getNodeType() == Node.ELEMENT_NODE){
				Element element = (Element)nl.item(i);
				newElement = element;
				targetName = element.getLocalName();
				if ("y".equals(element.getAttribute("isItem"))){
					targetName = element.getAttribute("originalElement");
					RepItem repItem = new RepItem(element, targetName );
					repItem.chopVersions(tp);
					newElement = repItem.toXML(temporalDoc, repSchemaNameAlias); 
					e.replaceChild(newElement,element);
				}
				chopChildItems(newElement, tp);
			}
		}
	}
	
	
	
	
}
