/**
 * 
 */
package cs.arizona.tau.xml;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;

import org.w3c.dom.*;

import cs.arizona.tau.time.ITimePeriod;
import cs.arizona.util.SchemaPathEvaluator;
import cs.arizona.util.TargetIdentifier;
import cs.arizona.util.TauLogger;
/**
 * @author spjoshi
 * TODO : 
 * 1) Remove hard-coding from function parseSnapshotSchema.
 * 2) Remove hard-coding from function parsePhysicalAnnotation.
 * 3) Exception handling.
 * 4) Remove all the references to variable topLevelRepItemPrototype and functions using that variable. 
 */
public class PhysicalAnnotationValidator extends GenericValidator implements
		IPhysicalAnnotationValidator {

	private Hashtable<String, Item> itemPrototypes 	= new Hashtable<String, Item>();
	private Document snapshotSchemaDocument;
	private Element physical; // Physical element of annotation document.
	private TargetIdentifier ti;
	private String repType;								//Type of representation (edit based, versioned, etc).
	private Hashtable<String, Element> targetElements;
	private ArrayList<String> targets = new ArrayList<String>();
	private Hashtable<String, RepItem> repItemPrototypes = new Hashtable<String, RepItem>();
	private RepItem topLevelRepItemPrototype = null;

	/**
	 * 
	 * @param physicalAnnotation
	 * @param snapshotSchema
	 */
	public PhysicalAnnotationValidator(String physicalAnnotation, String snapshotSchema, boolean createRepItemPrototypes) {
		super();
		Document annotationDocument = cp.parseDocument(physicalAnnotation, vp.getProperty("PXSchemaURL"), vp.getProperty("PXSchema"));
		snapshotSchemaDocument = cp.parseDocument(snapshotSchema, vp.getProperty("XMLSchemaURL"), vp.getProperty("XMLSchema"));
		NodeList physicalList = annotationDocument.getElementsByTagName("physical");
		if(physicalList.getLength() > 0) {
			this.physical = (Element) physicalList.item(0);
		} else {
			this.physical = null;
		}
		collectTargets();
		createItemPrototypes();
		if (createRepItemPrototypes == true){
			
			createRepItemPrototypes();
			createTopLevelRepItemPrototype();
		}
	}
	
	/**
	 * 
	 * @param annotationDocument
	 * @param snapshotSchemaDocument
	 */
	
	public PhysicalAnnotationValidator(Document annotationDocument, Document snapshotSchemaDocument, TargetIdentifier ti, boolean createRepItemPrototypes) {
		super();
		this.snapshotSchemaDocument = snapshotSchemaDocument;
		this.ti = ti;
		targetElements = new Hashtable<String, Element>();
		NodeList physicalList = annotationDocument.getElementsByTagName("physical");
		if(physicalList.getLength() > 0) {
			this.physical = (Element) physicalList.item(0);
		} else {
			this.physical = null;
		}
		createItemPrototypes();
		
		// Parse the file and look for the representation type.
		determineRepType();

		collectTargets();
		if (createRepItemPrototypes == true){
			createRepItemPrototypes();
			createTopLevelRepItemPrototype();
		}
	}
	
	
	
	public String getRepType(){
		return this.repType;
	}
		
	/* (non-Javadoc)
	 * @see cs.arizona.tau.xml.IPhysicalAnnotationValidator#validatePhysicalAnnotation(java.lang.String, java.lang.String, java.lang.String)
	 */
	public boolean validatePhysicalAnnotation() {
		return checkConsistency();
	}

	/**
	 * The function returns the name of topmost element which has been timestamped in Temporal Annotation.
	 * @return
	 */
	public String getTopTarget(){
		String str = (String)targets.get(0);
		String prevSubStr = "", subStr="";
		StringTokenizer st = new StringTokenizer(str,"/");
		while(st.hasMoreTokens()){
			prevSubStr = subStr;
			subStr = subStr + "/" + st.nextToken();
			Iterator itr = targets.iterator();
			while (itr.hasNext()){
				if (!(((String)itr.next()).startsWith(subStr))){
					break;
				}
			}
		}
		return prevSubStr;
	}

	// TODO: ???
	public boolean validateTopTarget(String topTarget){
		return true;
	}
	
	
	// borrowed from tav
	public void createItemPrototypes(){
		if(physical == null) {
			return;
		}
		NodeList nl=physical.getChildNodes();
		for (int i=0 ; i<nl.getLength(); i++){
			if (nl.item(i).getNodeType() == Node.ELEMENT_NODE){
				Element currentElement = (Element)nl.item(i);
				if (currentElement.getLocalName() == "stamp"){
					Item item = new Item(currentElement);
					String tgt = currentElement.getAttribute("target");
					itemPrototypes.put(tgt ,item);
				}
			}
		}
	}
	
	// sthomas- return null if not found. borrowed from tav
	public Item getItemPrototype(String target){
		Item o = ((Item)itemPrototypes.get(target));
		if (o != null){
			return o.cloneItem();
		}
		return null;
	}
	
	/**
	 * Checking whether every target given in the temporal annotation is present in the snapshot schema or not.
	 * @return
	 */
	private boolean checkConsistency(){
		if(physical == null) {
			return true; // There is no logical annotation to check. Vacuously true.
		}
		//Get list of all the elements with attribute
		NodeList nl = physical.getChildNodes();
		Element targetElement;
		for (int i=0 ; i<nl.getLength() ; i++){
			if (nl.item(i).getNodeType() == Node.ELEMENT_NODE){
				Element currentElement = (Element)nl.item(i);
				if (currentElement.getLocalName() == "stamp"){
					String target = currentElement.getAttribute("target");
					if ((targetElement = ti.getTarget(target))==null){
						TauLogger.logger.error("Could not validate physical annotation on \"" + target + "\"");
						return false;
					}else{	
						TauLogger.logger.debug("Adding target \"" + target + "\"");
						targetElements.put(targetElement.getAttribute("name"), targetElement);
					}
				}
			}
		}
		TauLogger.logger.info("Physical Annotations validated successfully.");	
		return true;
	}
	
	public Hashtable<String, Element> getTargetElements(){
		return targetElements;
	}
	
	public void collectTargets(){
		if(physical == null) {
			return;
		}
		NodeList nl=physical.getChildNodes();
		for (int i=0 ; i<nl.getLength(); i++){
			if (Common.isElement(nl.item(i))){
				Element currentElement = (Element)nl.item(i);
				if ((currentElement.getLocalName() == "stamp") || (currentElement.getNodeName() == "stamp")){
					String tgt = currentElement.getAttribute("target");
					TauLogger.logger.info("Adding target \"" + tgt + "\"");
					targets.add(tgt);
				}
			}
		}
	}
	
	
	/*
	 * @author sthomas
	 * Look for "representationType" attribute in root node.
	 */
	private void determineRepType(){
		if(physical == null) {
			return;
		}
		repType = physical.getAttribute("representationType");
		if (repType.equals("")){
			repType = "versioned";
		}
	}

	public boolean containsTarget(String target){
		if (targets.contains(target)){
			return true;
		}else{
			return false;
		}
	}

	public void createRepItemPrototypes(){
		if(physical == null) {
			return;
		}
		NodeList nl=physical.getChildNodes();
		for (int i=0 ; i<nl.getLength(); i++){
			if (nl.item(i).getNodeType() == Node.ELEMENT_NODE){
				Element currentElement = (Element)nl.item(i);
				if ((currentElement.getLocalName() == "stamp") || (currentElement.getNodeName() == "stamp")){
					RepItem repItem = new RepItem(currentElement);
					repItemPrototypes.put(currentElement.getAttribute("target"),repItem);
				}
			}
		}
	}
	
	private void createTopLevelRepItemPrototype(){
		/* Now create topLevelRepItemPrototype.
		 * Get the first target from targets */
		String topLevelElementPath;
		String target = (String)targets.get(0);
		topLevelElementPath = target;
		topLevelRepItemPrototype = new RepItem(topLevelElementPath, ITimePeriod.TRANSACTION_TIME, ITimePeriod.EXTENT_REP);
	}
	
	public RepItem getRepItemPrototype(String target){
		return (RepItem)repItemPrototypes.get(target);
	}
	
	public Iterator getTargetIterator(){
		return targets.iterator();
	}
}