/**
 * 
 */
package cs.arizona.tau.xml;

import java.io.*;


import org.w3c.dom.*;
import org.w3c.dom.ls.*;
import org.w3c.dom.xpath.XPathEvaluator;
import org.w3c.dom.xpath.XPathNSResolver;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Iterator;
import java.util.Hashtable;
import java.util.Date;
import java.util.ArrayList;


import cs.arizona.tau.docs.TemporalSchema;
import cs.arizona.tau.time.ITimePeriod;
import cs.arizona.tau.time.TimePeriod;


import cs.arizona.util.*;

/**
 * @author spjoshi
 * @author sthomas
 *
 */
public class DoUnSquashing implements IDoUnSquashing{

	private Document bundleDoc;
	private String temporalBundle_;
	
	private Document temporalSchemaDoc;
	private String   temporalSchema,
	 conventionalSchema,
	 annotation;
	
	private String repSchema;

	private Document _snapshotSchemaDoc;		//Document element for snapshot schema. 
	private Document _temporalAnnotationDoc;	//Document element for temporal annotation.
	private Document _physicalAnnotationDoc;	//Document element for physical annotation.
	private Document temporalDoc;			//Document element for temporal document.
	private Document defaultPhysicalAnnotationDoc = null;
	private Document annotationDoc;
	private Document conventionalSchemaDoc;
	
	private Document defaultAnnotationDoc = null;

	TargetIdentifier 		ti;
	LogicalAnnotationValidator lav;
	PhysicalAnnotationValidator pav;
	PhysicalAnnotationValidator defaultPav;

	XPathEvaluator 	evaluator;
	XPathNSResolver resolver;
	
	ConventionalParser 	cp;
	ValidatorProperties vp;
	
	String repSchemaNameAlias;
	
	private ArrayList<SnapshotContainer> snapshotsEdit; // For edit-based representation

	
	/*
	 * 
	 */
	public DoUnSquashing(String temporalSchema, int schemaVersion){
		this.temporalSchema = temporalSchema;
		init();
        if (schemaVersion >=0 ){
        	repSchemaNameAlias = vp.getProperty("RepSchemaNameAlias") + schemaVersion + ":";
        }else{
        	repSchemaNameAlias = "";
        }
        
		TemporalSchema ts = new TemporalSchema(vp, cp, temporalSchema);
		temporalSchemaDoc = ts.getTemporalSchemaDoc();
		annotationDoc = ts.getAnnotationDoc();
		conventionalSchemaDoc = ts.getConventionalSchemaDoc();
		conventionalSchema = ts.getConventionalSchemaName();
		
		ti = new TargetIdentifier(conventionalSchemaDoc);
	    // Create Document objects from the temp and phys annotation file names
		defaultAnnotationDoc = Common.createDefaultAnnotationDoc(cp, Common.getTopLevelSchemaElementName(ti));
		lav = new LogicalAnnotationValidator(annotationDoc,conventionalSchemaDoc,ti,true);
		pav = new PhysicalAnnotationValidator(annotationDoc,conventionalSchemaDoc,ti,true);
		defaultPav 	= new PhysicalAnnotationValidator(defaultAnnotationDoc,conventionalSchemaDoc,ti,true);
		
		DoSchemaMapping doSchemaMapping = new DoSchemaMapping();
		Document repSchemaDoc;
		repSchemaDoc = doSchemaMapping.createRepresentationalSchema(temporalSchema, 0);
		String tmp_dir = System.getProperty("java.io.tmpdir");
		if (UnSquash.LocalRepSchema) {
          tmp_dir = "."; 
		}
		repSchema = tmp_dir + "/myRepSchema.xsd";
		cp.writeDocument(repSchemaDoc, repSchema);
	}
	
	
	/*
	 * 
	 */
	public DoUnSquashing(String snapshotSchema, String temporalAnnotation, String physicalAnnotation, int schemaVersion) {
		init();
        if (schemaVersion >=0 ){
        	repSchemaNameAlias = vp.getProperty("RepSchemaNameAlias") + schemaVersion + ":";
        }else{
        	repSchemaNameAlias = "";
        }
		//Get names of all the 3 documents required for building Representational schema and parse them.
		//snapshotSchemaDoc=cp.parseDocument(snapshotSchema, null, vp.getProperty("XMLSchema"), false);

		/*
        //Initialize SchemaPathEvaluator
        ti = new TargetIdentifier(snapshotSchemaDoc);
		temporalAnnotationDoc=cp.parseDocument(temporalAnnotation, null, vp.getProperty("TXSchema"));
		physicalAnnotationDoc=cp.parseDocument(physicalAnnotation, null, vp.getProperty("PXSchema"));
		createDefaultPhysicalAnnotationDoc();

		//Validate Temporal and Physical Annotations	
		tav = new LogicalAnnotationValidator(temporalAnnotationDoc,snapshotSchemaDoc,ti,true);
		tav.validateLogicalAnnotation();
		pav = new PhysicalAnnotationValidator(physicalAnnotationDoc,snapshotSchemaDoc,ti,true);
		pav.validatePhysicalAnnotation();
		defaultPav = new PhysicalAnnotationValidator(defaultPhysicalAnnotationDoc,snapshotSchemaDoc,ti,true);
		*/
		
		//conventionalSchemaDoc = cp.parseDocument(conventionalSchema, null, vp.getProperty("XMLSchema"), false);
		ti = new TargetIdentifier(conventionalSchemaDoc);
	    // Create Document objects from the temp and phys annotation file names
	    //annotationDoc = cp.parseDocument(annotation, null, vp.getProperty("ASchema"));
		lav = new LogicalAnnotationValidator(annotationDoc,conventionalSchemaDoc,ti,true);
		pav = new PhysicalAnnotationValidator(annotationDoc,conventionalSchemaDoc,ti,true);
		defaultPav = new PhysicalAnnotationValidator(defaultAnnotationDoc,conventionalSchemaDoc,ti,true);
		  
		DoSchemaMapping doSchemaMapping = new DoSchemaMapping();
		Document repSchemaDoc;
		repSchemaDoc = doSchemaMapping.createRepresentationalSchema(snapshotSchema, temporalAnnotation, physicalAnnotation, 0);
		cp.writeDocument(repSchemaDoc, repSchema);
	}
	
	/**
	 * Initializes lsParser and lsSerializer objects to be used later for parsing.
	 */
	private void init(){
		cp = ConventionalParser.getInstance();
		vp = ValidatorProperties.getInstance();
		//repSchema = vp.getProperty("Scratch") + "/" + "temporaryRepresentationalSchema.xml";
	}

	
	/**
	 * Just an interface into one of the unSquashes (representation type).
	 */
	public Hashtable unSquash(String tempDataDir, String temporalDocument){
		
		// Find out which representation type we used.
		if (pav.getRepType().equals("edit")){
			System.out.println("edit based unsquash");
			return unSquashEdit(temporalDocument);
		} 
		else if (pav.getRepType().equals("versioned")){
			System.out.println("item based unsquash");
			return unSquashVer(tempDataDir, temporalDocument);
		}
		TauLogger.logger.info("Unknown representation type \"" + pav.getRepType() +"\"");
		System.exit(3); //TODO: something smarter.
		
		return null;
	}
	
	/**
	 * Just an interface into one of the unSquashes (representation type).
	 */
	public ArrayList getSnapshots(){
		
		// Find out which representation type we used.
		if (pav.getRepType().equals("edit")){
			return snapshotsEdit;
		} 
		else if (pav.getRepType().equals("versioned")){
			// TODO
			//return unSquashVer(temporalDocument);
		}
		TauLogger.logger.info("Unknown representation type \"" + pav.getRepType() +"\"");
		System.exit(3); //TODO: something smarter.
		
		return null;
	}
	
	
	/**
	 * @author shailiesh
	 * Unsquash with the original representation
	 */
	public Hashtable unSquashVer(String tempDataDir, String temporalDocument){
        long t1 = System.nanoTime();
		Hashtable snapshots;
		
		TauLogger.logger.info("UnSquashing with version-based representation.");
		//repSchema = tempDataDir + "/myTempSchema.xml";
		//cp.parseDocument(repSchema, null, vp.getProperty("XMLSchema"));
		//repSchema = tempDataDir + "/mySnapshotSchema.xsd";
		this.temporalDoc = cp.parseDocument(tempDataDir + "/" + temporalDocument,null,conventionalSchema, false);
		Primitives primitives= null;
		// Steve: Why are these here? Do they serve any purpose?
        long t1t = System.nanoTime();
        primitives = new Primitives(ti,lav,defaultPav, repSchemaNameAlias);
        
		//primitives.temporalToPhysicalConversion(temporalDoc);
		
        long t2t = System.nanoTime();
	    Common.printElaspedTime("   TempToPhysical", t1t, t2t);
	    
		t1t = System.nanoTime();
		primitives = new Primitives(ti, lav, pav, repSchemaNameAlias);
	    primitives.physicalToTemporalConversion(temporalDoc);
		t2t = System.nanoTime();
	    Common.printElaspedTime("   TempToPhys", t1t, t2t);
	    
        t1t = System.nanoTime();
		Element temporalRoot = temporalDoc.getDocumentElement();
		snapshots = getSnapshots(temporalRoot);
        t2t = System.nanoTime();
	    Common.printElaspedTime("   getSnapshots", t1t, t2t);

        long t2 = System.nanoTime();
	    Common.printElaspedTime("unsquashItem", t1, t2);
		return snapshots;
	}
	
	
	/*
	 * 
	 */
	public Hashtable unSquash(Element temporalRoot){
		Hashtable snapshots;
		
		temporalDoc = cp.createDocument(vp.getProperty("RepSchemaURL"), repSchemaNameAlias + "temporalRoot", null);
        Element newtemporalRoot = temporalDoc.getDocumentElement();
		Element importedtemporalRoot = (Element)temporalDoc.importNode(temporalRoot, true);
		
		NodeList nl = importedtemporalRoot.getChildNodes();
		for (int i=0 ; i<nl.getLength() ; i++){
			newtemporalRoot.appendChild(nl.item(i));	
		}

		newtemporalRoot.setAttribute("begin",temporalRoot.getAttribute("begin"));
		newtemporalRoot.setAttribute("end", temporalRoot.getAttribute("end"));
		newtemporalRoot.setAttribute("xmlns:tv", vp.getProperty("TVSchemaURL"));

		Primitives primitives = new Primitives(ti, lav, pav, repSchemaNameAlias);
		primitives.physicalToTemporalConversion(temporalDoc);

		primitives = new Primitives(ti,lav,defaultPav, repSchemaNameAlias);
		primitives.temporalToPhysicalConversion(temporalDoc);
		
		snapshots = getSnapshots(newtemporalRoot);
		
		return snapshots;
	}

	/*
	public boolean GetSnapshotsRec(Element current_element, Hashtable snapshots) {
		if (current_element.getNodeName().contains("_RepItem")) {
			RepItem rootRepItem = new RepItem(current_element, current_element.getLocalName());
			Iterator versionIterator = rootRepItem.getVersionIterator();
			Iterator teIterator = rootRepItem.getTemporalElement().iterator();
			while ((versionIterator.hasNext()) && (teIterator.hasNext())){
				Element version = (Element)versionIterator.next();
				ITimePeriod tp = (ITimePeriod)teIterator.next();
				snapshots.put(tp, version);
			}
			return true;
		}
		NodeList child_nodes = current_element.getChildNodes();
		for (int i = 0; i < child_nodes.getLength(); ++i) {
          Node child_node = child_nodes.item(i);
          if (child_node.getNodeType() == Node.ELEMENT_NODE) {
            if (GetSnapshotsRec((Element)child_node, snapshots)) {
              return true;
            }
          }
		}
		return false;
	}
	*/
	
	/*
	 * 
	 */
	/*
	public Hashtable getSnapshots(Element temporalRoot){
		Hashtable snapshots = new Hashtable();
		GetSnapshotsRec(temporalRoot, snapshots);
		return snapshots;
	}
	*/
	
	public Hashtable getSnapshots(Element temporalRoot){
		Hashtable snapshots = new Hashtable();
		
		//Here again we are assuming that there would be only one element 
		//below <temporalRoot>, which is true if a_timeVarying is not used.
		Element originalRoot = null;
		NodeList nl = temporalRoot.getChildNodes();
		for(int i=2 ; i<nl.getLength() ; i++){
			if((nl.item(i).getNodeType() == Node.ELEMENT_NODE)){
				originalRoot = (Element)nl.item(i);
				break;
			}
		}

		RepItem rootRepItem = new RepItem(originalRoot, originalRoot.getLocalName());
		Iterator versionIterator = rootRepItem.getVersionIterator();
		Iterator teIterator = rootRepItem.getTemporalElement().iterator();
		while ((versionIterator.hasNext()) && (teIterator.hasNext())){
			Element version = (Element)versionIterator.next();
			ITimePeriod tp = (ITimePeriod)teIterator.next();
			snapshots.put(tp, version);
		}
		
		return snapshots;
	}
	
	
	/*
	 * 
	 */
	public Document getSnapshot(String temporalDocument, String strDate){
		this.temporalDoc = cp.parseDocument(temporalDocument,null,repSchema);
		Element temporalRoot = temporalDoc.getDocumentElement();
		return getSnapshot(temporalRoot, strDate);
	}
	
	
	/*
	 * 
	 */
	public Document getSnapshot(Element temporalRoot, String strDate){
		String strBeginDate = temporalRoot.getAttribute("begin");
		String strEndDate = temporalRoot.getAttribute("end");
		Date date, beginDate, endDate;
		try{
			SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
			date = sdf.parse(strDate);
			beginDate = sdf.parse(strBeginDate);;
			endDate = sdf.parse(strEndDate);
		}catch (ParseException pe){
			throw new RuntimeException(pe);
		}
		
		Document snapshotDoc = cp.createDocument(null, "root", null);
		if ((beginDate.equals(date)) || ((beginDate.before(date)) && (endDate.after(date)))){
			//Here again we are assuming that there would be only one element below <temporalRoot>, which is true if a_timeVarying is not used.
			Element originalRoot = null;
			NodeList nl = temporalRoot.getChildNodes();
			for(int i=0 ; i<nl.getLength() ; i++){
				if(nl.item(i).getNodeType() == Node.ELEMENT_NODE){
					originalRoot = (Element)nl.item(i);
					break;
				}
			}
			Element importedRoot = (Element)snapshotDoc.importNode(originalRoot, true);
			snapshotDoc.getDocumentElement().appendChild(importedRoot);
			extractSnapshot(snapshotDoc, importedRoot, date);
		}
		return snapshotDoc;
	}

	
	/*
	 * 
	 */
	private void extractSnapshot(Document doc, Element e, Date date){
		Element snapshotElement;
		if ("y".equals(e.getAttribute("isItem"))){
			RepItem repItem = new RepItem(e,"");
			snapshotElement = repItem.getSnapshot(date);
			if (snapshotElement != null){
				e.getParentNode().replaceChild(snapshotElement,e);
			}else{
				e.getParentNode().removeChild(e);
			}
		}else{
			snapshotElement = e;
		}

		if (snapshotElement != null){
			NodeList nl = snapshotElement.getChildNodes();
			for (int i=0 ; i< nl.getLength() ; i++){
				if (nl.item(i).getNodeType() == Node.ELEMENT_NODE){
					extractSnapshot(doc, (Element)nl.item(i), date);
				}
			}
		}
	}

	
	/**
	 * @author sthomas
	 * Unsquash with the edit-based representation. Need the help of the patch tool.
	 */
	public Hashtable unSquashEdit(String temporalDocument){
        long t1s = System.nanoTime();
		snapshotsEdit = new ArrayList<SnapshotContainer>();
		TauLogger.logger.info("UnSquashing with edit-based representation.");
		
		cp.parseDocument(repSchema, null, vp.getProperty("XMLSchema"), false);
		this.temporalDoc 	= cp.parseDocument(temporalDocument,null,repSchema, false);
		Element temporalRoot 		= temporalDoc.getDocumentElement();	
		NodeList nl 		= temporalRoot.getChildNodes();
		boolean firstElementFound = false;
		
		Node a, b;
		String fileName, lastFileName ="", lastDate="", date="";
		
		for(int i=0 ; i<nl.getLength() ; i++){
			a = nl.item(i);
			if(Common.isElement(a)){
				if (Common.isNamed(a, "timestamp_TransExtent")){	
					String beginDate 	= ((Element)a).getAttribute("begin");
					String endDate 	 	= ((Element)a).getAttribute("end");
					if (endDate.equals("")){
						endDate = "9999-12-31";
					}
					ITimePeriod tp 		= new TimePeriod(beginDate, endDate);
					
					if (firstElementFound == false){
        				//t1 = System.nanoTime();
						firstElementFound = true;
						Element version 	= Common.getNextElement(a);
						//String beginDate 	= ((Element)a).getAttribute("begin");
						//String endDate 	 	= ((Element)a).getAttribute("end");
						
						fileName = "slice_" + beginDate + "_" + endDate + ".xml";
						
						cp.writeElement(version, fileName);
						
						// Now Run through filter
						Common.filterEditOutput(fileName);					
						lastFileName 	= fileName;
						lastDate 		= endDate;
						
						SnapshotContainer sc = new SnapshotContainer(tp, fileName);
						snapshotsEdit.add( sc );
						//snapshotsEdit.put(tp, fileName);
        				long t2 = System.nanoTime();
	    				//Common.printElaspedTime("   firstElement", t1, t2);
					} else {
        		//		t1 = System.nanoTime();
						date = ((Element)a).getAttribute("begin");
						fileName = "slice_" + beginDate + "_" + endDate + ".xml";
						Common.runPatchCommand((Element)a, lastFileName, fileName);
						lastFileName = fileName;
						
						SnapshotContainer sc = new SnapshotContainer(tp, fileName);
						snapshotsEdit.add( sc );
						//snapshotsEdit.put(tp, fileName);
						lastDate = date;
        				long t2 = System.nanoTime();
	    				//Common.printElaspedTime("   otherElement", t1, t2);
						
					}
				} // end change
			} //if is element
		}
		
		// Nothing to return since the files have already been written to disk.
        long t2s = System.nanoTime();
	    Common.printElaspedTime("unsquashEdit total", t1s, t2s);
		return new Hashtable();
	}
	
	
	/*
	 *	The function creates a Default Physical annotation, in which timestamp is represented only at the top level.
	 *  Initially when different documents are merged initially, only top level element is shown to be time varying
	 *  This is a kind of most basic physical annotation. It is then passed to the function physicalToTemporalConversion
	 *  of Primitives and then the timestamps are pushed down till the elements in temporal annotation.    
	 */
	private void createDefaultPhysicalAnnotationDoc(){
		String topLevelElementName = getTopLevelSchemaElementName();
        try {
            // get DOM Implementation using DOM Registry
            defaultPhysicalAnnotationDoc = cp.createDocument(null,"physicalAnnotations",null);
            Element rootElement = defaultPhysicalAnnotationDoc.getDocumentElement();
            Element stampElement = defaultPhysicalAnnotationDoc.createElement("stamp");				/* create stampElement */
            Element stampKindElement = defaultPhysicalAnnotationDoc.createElement("stampKind");		/* create stampKindElement */
            stampKindElement.setAttribute("timeDimension","transactionTime");						/* Set attributes of stampKindElement */
            stampKindElement.setAttribute("stampBounds","extent");
            stampElement.appendChild(stampKindElement);												/* Append stampKindElement to stampElement */
            stampElement.setAttribute("target","/" + topLevelElementName);							/* Set attributes of stampElement */	
            stampElement.setAttribute("dataInclusion","expandedVersion");
            rootElement.appendChild(stampElement);													/* Append stampElement as child of rootElement */
            
			//Store the temporary file in the directory where config.xml directory is present 
			String temporalDocFile = vp.getProperty("Scratch") + vp.getProperty("DefaultPhysicalAnnotationFile");

			cp.writeDocument(defaultPhysicalAnnotationDoc, temporalDocFile);	
        }catch (Exception e){
        	e.printStackTrace();
        }		
	}
	
	
	
	/*
	 * The function needs to be implemented. It should analyze the snapshotSchemaDoc and find out the top level element.
	 * The method used in the old implementation of SchemaMapper (by earlier group) could also be used.
	 */
	private String getTopLevelSchemaElementName(){
		return ti.getTopLevelElement().getAttribute("name");
	}
}
