/**
 * 
 */
package cs.arizona.tau.xml;

import org.w3c.dom.*;
import org.w3c.dom.ls.*;

import java.io.File;
import java.util.Iterator;
import java.util.Hashtable;
import java.util.Enumeration;
import java.util.ArrayList;

import cs.arizona.tau.docs.TemporalSchema;
import cs.arizona.tau.time.ITimePeriod;
import cs.arizona.tau.time.TimePeriod;
import cs.arizona.tau.xml.temporalconstraint.TemporalConstraintValidator;

import cs.arizona.util.*;
/**
 * @author sthomas
 * @author spjoshi
 *
 */
public class DoTemporalValidation implements IDoTemporalValidation{

	private ConventionalParser 	cp;
	private ValidatorProperties vp;
	private Document 			bundleDoc;
	private String 				temporalSchema;
	private Hashtable 			itemTable = new Hashtable();
	private ArrayList 			itemList;
	Document 					temporalDoc;	//Document element for temporal document
	private Document defaultPhysicalAnnotationDoc = null;
	TargetIdentifier 			ti;
	LogicalAnnotationValidator tav;
	PhysicalAnnotationValidator pav;
	PhysicalAnnotationValidator defaultPav;
	String 						repSchemaNameAlias;
	private boolean				schemaVersion;
	
	private Document annotationDoc;
	private Document conventionalSchemaDoc;
	private String conventional_schema_location_;
	private String temporal_schema_location_;

	
	/**
	 * 
	 */
	public DoTemporalValidation(Document bundleDoc, int schemaVersion) {
		this.bundleDoc = bundleDoc;
		init();
        if (schemaVersion >=0 ){
        	repSchemaNameAlias = vp.getProperty("RepSchemaNameAlias") + schemaVersion + ":";
        }else{
        	repSchemaNameAlias = "";
        }
	}

	
	/**
	 * 
	 * @param temporalBundle
	 * @param schemaVersion
	 */
	public DoTemporalValidation(String temporalBundle, int schemaVersion) {
		this.temporalSchema = temporalBundle;
		this.schemaVersion = Boolean.parseBoolean(Integer.toString(schemaVersion));
		init();
        if (schemaVersion >=0 ){
        	repSchemaNameAlias = vp.getProperty("RepSchemaNameAlias") + schemaVersion + ":";
        }else{
        	repSchemaNameAlias = "";
        }
//		parseBundle();
		TemporalSchema ts = new TemporalSchema(vp, cp, temporalSchema);
		annotationDoc = ts.getAnnotationDoc();
		conventionalSchemaDoc = ts.getConventionalSchemaDoc();
		temporal_schema_location_ = ts.getTemporalSchemaName();
		conventional_schema_location_ = ts.getConventionalSchemaName();
		
        ti = new TargetIdentifier(conventionalSchemaDoc);
		tav = new LogicalAnnotationValidator(annotationDoc,conventionalSchemaDoc,ti,true);
		tav.validateLogicalAnnotation();
		pav = new PhysicalAnnotationValidator(annotationDoc,conventionalSchemaDoc,ti,true);
		pav.validatePhysicalAnnotation();
		defaultPhysicalAnnotationDoc = Common.createDefaultAnnotationDoc(cp, Common.getTopLevelSchemaElementName(ti));
		defaultPav 	= new PhysicalAnnotationValidator(defaultPhysicalAnnotationDoc,conventionalSchemaDoc,ti,true);
	}
	
	
	/**
	 * 
	 * @param snapshotSchema
	 * @param temporalAnnotation
	 * @param physicalAnnotation
	 * @param schemaVersion
	 */
	public DoTemporalValidation(String snapshotSchema, String temporalAnnotation, String physicalAnnotation, int schemaVersion){
		Document snapshotSchemaDoc;
		Document temporalAnnotationDoc;
		Document physicalAnnotationDoc;
		
		init();
        if (schemaVersion >=0 ){
        	repSchemaNameAlias = vp.getProperty("RepSchemaNameAlias") + schemaVersion + ":";
        }else{
        	repSchemaNameAlias = "";
        }
		snapshotSchemaDoc = cp.parseDocument(snapshotSchema, null, vp.getProperty("XMLSchema"), false);

        // Initialize SchemaPathEvaluator
        ti = new TargetIdentifier(snapshotSchemaDoc);
		temporalAnnotationDoc=cp.parseDocument(temporalAnnotation, null, vp.getProperty("TXSchema"));
		physicalAnnotationDoc=cp.parseDocument(physicalAnnotation, null, vp.getProperty("PXSchema"));

		// Validate Temporal and Physical Annotations	
		tav = new LogicalAnnotationValidator(temporalAnnotationDoc,snapshotSchemaDoc,ti,true);
		pav = new PhysicalAnnotationValidator(physicalAnnotationDoc,snapshotSchemaDoc,ti,true);
		defaultPav 	= new PhysicalAnnotationValidator(defaultPhysicalAnnotationDoc,snapshotSchemaDoc,ti,true);
		Common.validateAnnotations(tav, pav);
	}
	
	
	/**
	 * 
	 * @param spe
	 * @param tav
	 * @param pav
	 * @param schemaVersion
	 */
	public DoTemporalValidation(TargetIdentifier ti, LogicalAnnotationValidator tav, PhysicalAnnotationValidator pav, int schemaVersion){
		this.ti = ti;
		this.tav = tav;
		this.pav = pav;

        if (schemaVersion >=0 ){
        	repSchemaNameAlias = vp.getProperty("RepSchemaNameAlias") + schemaVersion + ":";
        }else{
        	repSchemaNameAlias = "";
        }
		
		init();
	}
	
	
	
	/**
	 * Initializes lsParser and lsSerializer objects to be used later for parsing.
	 */
	private void init(){
		cp = ConventionalParser.getInstance();
		vp = ValidatorProperties.getInstance();
		itemList = new ArrayList();
	}

	
	/**
	 * The function would traverse through all the document and collect different items. 
	 * For every element, it should check whether that element is an item. If yes, it would check
	 * whether that item with the same identifier is existing. If it is already existing, the new version
	 * of the item will be added to the list. If not, a new item will be added to the list with this 
	 * element as its first version.   
	 */
	private void collectItems(Element e){
		String targetName = "";
		RepItem repItem = null;
		if ("y".equals(e.getAttribute("isItem"))){
			targetName = e.getAttribute("originalElement");
			repItem = new RepItem(e,targetName);									/* Create repItem from given element and path */
			Item item = tav.getItemPrototype(targetName);
			item.getItemIdentifier().updateFieldValues(repItem.getVersion(0),temporalDoc);
			item.addVersionAll(repItem.getVersions(), repItem.getTemporalElement());
			Item oldItem = null;
			
			Enumeration items = itemTable.elements();
			boolean found = false;
			while (items.hasMoreElements()){
				oldItem = (Item)items.nextElement();
				if (oldItem.getItemIdentifier().equals(item.getItemIdentifier())){
					found = true;
					break;
				}
			}

			if (found){
				oldItem.addVersionAll(item.getVersions(),item.getTemporalElement());
			}else{
				itemTable.put(item.getItemIdentifier(),item);
			}
			
			if (1==0){
				if ((oldItem = (Item)itemTable.get(item.getItemIdentifier()))!=null){		/* If the item with the same item identifier already exists in the itemTable */
					oldItem.addVersionAll(item.getVersions(),item.getTemporalElement());	/* Add all the versions of this item to the old item */
				}else{																		/* If the item is not existing */
					itemTable.put(item.getItemIdentifier(),item);
				}
			}

			/* Call function collectItems() on all the versions of the current item (or repItem) */
			Iterator versionIterator = repItem.getVersionIterator();
			while (versionIterator.hasNext()){
				Element currVersion = (Element)versionIterator.next();
				NodeList nl = currVersion.getChildNodes();
				for (int i=0 ; i<nl.getLength() ; i++){
					if (nl.item(i).getNodeType() == Node.ELEMENT_NODE){
						collectItems((Element)nl.item(i));
					}
				}
			}
		}else{
			targetName = e.getLocalName();
			/* Call function collectItems() on every child of current node */
			NodeList nl = e.getChildNodes();
			for (int i=0 ; i<nl.getLength() ; i++){
				if (nl.item(i).getNodeType() == Node.ELEMENT_NODE){
					collectItems((Element)nl.item(i));
				}
			}
		}
	}
	
	/**
	 * @author sthomas
	 * Just an interface into one of the validates (representation type).
	 */
	public boolean validate(String temp_data_dir, String temporalDocument){
		
		// Find out which representation type we used.
		if (pav.getRepType().equals("edit")){
			return validateEdit(temporalDocument);
		} 
		else if (pav.getRepType().equals("versioned")){
			return validateVer(temp_data_dir, temporalDocument);
		}
		TauLogger.logger.info("Unknown representation type \"" + pav.getRepType() +"\"");
		System.exit(3); //TODO: something smarter.
		
		return false;
	}
	

	/* Rui commented this out
	public boolean validateVer(String strTemporalDoc){
			
		String strRepSchemaDoc = ""; 
		String strScratchBase   = "";
		try{
			// Create representational schema using Schema Mapper.
			DoSchemaMapping doSchemaMapping = new DoSchemaMapping();
			Document repSchemaDoc; 
			repSchemaDoc = doSchemaMapping.createRepresentationalSchema(temporalSchema, -1);
			
			//strScratchBase  = vp.getProperty("Scratch");
			//strRepSchemaDoc = strScratchBase + "/tempRepSchema.xsd";
			cp.writeDocument(repSchemaDoc, strRepSchemaDoc);
	    }catch (Exception e){
	    	e.printStackTrace();
	    }				
		
	    // Parse given temporal Document - strTemporalDoc
	    temporalDoc = cp.parseDocument(strTemporalDoc, null, strRepSchemaDoc, false); //TODO - make true
		return validateVer(temporalDoc);
	}
	*/
	
	public boolean validateVer(String temp_data_dir, String strTemporalDoc){
		
		String strRepSchemaDoc = ""; 
		String strScratchBase   = "";
		String tmp_dir = System.getProperty("java.io.tmpdir");
		try{
			// Create representational schema using Schema Mapper.
			DoSchemaMapping doSchemaMapping = new DoSchemaMapping();
			Document repSchemaDoc; 
			repSchemaDoc = doSchemaMapping.createRepresentationalSchema(temporalSchema, -1);
			
			//strScratchBase  = vp.getProperty("Scratch");
			//strRepSchemaDoc = strScratchBase + "/tempRepSchema.xsd";
			strRepSchemaDoc = tmp_dir + "/tempRepSchema.xsd";
			cp.writeDocument(repSchemaDoc, strRepSchemaDoc);
	    }catch (Exception e){
	    	e.printStackTrace();
	    }				
		
	    // Parse given temporal Document - strTemporalDoc
	    temporalDoc = cp.parseDocument(temp_data_dir + "/" + strTemporalDoc,
                                       null, strRepSchemaDoc, false); //TODO - make true
		TemporalConstraintValidator tcv =
            new TemporalConstraintValidator(temporalDoc, temporalSchema);
	    return tcv.PerformValidation(temp_data_dir, strTemporalDoc,
                                     temporal_schema_location_,
	    		                     conventional_schema_location_);
		//return validateVer(temporalDoc);
	}
	
	
	/**
	 * First of all, the function should create representational schema using Schema Mapper.
	 * Then the document is validated by using conventional validator against representational schema.
	 * If conventional validator validates the document, function collectItems() is called to collect 
	 * all the items in itemTable. Then for every item, it calls function validate which internally validates 
	 * all the constraints on the item and returns the boolean. 
	 * If all the items are validated, the document is valid, else document is not valid.
	 * (non-Javadoc)
	 * @see cs.arizona.tau.xml.IDoTemporalValidation#validate()
	 */
	public boolean validateVer(Document d){
	    long t1 = System.nanoTime();
		temporalDoc = d;
	    /* Before validating, convert the document from physical annotation to temporal annotation */
		Primitives primitives = new Primitives(ti,tav,defaultPav, repSchemaNameAlias);
		primitives.physicalToTemporalConversion(d);
	    
	    /* Get the top level element from the document */
	    Element temporalRoot = d.getDocumentElement();
		ITimePeriod documentExistencePeriod = new TimePeriod(temporalRoot.getAttribute("begin"),temporalRoot.getAttribute("end"));

		// Rui: this assumption previously made is wrong. That's why i starts from 2
		//Here again we are assuming that there would be only one element below <temporalRoot>, which is true if a_timeVarying is not used.
		Element originalRoot = null;
		NodeList nl = temporalRoot.getChildNodes();
		for(int i=2 ; i<nl.getLength() ; i++){
			if(Common.isElement(nl.item(i))){
				originalRoot = (Element)nl.item(i);
				break;
			}
		}
	    /* Call function collectItems() to collect all the items in itemTable */
		collectItems(originalRoot);
		
		/* Validate all the items one by one */
		boolean valid=true;
		Enumeration items = itemTable.elements();
		while (items.hasMoreElements()){
			Item item = (Item)items.nextElement();
			itemList.add(item);
			TauLogger.logger.info("Validating item: " + item.toString());
			if (!item.validate(documentExistencePeriod, tav, d)){
				valid = false;
			}
		}
	    long t2 = System.nanoTime();
		Common.printElaspedTime("ValidateItem total", t1, t2);
		return valid;
	}
	
	
	
	
	public boolean validate(Element temporalRoot){
		Element originalRoot = null;

		temporalDoc = cp.createDocument(vp.getProperty("RepSchemaURL"), repSchemaNameAlias + "temporalRoot", null);
        Element newtemporalRoot = temporalDoc.getDocumentElement();
		Element importedtemporalRoot = (Element)temporalDoc.importNode(temporalRoot, true);
		
		NodeList nl = importedtemporalRoot.getChildNodes();
		for (int i=0 ; i<nl.getLength() ; i++){
			newtemporalRoot.appendChild(nl.item(i));	
		}

		newtemporalRoot.setAttribute("begin",temporalRoot.getAttribute("begin"));
		newtemporalRoot.setAttribute("end", temporalRoot.getAttribute("end"));
		newtemporalRoot.setAttribute("xmlns:tv", vp.getProperty("TVSchemaURL"));

/*		
		cp.writeElement(temporalRoot, vp.getProperty("Scratch") + "/temp.xml");
		temporalDoc = cp.parseURI(vp.getProperty("Scratch") + "/temp.xml");
*/
		ITimePeriod documentExistencePeriod = new TimePeriod(newtemporalRoot.getAttribute("begin"),newtemporalRoot.getAttribute("end"));
		
		Primitives primitives = new Primitives(ti, tav, pav, repSchemaNameAlias);
		primitives.physicalToTemporalConversion(temporalDoc);
	    
		//Here again we are assuming that there would be only one element below <temporalRoot>, which is true if a_timeVarying is not used.
		nl = newtemporalRoot.getChildNodes();
		for(int i=0 ; i<nl.getLength() ; i++){
			if(nl.item(i).getNodeType() == Node.ELEMENT_NODE){
				originalRoot = (Element)nl.item(i);
				break;
			}
		}
	    /* Call function collectItems() to collect all the items in itemTable */
		collectItems(originalRoot);
		
		/* Validate all the items one by one */
		boolean valid=true;
		Enumeration items = itemTable.elements();
		while (items.hasMoreElements()){
			Item item = (Item)items.nextElement();
			if (!item.validate(documentExistencePeriod, tav, temporalDoc)){
				valid = false;
			}
		}
		return valid;	
	}
	
	public Hashtable getItemTable(){
		return itemTable;
	}
	
	
	/**
	 * @author sthomas
	 * @param strTemporalDoc
	 * @return 
	 * 
	 * (Nov 11, 2008) NOTE: Rick suggests another methodology than this. I'll leave this function in
	 * for historical purposes (appended a "2" to the name)
	 * 
	 * This function validates an edit-based temporal document.
	 * Note: this function currently differs significantly from its version-based
	 * counterpart. Only one temporal constraint is implemented: content-constant periods.
	 * The steps take are:
	 * 1. Call unsquash to create a bunch of files
	 * 2. Read in all the files
	 * 3. Check each file.
	 * 
	 * There might be a better way (such as doing some complicated analysis on the diff scripts).
	 */
	
	public boolean validateEdit2(String temporalDocument){
		String strRepSchemaDoc = ""; 
		String strScratchBase   = "";
		boolean valid = true;
		
		// this is my stuff!! Rui
		String tempDataDir = "/tmp";
		
	// Step 1: Unsquash all the documents
		IRepresentationFactory iRepFactory = new DecomposedRepresentationFactory();
		IDoUnSquashing doUnSquashing = iRepFactory.createUnSquashingObj(tempDataDir, "./config.xml", schemaVersion);

		String configDir 	= Common.getDirectory(temporalDocument); 
		String baseFileName = Common.getFileName(temporalDocument); 
		
		Hashtable snapshots = doUnSquashing.unSquash(tempDataDir, temporalDocument);
		//snapshots = doUnSquashing.getSnapshots();
		//TODO: broken because of datastructure
		Node thisE=null, lastE=null;
		String path;
		Document thisSlice;
		
		ArrayList<Document> docs = new ArrayList<Document>();
		
		
		// Now loop through snapshots and check each one
		Enumeration enumeration = snapshots.keys();
		int i = 0;
		while (enumeration.hasMoreElements()){
			path = (String)snapshots.get(enumeration.nextElement());
			thisSlice = cp.parseDocument(path, null, null, false);
			docs.add(thisSlice);
		}
		
		
		
		/* For each target, for each file, check existence. */
		Iterator tItr = tav.getTargetIterator();
		
		while (tItr.hasNext()){
			String tgt = (String)tItr.next();
			tgt = Common.getLastElementNameFromString(tgt); 
		
			for (int j=0; j < docs.size(); ++j){
				
				thisSlice = docs.get(j);
				thisE = Common.getFirstElementNamed(thisSlice, tgt);
				if (thisE == null){
					TauLogger.logger.fatal("Slice doesn't have element \"" + tgt + "\" : " + Common.getFileName(thisSlice.getDocumentURI()));
					return false;
				}
				
				if (i > 0){
					TauLogger.logger.info("Validating slice: " + Common.getFileName(thisSlice.getDocumentURI()));
					
					if (!thisE.isEqualNode(lastE)){
						TauLogger.logger.fatal("Content is specified as CONTENT_CONSTANT but is not CONSTANT.");
						return false;
					}
				}
				i++;
				lastE = thisE;
				
			}
		}
		
		return valid;
	}
	
	
	/**
	 * @author sthomas
	 * @param strTemporalDoc
	 * @return 
	 * 
	 * 
	 * This function validates an edit-based temporal document.
	 * The methodology is as follows:
	 * 1. Unsquash the temporal document, resulting in a list of Documents (in memory)
	 * 2. Build a item-based representation with these Documents (timestamp at root)
	 * 3. Validate item-based-representation the regular way.
	 * 
	 * This promotes software re-use and simplicity.
	 */
	
	public boolean validateEdit(String temporalDocument){
		boolean valid = true;
		
		// this is my stuff!! Rui
		String tempDataDir = "/tmp"; 
		
	// Step 1: Unsquash all the documents
		IRepresentationFactory iRepFactory = new DecomposedRepresentationFactory();
		//TODO: Change hard coded name! How?
		IDoUnSquashing doUnSquashing = iRepFactory.createUnSquashingObj(tempDataDir, "./config.xml", schemaVersion);

		Hashtable dummy = doUnSquashing.unSquash(tempDataDir, temporalDocument);
		ArrayList snapshots = doUnSquashing.getSnapshots();
		
	// Step 2: Call squash to build document. TODO: adhere to interfaces better.
		DoSquashing doSquashing = new DoSquashing();
		Document d = doSquashing.squashDefault(snapshots);
		
	// Step 3: Validate using item-based
		return validateVer(d);
		
	}
	
	
	
	
}
