/*
 * Created on Sep 13, 2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */

package cs.arizona.tau.xml;


import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;

import javax.xml.transform.OutputKeys;
import javax.xml.transform.Transformer;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.w3c.dom.*;
import org.w3c.dom.ls.*;
import org.w3c.dom.xpath.*;
import org.apache.xpath.domapi.XPathEvaluatorImpl; 

import cs.arizona.tau.docs.TemporalSchema;
import cs.arizona.util.*;



/**
 * @author shailesh
 * @author sthomas
 * TODO : 
 * 1) In function performValidations, some more validations are needed as per mentioned in the comments.
 * 3) Remove hard-coding from function modifySchemaElement for variable schemaElement.
 * 4) In function modifyReferences, hard-coding in statement - (XPathResult)evaluator.evaluate("//xs:element
 * 5) Exception handling
 *
 * SchemaMapper class creates Representational Schema Document using given Snapshot document,Temporal and Physical Annotations and Temporal Bundle. 
 */
public class DoSchemaMapping implements IDoSchemaMapping{
	private int VALIDATE_TEMPORAL_ANNOTATION =1 , VALIDATE_PHYSICAL_ANNOTATION =2 , CREATE_REP_SCHEMA =3;
	
	private String temporalSchema;
	private String conventionalSchema;
	private String annotation;
	
	private Document conventionalSchemaDoc;
	private Document annotationDoc;
	
	private String   temporalAnnotation;			//path of temporal annotation document.
	private String   physicalAnnotation;			//path of physical annotation document.
	private String   snapshotSchema;				//path of snapshot schema.
	private Document snapshotSchemaDocument;		//Document element for snapshot schema. 
	private Document temporalAnnotationDocument;	//Document element for temporal annotation.
	private Document physicalAnnotationDocument;	//Document element for physical annotation.

	TargetIdentifier ti;
	
	LogicalAnnotationValidator lav;
	PhysicalAnnotationValidator pav;

	ValidatorProperties vp;
	ConventionalParser  cp;
	
	/**
	 * 
	 */
	public DoSchemaMapping() {
		super();
		init();
	}
	

	/**
	 * Initializes lsParser and lsSerializer objects to be used later for parsing.
	 */
	private void init(){
		vp = ValidatorProperties.getInstance();
		cp = ConventionalParser.getInstance();
		
		TauLogger.init();
	}

	
	
	/**
	 * Validates given Temporal Annotation using Snapshot Schema and TXSchemas standard. 
	 * @param temporalBundle
	 * @return
	 */
	public boolean validateTemporalAnnotation(String temporalBundle) {
		parseInput(temporalBundle,VALIDATE_TEMPORAL_ANNOTATION);
		return true;
	}
	
	
	/**
	 * Validates given Physical Annotation using Snapshot Schema and PXSchemas standard. 
	 * @param temporalBundle
	 * @return
	 */
	public boolean validatePhysicalAnnotation(String temporalBundle) {
		parseInput(temporalBundle,VALIDATE_PHYSICAL_ANNOTATION);
		return true;
	}
	
	
	
	
	/**
	 * Creates a Representational schema document from given set of Snapshot document,Temporal and Physical Annotations and Temporal Bundle.
	 * The Representational Schema Document will be written at location specified by representationalSchema.  
	 * @param temporalSchema			- Path of temporal bundle document
	 * @param representationalSchema	- Path of representational schema
	 */
	public Document createRepresentationalSchema(String temporalSchema, int schemaVersion) {
		//parse the temporal bundle to extract the relevant information about paths of other documents.
		this.temporalSchema = temporalSchema;
		parseInput(temporalSchema,CREATE_REP_SCHEMA);
		
		performValidations();
		
        //Modify Scheme element to have xmlns:tv attributes so that tv schema could be added.
		//modifySchemaElement(schemaVersion);

		//Get all target elements from physical annotation. 	
		Hashtable targetElements = pav.getTargetElements();

		//Add timeVaryingRoot Element to snapshotSchema Document above the Top Level Element.
		addTimeVaryingRoot(targetElements);

		//For every timestampable element in stampElements (physical annotation), convert that element to TimeVarying.
		
		Enumeration targets = targetElements.keys();
		while (targets.hasMoreElements()){
			String targetName = (String)targets.nextElement();
			convertElement(targetName,(Element)targetElements.get(targetName));
		}
		//Store the final modified DOM to a file.
		return snapshotSchemaDocument;
	}
	

	public void writeDocument(Document doc, String fileName){
		cp.writeDocument(doc, fileName);

	}
	
		
	
	public Document createRepresentationalSchema(String snapshotSchema, String temporalAnnotation, String physicalAnnotation, int schemaVersion){
		

		
		
		
		snapshotSchemaDocument=cp.parseDocument(snapshotSchema, null, vp.getProperty("XMLSchema"));
        
		//System.out.println("DoSchemaMapping::createRepresentationalSchema: snapshotSchemaDocument = " + snapshotSchemaDocument.toString());
		// DEBUG writeDocument(snapshotSchemaDocument, "./repSchema1.xsd" );
		
		//Initialize SchemaPathEvaluator
        ti = new TargetIdentifier(snapshotSchemaDocument);

		temporalAnnotationDocument=cp.parseDocument(temporalAnnotation, null, vp.getProperty("TXSchema"));
		physicalAnnotationDocument=cp.parseDocument(physicalAnnotation, null, vp.getProperty("PXSchema"));

		//Validate Temporal and Physical Annotations	
		
		//sthomas - possibly add calls to xmllint here?
		lav = new LogicalAnnotationValidator(temporalAnnotationDocument,snapshotSchemaDocument,ti,false);
		lav.validateLogicalAnnotation();
		pav = new PhysicalAnnotationValidator(physicalAnnotationDocument,snapshotSchemaDocument,ti,false);
		pav.validatePhysicalAnnotation();

		//sthomas- We want to check the outcome of this, right?
		boolean isVald = performValidations();
		if (!isVald){
			TauLogger.logger.info("DoSchemaMapping: Temporal or Physical Annotation is incorrect. Exiting...");
			System.exit(1);
		}
		else{
			TauLogger.logger.info("DoSchemaMapping: Temporal and Physical Annotations are correct.");
		}
		
        //Modify Scheme element to have xmlns:tv attributes so that tv schema could be added.
		modifySchemaElement(schemaVersion);
		// DEBUG writeDocument(snapshotSchemaDocument, "./repSchema2.xsd" );

		//Get all target elements from physical annotation. 	
		Hashtable targetElements = pav.getTargetElements();

		//Add timeVaryingRoot Element to snapshotSchema Document above the Top Level Element.
		addTimeVaryingRoot(targetElements);
		// DEBUG writeDocument(snapshotSchemaDocument, "./repSchema3.xsd" );

		//For every timestampable element in stampElements (physical annotation), convert that element to TimeVarying.
		
		Enumeration targets = targetElements.keys();
		while (targets.hasMoreElements()){
			String targetName = (String)targets.nextElement();
			convertElement(targetName,(Element)targetElements.get(targetName));
		}
		//Store the final modified DOM to a file.
		//System.out.println("DoSchemaMapping::createRepresentationalSchema: snapshotSchemaDocument = " + snapshotSchemaDocument.toString());
		
		return snapshotSchemaDocument;
	}
	
	
	
	
	
	
	/**
	 * The function stores the name given to W3C specification schema "http://www.w3.org/2001/XMLSchema" in xmlSchemaName.
	 * It also addes a new Namespace with name tvSchemaName to root element.
	 */
	private void modifySchemaElement(int schemaVersion){
		Element schemaElement = snapshotSchemaDocument.getDocumentElement();
		schemaElement.setAttribute("xmlns:xsi",vp.getProperty("XMLSchemaInstance"));
		schemaElement.setAttribute("xmlns:tv",vp.getProperty("TVSchemaURL"));
		
		
		//sthomas - need to explicitly set both of these attributes to qualified because
		// our namespace scheme depends on them. 
		schemaElement.setAttribute("attributeFormDefault", "qualified");
		schemaElement.setAttribute("elementFormDefault",   "qualified");

		Element tvImportElement = snapshotSchemaDocument.createElement(vp.getProperty("XMLSchemaNameAlias") + "import");
		tvImportElement.setAttribute("namespace", vp.getProperty("TVSchemaURL"));
		tvImportElement.setAttribute("schemaLocation", vp.getProperty("TVSchema"));

		NodeList nl = schemaElement.getChildNodes();
		for (int i=0 ; i<nl.getLength() ; i++){
			if (nl.item(i).getNodeType() == Element.ELEMENT_NODE){
				schemaElement.insertBefore(tvImportElement, nl.item(i));
				break;
			}
		}
		
		//Determine which namespace to use; it will be of the form RepSchemaX, where X is either the empty
		//string or the schema version number, depending on whether the schema is versioned or not.
		String namespace = "";
		if (schemaVersion >=0 ){
			namespace = vp.getProperty("RepSchemaURL") + schemaVersion;
		}else{
			namespace = vp.getProperty("RepSchemaURL");
		}
		
		// Oct 2008 - Causing problems. Comment out for now.
		//schemaElement.setAttribute("xmlns", namespace);
		
		//Oct 2008 - this is causing problems. Comment out for now.
		//schemaElement.setAttribute("targetNamespace", namespace );
	}

	
	
	private boolean parseInput(String temporalSchema, int currentTask){
		Document temporalSchemaDoc;
		NodeList annotationNodes;
		NodeList     conventionalSchemaNode;
		NodeList	 conventionalSchemas;
		NamedNodeMap attributeList;

		TemporalSchema ts = new TemporalSchema(vp, cp, temporalSchema);
		temporalSchemaDoc = ts.getTemporalSchemaDoc();
		annotationDoc = ts.getAnnotationDoc();
		conventionalSchemaDoc = ts.getConventionalSchemaDoc();
		//conventionalSchemaDoc = cp.parseDocument(conventionalSchema, null, vp.getProperty("XMLSchema"), false);
		snapshotSchemaDocument = conventionalSchemaDoc;
		ti = new TargetIdentifier(conventionalSchemaDoc);
        // Create Document objects from the temp and phys annotation file names
		//annotationDoc = cp.parseDocument(annotation, null, vp.getProperty("ASchema"));
        if (currentTask == CREATE_REP_SCHEMA){
		  lav = new LogicalAnnotationValidator(annotationDoc,conventionalSchemaDoc,ti,true);
		  pav = new PhysicalAnnotationValidator(annotationDoc,conventionalSchemaDoc,ti,true);
        } else {
			        	/*
			        	 * Rui temporarily commented these out
						if (currentTask==VALIDATE_TEMPORAL_ANNOTATION){
							temporalAnnotation = temporalBundleDir + (attributeList.getNamedItem("temporalAnnotation")).getNodeValue();
							temporalAnnotationDocument=cp.parseDocument(temporalAnnotation, null, vp.getProperty("TXSchema"));
							//Validate Temporal Annotation		
							tav = new LogicalAnnotationValidator(temporalAnnotationDocument,snapshotSchemaDocument,ti,false);
							tav.validateLogicalAnnotation();
						}else{
							if (currentTask==VALIDATE_PHYSICAL_ANNOTATION){
								physicalAnnotation = temporalBundleDir + (attributeList.getNamedItem("physicalAnnotation")).getNodeValue();
								physicalAnnotationDocument=cp.parseDocument(physicalAnnotation, null, vp.getProperty("PXSchema"));
								//Validate Physical Annotation
								pav = new PhysicalAnnotationValidator(physicalAnnotationDocument,snapshotSchemaDocument,ti,false);
								pav.validatePhysicalAnnotation();
							}
						}
						*/
					}
		return true;
	}

	
	
	
	
	/**
	 * @param temporalSchema
	 * @param currentTask
	 * @return
	 */
	/*
	private boolean parseInput(String temporalSchema, int currentTask){
		Document temporalSchemaDoc;
		NodeList annotationNodes;
		NodeList     conventionalSchemaNode;
		NodeList	 conventionalSchemas;
		NamedNodeMap attributeList;

		String temporalSchemaDir = temporalSchema.substring(0,temporalSchema.lastIndexOf("/")) + "/";
		try{
			// Parse temporalBundle document to find out paths for other documents
			temporalSchemaDoc = cp.parseDocument(temporalSchema, null, vp.getProperty("TSSchema"));			
			conventionalSchemaNode = temporalSchemaDoc.getElementsByTagName("conventionalSchema");
			if (conventionalSchemaNode.getLength() > 0){
				conventionalSchemas = conventionalSchemaNode.item(0).getChildNodes();
				if (conventionalSchemas.getLength() > 0) {
					for(int i= 0; i < conventionalSchemas.getLength(); i++) {
						
						if( Common.isElement(conventionalSchemas.item(i))
							&& ((Element) conventionalSchemas.item(i)).getTagName().equals("include")) {
							//Get name of conventionalSchema documents.
							conventionalSchema = temporalSchemaDir + 
								conventionalSchemas.item(i).getAttributes().getNamedItem("schemaLocation").getNodeValue();
						}
					}
				}else{
					System.out.println("conventionalSchemas length = 0");
				}
			}else{
				TauLogger.logger.info("No \"conventionalSchema\" elements in temporal schema!");
				//TODO: Err in some way
			}
			
			annotationNodes = temporalSchemaDoc.getElementsByTagNameNS("*", "annotationSet");
			
			if(annotationNodes.getLength() > 0) {
				annotationNodes = annotationNodes.item(0).getChildNodes();
				if(annotationNodes.getLength() > 0) {
					for(int i = 0; i < annotationNodes.getLength(); i++) {
						if( Common.isElement(annotationNodes.item(i))
								&& ((Element) annotationNodes.item(i)).getTagName().equals("include") ) {
							annotation = temporalSchemaDir + annotationNodes.item(i).getAttributes().getNamedItem("location").getNodeValue();
						}
					}
					
					conventionalSchemaDoc = cp.parseDocument(conventionalSchema, null, vp.getProperty("XMLSchema"), false);
					snapshotSchemaDocument = conventionalSchemaDoc;
			        //Initialize SchemaPathEvaluator
			        ti = new TargetIdentifier(conventionalSchemaDoc);
			        // Create Document objects from the temp and phys annotation file names
					annotationDoc = cp.parseDocument(annotation, null, vp.getProperty("ASchema"));
					
					//snapshotSchema = temporalBundleDir + (attributeList.getNamedItem("snapshotSchema")).getNodeValue();
					//snapshotSchemaDocument=cp.parseDocument(snapshotSchema, null, vp.getProperty("XMLSchema"));
	
			        if (currentTask == CREATE_REP_SCHEMA){
					  lav = new LogicalAnnotationValidator(annotationDoc,conventionalSchemaDoc,ti,true);
					  pav = new PhysicalAnnotationValidator(annotationDoc,conventionalSchemaDoc,ti,true);
			        } else {
			        	/*
			        	 * Rui temporarily commented these out
						if (currentTask==VALIDATE_TEMPORAL_ANNOTATION){
							temporalAnnotation = temporalBundleDir + (attributeList.getNamedItem("temporalAnnotation")).getNodeValue();
							temporalAnnotationDocument=cp.parseDocument(temporalAnnotation, null, vp.getProperty("TXSchema"));
							//Validate Temporal Annotation		
							tav = new LogicalAnnotationValidator(temporalAnnotationDocument,snapshotSchemaDocument,ti,false);
							tav.validateLogicalAnnotation();
						}else{
							if (currentTask==VALIDATE_PHYSICAL_ANNOTATION){
								physicalAnnotation = temporalBundleDir + (attributeList.getNamedItem("physicalAnnotation")).getNodeValue();
								physicalAnnotationDocument=cp.parseDocument(physicalAnnotation, null, vp.getProperty("PXSchema"));
								//Validate Physical Annotation
								pav = new PhysicalAnnotationValidator(physicalAnnotationDocument,snapshotSchemaDocument,ti,false);
								pav.validatePhysicalAnnotation();
							}
						}
						*/
	/*
					}
				} else {
					// TODO: Err in some way
				}
			} else {
				TauLogger.logger.info("No \"annotationSet\" element in temporal schema");
			}
			
		}catch (DOMException e){
			e.printStackTrace(); 	
		}catch (LSException e){
			e.printStackTrace(); 
		}catch(Exception e){
			e.printStackTrace();
		}
		return true;
	}
*/
	
	/**
	 * @param temporalBundle
	 * @param currentTask
	 * @return
	 */
	/*
	private boolean parseInput(String temporalBundle, int currentTask){
		Document bundleDoc;
		NodeList schemaAnnotationNodes;
		NamedNodeMap attributeList;

		try{
			//Parse temporalBundle document to find out paths for other documents
			bundleDoc = cp.parseDocument(temporalBundle, null, vp.getProperty("TBSchema")); 
			schemaAnnotationNodes=bundleDoc.getElementsByTagName("schemaAnnotation");
			String temporalBundleDir = temporalBundle.substring(0,temporalBundle.lastIndexOf("/")) + "/";
			if (schemaAnnotationNodes.getLength() > 0){
				attributeList = schemaAnnotationNodes.item(0).getAttributes();
				if (attributeList.getLength() > 0){
					//Get names of all the 3 documents required for building Representational schema and parse them.
					snapshotSchema = temporalBundleDir + (attributeList.getNamedItem("snapshotSchema")).getNodeValue();
					snapshotSchemaDocument=cp.parseDocument(snapshotSchema, null, vp.getProperty("XMLSchema"));
	
			        //Initialize SchemaPathEvaluator
			        ti = new TargetIdentifier(snapshotSchemaDocument);
	
			        if (currentTask==CREATE_REP_SCHEMA){
					temporalAnnotation = temporalBundleDir + (attributeList.getNamedItem("temporalAnnotation")).getNodeValue();
					temporalAnnotationDocument=cp.parseDocument(temporalAnnotation, null, vp.getProperty("TXSchema"));
					physicalAnnotation = temporalBundleDir + (attributeList.getNamedItem("physicalAnnotation")).getNodeValue();
					physicalAnnotationDocument= cp.parseDocument(physicalAnnotation, null, vp.getProperty("PXSchema"));
	
					//Validate Temporal and Physical Annotations	
					tav = new LogicalAnnotationValidator(temporalAnnotationDocument,snapshotSchemaDocument,ti,false);
					tav.validateLogicalAnnotation();
					pav = new PhysicalAnnotationValidator(physicalAnnotationDocument,snapshotSchemaDocument,ti,false);
					pav.validatePhysicalAnnotation();
					}else{
						if (currentTask==VALIDATE_TEMPORAL_ANNOTATION){
							temporalAnnotation = temporalBundleDir + (attributeList.getNamedItem("temporalAnnotation")).getNodeValue();
							temporalAnnotationDocument=cp.parseDocument(temporalAnnotation, null, vp.getProperty("TXSchema"));
							//Validate Temporal Annotation		
							tav = new LogicalAnnotationValidator(temporalAnnotationDocument,snapshotSchemaDocument,ti,false);
							tav.validateLogicalAnnotation();
						}else{
							if (currentTask==VALIDATE_PHYSICAL_ANNOTATION){
								physicalAnnotation = temporalBundleDir + (attributeList.getNamedItem("physicalAnnotation")).getNodeValue();
								physicalAnnotationDocument=cp.parseDocument(physicalAnnotation, null, vp.getProperty("PXSchema"));
								//Validate Physical Annotation
								pav = new PhysicalAnnotationValidator(physicalAnnotationDocument,snapshotSchemaDocument,ti,false);
								pav.validatePhysicalAnnotation();
							}
						}
					}
				}
			}
		}catch (DOMException e){
			e.printStackTrace(); 	
		}catch (LSException e){
			e.printStackTrace(); 
		}catch(Exception e){
			e.printStackTrace();
		}
		return true;
	}
*/
	
	
	
	
	
	/**
	 * Given name of element, the function adds corresponding TimeVarying, RepItem and Version elemet
	 * It also modifies the existing node to replace the references to timevarying elements.    
	 * @param elementName
	 * @return
	 */
	private void convertElement(String targetElementName,Element targetElement){
		Element root = snapshotSchemaDocument.getDocumentElement();
		Element parent = (Element)targetElement.getParentNode();
		targetElement.removeAttribute("abstract"); // Not sure how this gets in the first place (See SchemaPathEvaluator).
		modifyReferences(targetElementName,targetElement);
		
		/* If the Decomposed representation is to be used, use following two statements  
		parent.appendChild(createTimeVaryingElement(targetElementName));
		root.appendChild(createRepItemElement(targetElementName,targetElement));
		*/
		
		/* If the Decomposed representation is to be used, use following two statements */
		parent.appendChild(createRepItemElement(targetElementName,targetElement));
	}
	
	
	
	
	
	
	private void addTimeVaryingRoot(Hashtable targetElements){
		Element root = snapshotSchemaDocument.getDocumentElement();
		Element timeVaryingRootElement = snapshotSchemaDocument.createElement(vp.getProperty("XMLSchemaNameAlias") + "element");
		timeVaryingRootElement.setAttribute("name","temporalRoot");

		Element complexTypeElement = snapshotSchemaDocument.createElement(vp.getProperty("XMLSchemaNameAlias") + "complexType");
		Element sequenceElement = snapshotSchemaDocument.createElement(vp.getProperty("XMLSchemaNameAlias") + "sequence");

		Element beginDateAttr = snapshotSchemaDocument.createElement(vp.getProperty("XMLSchemaNameAlias") + "attribute");
		beginDateAttr.setAttribute("name","begin");
		beginDateAttr.setAttribute("type",vp.getProperty("XMLSchemaNameAlias") + "date");

		Element endDateAttr = snapshotSchemaDocument.createElement(vp.getProperty("XMLSchemaNameAlias") + "attribute");
		endDateAttr.setAttribute("name","end");
		endDateAttr.setAttribute("type",vp.getProperty("XMLSchemaNameAlias") + "date");
		
		//Get the top level element from XMLSchema using SchemaPathEvaluator
		String topLevelElement = ti.getTopLevelElement().getAttribute("name");

		Element refElement = snapshotSchemaDocument.createElement(vp.getProperty("XMLSchemaNameAlias") + "element");
		
		//System.out.println(targetElements.toString());
		//System.out.println(topLevelElement.toString());
		if (targetElements.containsKey(topLevelElement)){
			/* If Decomposed representation is to be used use following statement
			refElement.setAttribute("ref",topLevelElement + "_TimeVarying");
			*/
			/* If Non-Decomposed representation is to be used use following statement */
			refElement.setAttribute("ref",topLevelElement + TXSchemaConstants.ITEM_SUFFIX);
		}else{
			refElement.setAttribute("ref",topLevelElement);
		}

		// Rui: added the following to add the temporalSchemaSet element
		Element tempSchemaSetEle = snapshotSchemaDocument.createElement(vp.getProperty("XMLSchemaNameAlias") + "element");
		tempSchemaSetEle.setAttribute("name", "temporalSchemaSet");
		Element ts_complexTypeElement = snapshotSchemaDocument.createElement(vp.getProperty("XMLSchemaNameAlias") + "complexType");
		Element ts_sequenceElement = snapshotSchemaDocument.createElement(vp.getProperty("XMLSchemaNameAlias") + "sequence");
		Element tempSchemaEle = snapshotSchemaDocument.createElement(vp.getProperty("XMLSchemaNameAlias") + "element");
		tempSchemaEle.setAttribute("name", "temporalSchemaSet");
		tempSchemaEle.setAttribute("type", vp.getProperty("XMLSchemaNameAlias") + "string");
		Element location_attribute = snapshotSchemaDocument.createElement(vp.getProperty("XMLSchemaNameAlias") + "attribute");
		location_attribute.setAttribute("name", "schemaLocation");
		tempSchemaEle.appendChild(location_attribute);
		
		ts_complexTypeElement.appendChild(ts_sequenceElement);
		tempSchemaSetEle.appendChild(tempSchemaEle);
		tempSchemaSetEle.appendChild(ts_sequenceElement);
		timeVaryingRootElement.appendChild(tempSchemaSetEle);
		
		timeVaryingRootElement.appendChild(complexTypeElement);
		sequenceElement.appendChild(refElement);
		complexTypeElement.appendChild(sequenceElement);
		complexTypeElement.appendChild(beginDateAttr);
		complexTypeElement.appendChild(endDateAttr);
		root.appendChild(timeVaryingRootElement);
	}
	
	
	
	

	private Element createTimeVaryingElement(String name){
		Element timeVaryingElement = snapshotSchemaDocument.createElement(vp.getProperty("XMLSchemaNameAlias") + "element");
		Element complexTypeElement = snapshotSchemaDocument.createElement(vp.getProperty("XMLSchemaNameAlias") + "complexType");
		Element attributeElement = snapshotSchemaDocument.createElement(vp.getProperty("XMLSchemaNameAlias") + "attribute");

		timeVaryingElement.appendChild(complexTypeElement);
		complexTypeElement.appendChild(attributeElement);
		
		timeVaryingElement.setAttribute("name",name+"_TimeVarying");
		
		attributeElement.setAttribute("name","itemRef");
		attributeElement.setAttribute("type","IDREF");

		return timeVaryingElement;	
	}

	
	
	
	
	private Element createRepItemElement(String name, Element targetElement){
		Element itemElement = snapshotSchemaDocument.createElement(vp.getProperty("XMLSchemaNameAlias") + "element");
		Element complexTypeElement = snapshotSchemaDocument.createElement(vp.getProperty("XMLSchemaNameAlias") + "complexType");
		Element sequenceElement = snapshotSchemaDocument.createElement(vp.getProperty("XMLSchemaNameAlias") + "sequence");
		Element versionElement = createVersionElement(name,targetElement);
		Element attributeElement = snapshotSchemaDocument.createElement(vp.getProperty("XMLSchemaNameAlias") + "attribute");
		
		Element isItemAttrElement = snapshotSchemaDocument.createElement(vp.getProperty("XMLSchemaNameAlias") + "attribute");
		isItemAttrElement.setAttribute("name","isItem");
		isItemAttrElement.setAttribute("type",vp.getProperty("XMLSchemaNameAlias") + "string");
		
		Element originalItemAttrElement = snapshotSchemaDocument.createElement(vp.getProperty("XMLSchemaNameAlias") + "attribute");
		originalItemAttrElement.setAttribute("name","originalElement");
		originalItemAttrElement.setAttribute("type",vp.getProperty("XMLSchemaNameAlias") + "string");

		itemElement.appendChild( complexTypeElement);
		complexTypeElement.appendChild(sequenceElement);
		complexTypeElement.appendChild(isItemAttrElement);
		complexTypeElement.appendChild(originalItemAttrElement);
		/* For non-decomposed representation itemID is not required. 
		complexTypeElement.appendChild(attributeElement); */
		sequenceElement.appendChild(versionElement);
		
		itemElement.setAttribute("name",name + TXSchemaConstants.ITEM_SUFFIX);
		
		versionElement.setAttribute("minOccurs","1");
		versionElement.setAttribute("maxOccurs","unbounded");
		
		attributeElement.setAttribute("name","itemID");
		attributeElement.setAttribute("type","ID");
		return itemElement;
	}

	
	
	
	
	/**
	 * Here we may need to pass second parameter which will hold some representation for timestamp type.
	 * Thinking that, the timestamp type class can keep some hash table, which stores the string to be represented
	 * in XML against the type of timestamp. 
	 * @param name
	 * @return
	 */
	private Element createVersionElement(String name, Element targetElement){
		Element versionElement = snapshotSchemaDocument.createElement(vp.getProperty("XMLSchemaNameAlias") + "element");
		Element complexTypeElement = snapshotSchemaDocument.createElement(vp.getProperty("XMLSchemaNameAlias") + "complexType");
		Element sequenceElement = snapshotSchemaDocument.createElement(vp.getProperty("XMLSchemaNameAlias") + "sequence");
		Element tvElement = snapshotSchemaDocument.createElement(vp.getProperty("XMLSchemaNameAlias") + "element");

		versionElement.appendChild( complexTypeElement);
		complexTypeElement.appendChild(sequenceElement);

		sequenceElement.appendChild( tvElement);
		sequenceElement.appendChild( targetElement);
		
		versionElement.setAttribute("name" , name + TXSchemaConstants.VERSION_SUFFIX);
		
		/* Need to add code so that depending upon the time dimension and representation the name of the element would vary */
		/* Currently, its hard-coded to have only timeStamp_TransExtent */

		tvElement.setAttribute("ref", vp.getProperty("TVSchemaNameAlias") + "timestamp_TransExtent");

		return versionElement;
	}
	
	private void modifyReferences(String targetElementName,Element targetElement){
		//If element is defined at top level
		ArrayList refElements = new ArrayList();
		if (targetElement.getParentNode().getLocalName() == "schema"){
			String elementName = targetElement.getAttribute("name");
			//Initialize XPathEvaluator
			XPathEvaluator evaluator = new XPathEvaluatorImpl(snapshotSchemaDocument);
			XPathNSResolver resolver = evaluator.createNSResolver(snapshotSchemaDocument);
			//Using XPath, get the element having name = nameElement
			XPathResult result = (XPathResult)evaluator.evaluate("//" + vp.getProperty("XMLSchemaNameAlias") + "element[@ref='" + elementName + "']",snapshotSchemaDocument,resolver,XPathResult.ORDERED_NODE_ITERATOR_TYPE,null);
			Element currentElement;
			while ((currentElement = (Element)result.iterateNext())!= null){
				System.out.println(currentElement.getAttribute("ref"));
				refElements.add(currentElement);
			}
			for (int i=0 ; i< refElements.size() ; i++ ){
				/* For Decomposed representation use follownig like
				((Element)refElements.get(i)).setAttribute("ref",targetElementName+"_TimeVarying");
				*/

				/* For Non-decomposed representation use follownig like */
				((Element)refElements.get(i)).setAttribute("ref",targetElementName + TXSchemaConstants.ITEM_SUFFIX);

			}
		}
	}
	
	
	
	
	
	/* The function performs the validations required on both temporal and physical annotations */
	private boolean performValidations(){
		
		/* Check whether the every target in temporal annotation has some target in physical annotation above it. */
		Iterator tItr = lav.getTargetIterator();
		
		while (tItr.hasNext()){
			String str = (String)tItr.next();
			Iterator pItr = pav.getTargetIterator();
			boolean found = false;
			while ((!found) && (pItr.hasNext())){
				if (str.startsWith((String)pItr.next())){
					found = true;
				}
			}
			if (!found){
				TauLogger.logger.info("Cannot find \"" + str + "\"");	
				
				return false;
			}
		}
		
		/* Another validation is to check whether there is any inconsistency with respect to content and existence varying nature of items */ 
		/* e.g. Suppose that a schema designer stipulates that an element is content-constant, but that it's child is existence-varying or 
		 * some other problematic combination. */
		return true;
	}
}