/**
 * 
 */
package cs.arizona.tau.xml;


import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Hashtable;
import java.util.Date;
import java.util.ArrayList;

import org.w3c.dom.*;
import org.w3c.dom.ls.*;

import cs.arizona.util.*;

import cs.arizona.tau.time.ITimePeriod;
import cs.arizona.tau.time.TimePeriod;

/**
 * @author Shailesh Joshi
 *
 */

/*
 * TODO
 * 1) In function unSquash, add functionality to create representational schema using given bundle and parse the document using rep schema.
 * 2) Implementation of function getTemporalBundleSliceInfo()
 * 3) All the documents are parsed only to check the well-formedness. They should be modified to check their validity as per their underlying 
 * 	  schemas using function parseDocument.
 */
public class DoSVUnSquashing implements IDoUnSquashing{

	/**
	 * 
	 */

	private ConventionalParser cp;
	private ValidatorProperties vp;
	private NodeList snapshotElementList; 
	
	public DoSVUnSquashing() {
		super();
		init();
		// TODO Auto-generated constructor stub
	}
	
	public ArrayList getSnapshots(){
		//TODO
		return null;
	}

	/**
	 * Initializes lsParser and lsSerializer objects to be used later for parsing.
	 */
	private void init(){
		cp = ConventionalParser.getInstance();
		vp = ValidatorProperties.getInstance();
	}
	
	/*
	 * Given a path of temporal document, the function returns the hashtable containing time period and corresponding snapshot document.
	 * The function first extracts temporal bundle from given temporal document. 
	 * 
	 */
	public Hashtable unSquash(String tempDataDir, String strTemporalDoc){
		
		String snapshotSchema=null;
		String temporalAnnotation=null;
		String physicalAnnotation=null;

		Hashtable snapshots = new Hashtable();
		
		try{
			/* Parse given temporal document to find out the temporal bundle */
			Document temporalDoc = cp.parseURI(strTemporalDoc);
			
			/* Extract location of temporal Bundle from given document */
			String strTemporalBundle = temporalDoc.getDocumentElement().getAttribute("bundle");
			if ((null == strTemporalBundle) || ("".equals(strTemporalBundle.trim()))){
				System.out.println("The given document does not have bundle");
				throw new RuntimeException("The given document does not have bundle");
			}
			String temporalBundleDir = strTemporalBundle.substring(0,strTemporalBundle.lastIndexOf("/")) + "/";	
			String strRepSchemaDoc = temporalBundleDir + "rep.xsd"; 
			try{
				/* Create representational schema using Schema Mapper. */
				DoSVSchemaMapping doSVSchemaMapping = new DoSVSchemaMapping();
				Document repSchemaDoc; 
				repSchemaDoc = doSVSchemaMapping.createRepresentationalSchema(strTemporalBundle);
				cp.writeDocument(repSchemaDoc, strRepSchemaDoc);
		    }catch (Exception e){
		    	e.printStackTrace();
		    }				

		    /* Parse given temporal Document against the rep schema. */
		    temporalDoc = cp.parseDocument(strTemporalDoc, null,strRepSchemaDoc);

			/* Parse temporal bundle using TBSchema. */
			Document temporalBundleDoc = cp.parseDocument(strTemporalBundle, null, vp.getProperty("TBSchema"));
			NodeList schemaVersions = temporalBundleDoc.getElementsByTagName("schemaAnnotation");
			
			for (int i=0 ; i<schemaVersions.getLength() ; i++){
				snapshotSchema = temporalBundleDir + ((Element)schemaVersions.item(i)).getAttribute("snapshotSchema");
				temporalAnnotation = temporalBundleDir + ((Element)schemaVersions.item(i)).getAttribute("temporalAnnotation");
				physicalAnnotation = temporalBundleDir + ((Element)schemaVersions.item(i)).getAttribute("physicalAnnotation");
				
				Element schemaVersionElement = (Element)temporalDoc.getElementsByTagName("schemaVersion" + i).item(0);
				
				Element temporalRoot = (Element)schemaVersionElement.getElementsByTagName(vp.getProperty("RepSchemaNameAlias") + i + ":temporalRoot").item(0);

				DoUnSquashing doUnSquashing = new DoUnSquashing(snapshotSchema, temporalAnnotation, physicalAnnotation,i);
				snapshots.putAll(doUnSquashing.unSquash(temporalRoot));	
			}
			return snapshots;
	
		}catch(DOMException de){
			System.out.println("Error occurred while parsing given Temporal Document.");
			return null;
		}catch(LSException le){
			System.out.println("Unable to load Temporal Bundle Document.");
			le.printStackTrace();
			return null;
		}catch(Exception e){
			System.out.println("Some other error occurred.");
			e.printStackTrace();
			return null;
		}
	}	
	
	public Document getSnapshot(String temporalDocument, String strDate){

		String snapshotSchema=null;
		String temporalAnnotation=null;
		String physicalAnnotation=null;
		Date date;
		
		try{
			SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
			date = sdf.parse(strDate);
		}catch (ParseException pe){
			throw new RuntimeException(pe);
		}

		try{
			/* Parse given temporal document to find out the temporal bundle */
			Document temporalDoc = cp.parseURI(temporalDocument);
			
			/* Extract location of temporal Bundle from given document */
			String strTemporalBundle = temporalDoc.getDocumentElement().getAttribute("bundle");
			if ((null == strTemporalBundle) || ("".equals(strTemporalBundle.trim()))){
				System.out.println("The given document does not have bundle");
				throw new RuntimeException("The given document does not have bundle");
			}
			
			String temporalBundleDir = strTemporalBundle.substring(0,strTemporalBundle.lastIndexOf("/")) + "/";	
			String strRepSchemaDoc = temporalBundleDir + "rep.xsd"; 
			try{
				/* Create representational schema using Schema Mapper. */
				DoSVSchemaMapping doSVSchemaMapping = new DoSVSchemaMapping();
				Document repSchemaDoc; 
				repSchemaDoc = doSVSchemaMapping.createRepresentationalSchema(strTemporalBundle);
				cp.writeDocument(repSchemaDoc, strRepSchemaDoc);
		    }catch (Exception e){
		    	e.printStackTrace();
		    }				
			
		    /* Parse given temporal Document against the rep schema. */
		    temporalDoc = cp.parseDocument(temporalDocument, null,strRepSchemaDoc);

			/* Parse temporal bundle using TBSchema. */
			Document temporalBundleDoc = cp.parseDocument(strTemporalBundle, null, vp.getProperty("TBSchema"));
			NodeList schemaVersions = temporalBundleDoc.getElementsByTagName("schemaAnnotation");
			
			for (int i=0 ; i<schemaVersions.getLength() ; i++){
				snapshotSchema = temporalBundleDir + ((Element)schemaVersions.item(i)).getAttribute("snapshotSchema");
				temporalAnnotation = temporalBundleDir + ((Element)schemaVersions.item(i)).getAttribute("temporalAnnotation");
				physicalAnnotation = temporalBundleDir + ((Element)schemaVersions.item(i)).getAttribute("physicalAnnotation");
				
				Element schemaVersionElement = (Element)temporalDoc.getElementsByTagName("schemaVersion" + i).item(0);
				
				Element temporalRoot = (Element)schemaVersionElement.getElementsByTagName(vp.getProperty("RepSchemaNameAlias") + i + ":temporalRoot").item(0);
				ITimePeriod tp = new TimePeriod(temporalRoot.getAttribute("begin"),temporalRoot.getAttribute("end"));
				
				if ((tp.getBeginDate().equals(date)) || ((tp.getBeginDate().before(date)) && (tp.getEndDate().after(date)))){
					/* For current Time Period, get the snapshotSchema, temporal and physical annotations */
					DoUnSquashing doUnSquashing = new DoUnSquashing(snapshotSchema, temporalAnnotation, physicalAnnotation,i);
					return doUnSquashing.getSnapshot(temporalRoot, strDate);
				}

			}
		}catch(DOMException de){
			System.out.println("Error occurred while parsing given Temporal Document.");
			return null;
		}catch(LSException le){
			System.out.println("Unable to load Temporal Bundle Document.");
			le.printStackTrace();
			return null;
		}catch(Exception e){
			System.out.println("Some other error occurred.");
			e.printStackTrace();
			return null;
		}
		return null;
	}	
}
