/**
 * 
 */
package cs.arizona.tau.xml;

import org.w3c.dom.*;
import org.w3c.dom.ls.*;

import cs.arizona.util.*;

import cs.arizona.tau.time.ITime;
import cs.arizona.tau.time.ITimePeriod;
import cs.arizona.tau.time.TimePeriod;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

/**
 * @author Shailesh Joshi
 *
 */
public class DoSVTemporalValidation implements IDoTemporalValidation{

	private ConventionalParser cp;
	private ValidatorProperties vp;
	private ArrayList schemaItemList = new ArrayList();
	ArrayList itemIdCorrList = null;
	ArrayList scpTimeSpanList = null;
	ArrayList<TargetIdentifier> tiList = null;
	ArrayList<LogicalAnnotationValidator> tavList = null;
	Hashtable itemFragmentItemMap = null;
	
	/**
	 * 
	 */
	public DoSVTemporalValidation() {
		super();
		init();
		// TODO Auto-generated constructor stub
	}
	
	/**
	 * Initializes lsParser and lsSerializer objects to be used later for parsing.
	 */
	private void init(){
		cp = ConventionalParser.getInstance();
		vp = ValidatorProperties.getInstance();
		tiList = new ArrayList<TargetIdentifier>();
		tavList = new ArrayList<LogicalAnnotationValidator>();
		itemFragmentItemMap = new Hashtable();
	}
	
	public boolean validate(String temp_data_dir, String strTemporalDoc){
		
		String snapshotSchema=null;
		String temporalAnnotation=null;
		String physicalAnnotation=null;
		
		Document snapshotSchemaDoc = null;
		Document temporalAnnotationDoc = null;
		Document physicalAnnotationDoc = null;
		
		TargetIdentifier ti;
		LogicalAnnotationValidator tav;
		PhysicalAnnotationValidator pav;
		
		boolean valid = true;
		
		try{
			/* Parse given temporal document to find out the temporal bundle */
			Document temporalDoc = cp.parseURI(strTemporalDoc);
			
			/* Extract location of temporal Bundle from given document */
			String strTemporalBundle = temporalDoc.getDocumentElement().getAttribute("bundle");
			if ((null == strTemporalBundle) || ("".equals(strTemporalBundle.trim()))){
				System.out.println("The given document does not have bundle");
				throw new RuntimeException("The given document does not have bundle");
			}
			String temporalBundleDir = strTemporalBundle.substring(0,strTemporalBundle.lastIndexOf("/")) + "/";	
			String strRepSchemaDoc = temporalBundleDir + "rep.xsd";
			DoSVSchemaMapping doSchemaSchemaMapping = null;
			try{
				/* Create representational schema using Schema Mapper. */
				doSchemaSchemaMapping = new DoSVSchemaMapping();
				Document repSchemaDoc; 
				repSchemaDoc = doSchemaSchemaMapping.createRepresentationalSchema(strTemporalBundle);
				cp.writeDocument(repSchemaDoc, strRepSchemaDoc);
		    }catch (Exception e){
		    	e.printStackTrace();
		    }				

		    itemIdCorrList = doSchemaSchemaMapping.getItemIdentifierCorrList();
		    scpTimeSpanList = doSchemaSchemaMapping.getScpTimeSpanList();
		    
		    /* Parse given temporal Document against the rep schema. */
		    temporalDoc = cp.parseDocument(strTemporalDoc, null,strRepSchemaDoc);

			/* Parse temporal bundle using TBSchema. */
			Document temporalBundleDoc = cp.parseDocument(strTemporalBundle, null, vp.getProperty("TBSchema"));
			NodeList schemaVersions = temporalBundleDoc.getElementsByTagName("schemaAnnotation");
			
			for (int i=0 ; i<schemaVersions.getLength() ; i++){
				
				snapshotSchema = temporalBundleDir + ((Element)schemaVersions.item(i)).getAttribute("snapshotSchema");
				temporalAnnotation = temporalBundleDir + ((Element)schemaVersions.item(i)).getAttribute("temporalAnnotation");
				physicalAnnotation = temporalBundleDir + ((Element)schemaVersions.item(i)).getAttribute("physicalAnnotation");
				
				snapshotSchemaDoc=cp.parseDocument(snapshotSchema, null, vp.getProperty("XMLSchema"));

		        //Initialize SchemaPathEvaluator
		        ti = new TargetIdentifier(snapshotSchemaDoc);
				temporalAnnotationDoc=cp.parseDocument(temporalAnnotation, null, vp.getProperty("TXSchema"));
				physicalAnnotationDoc=cp.parseDocument(physicalAnnotation, null, vp.getProperty("PXSchema"));

				//Validate Temporal and Physical Annotations	
				tav = new LogicalAnnotationValidator(temporalAnnotationDoc,snapshotSchemaDoc,ti,true);
				tav.validateLogicalAnnotation();
				pav = new PhysicalAnnotationValidator(physicalAnnotationDoc,snapshotSchemaDoc,ti,true);
				pav.validatePhysicalAnnotation();
				
				tiList.add(ti);
				tavList.add(tav);
				
				Element schemaVersionElement = (Element)temporalDoc.getElementsByTagName("schemaVersion" + i).item(0);
				
				Element temporalRoot = (Element)schemaVersionElement.getElementsByTagName(vp.getProperty("RepSchemaNameAlias") + i + ":temporalRoot").item(0);
				DoTemporalValidation doTemporalValidation = new DoTemporalValidation(ti, tav, pav, i);

				valid = (valid && doTemporalValidation.validate(temporalRoot));
				Hashtable itemTable = doTemporalValidation.getItemTable();

				/* Bridge the items obtained in this schema constant period with the existing schemaItems */
				bridgeItems(itemTable, i);
			}

			/* Chekck whether every schemaItem is valid or not */
			for (int i=0 ; i<schemaItemList.size(); i++){
				SchemaItem schemaItem = (SchemaItem)schemaItemList.get(i);
				valid = (valid && schemaItem.validate(tiList, tavList, itemFragmentItemMap));
			}
			
			return valid;

		}catch(DOMException de){
			System.out.println("Error occurred while parsing given Temporal Document.");
			return false;
		}catch(LSException le){
			System.out.println("Unable to load Temporal Bundle Document.");
			le.printStackTrace();
			return false;
		}catch(Exception e){
			System.out.println("Some other error occurred.");
			e.printStackTrace();
			return false;
		}
	}
	
	/*
	 * Given the list of items obtained during DataTemporalValidation, try to bridge them
	 * with the existing schemaItems. If can not be bridged with any of the existing schemaItems,
	 * create a new schemaItem and add that to the schemaItemList
	 * 
	 * While bridging, the given item is checked with the previous (numScp-1) contiguous schema constant
	 * period's item of each schemaItem from schemaItemList. If it can be concluded that the item can be
	 * bridged, it is bridged. If not, we try to compare with the (numScp-2)th schema constant period's
	 * item of only those schemaItems for which (numScp-1)th version of item does not exist. If found, it
	 * is bridged and so on till either 1) the item is not bridged OR 2) The first SCP is reached.
	 */
	private void bridgeItems(Hashtable itemTable, int numScp){
		
		Enumeration items = itemTable.elements();
		while (items.hasMoreElements()){
			Item dataItem = (Item)items.nextElement();
			boolean bridged = false;
			/* Get the relation between this dataItem's time span and the time span of the SCP in which it appears.
			 * The overlap should be such that 
			 * |------------------------|	time span of scp
			 * |------------------------| 	time span of data item
			 * 
			 * OR
			 * 
			 * |------------------------|	time span of scp
			 * |-----------| 				time span of data item
			 */
			int newRelation = dataItem.getTemporalElement().getTimeSpan().getRelationship((ITime)scpTimeSpanList.get(numScp));
			if (numScp > 0 && (ITimePeriod.A_EQUALS_B  == newRelation || ITimePeriod.A_STARTS_B == newRelation)){
				for (int j=0 ; j<schemaItemList.size() ; j++){
					SchemaItem schemaItem = (SchemaItem)schemaItemList.get(j);
					Item lastDataItemFragment = schemaItem.getItemFragment(numScp - 1);
					/* If the item Fragment in the previous numScp does not exist */
					if (null == lastDataItemFragment){
						continue;
					}

					/* Get the relation between this dataItem's time span and the time span of the SCP in which it appears.
					 * The overlap should be such that 
					 * |------------------------|	time span of scp
					 * |------------------------| 	time span of data item
					 * 
					 * OR
					 * 
					 * |------------------------|	time span of scp
					 *            |-------------| 	time span of data item
					 */
					
					int oldRelation = lastDataItemFragment.getTemporalElement().getTimeSpan().getRelationship((ITime)scpTimeSpanList.get(numScp -1));
					if (ITimePeriod.A_EQUALS_B  == oldRelation || ITimePeriod.A_FINISHES_B == oldRelation){
						if (schemaItem.canBeBridged(dataItem, itemIdCorrList, numScp)){
							schemaItem.addItem(dataItem, numScp);
							itemFragmentItemMap.put(dataItem, schemaItem);			/* Put a reverse mapping from dataItem to schemaItem required in cross-wall validation */
							bridged = true;
							break;
						}
					}
				}
			}
			
			/* 
			 * As per the new scheme, a new XML file will be provided for specifiying the explicit mapping of ItemFragments
			 * from new Scp's with the items from old Scp's. Check whether this item exists in that mapping file.
			 * If it does, then add that Item Fragment to the Item, otherwise add it as a new item.
			 * 
			 *  The function below will take care of that in future, although its not been implemented yet.
			 */

			if (!bridged){
				bridged = bridged && bridgeFromMappingFile(dataItem);
			}
			
			/* 
			 * If no mapping for the item fragment is found by above 2 methods, the item fragment is added as a new item.
			 */
			if (!bridged){
				SchemaItem schemaItem = new SchemaItem();
				schemaItem.addItem(dataItem, numScp);
				schemaItemList.add(schemaItem);
				itemFragmentItemMap.put(dataItem, schemaItem);			/* Put a reverse mapping from dataItem to schemaItem required in cross-wall validation */
			}
		}
	}
	
	/*
	 * As per the new scheme discussed during the meeting with Rick, Curtis and Faiz, a new XML file will be provided for specifiying 
	 * the explicit mapping of ItemFragments from new Scp's with the items from old Scp's. Check whether this item exists in that mapping file.
	 * If it does, then add that Item Fragment to the Item, otherwise add it as a new item.
	 * 
	 * This function will take care of that functionality. 
	 * 
	 * TODO: The mapping file format is not yet decided. Once decided, the file will be parsed earlier and referred
	 * everything this function is called.
	 */
	private boolean bridgeFromMappingFile(Item dataItem){
		return false;	
	}
}
