/**
 * 
 */
package cs.arizona.tau.xml;

import org.w3c.dom.*;
import org.w3c.dom.ls.*;

import cs.arizona.tau.time.*;

import cs.arizona.util.*;

/**
 * @author Shailesh Joshi
 *
 */
public class DoSVSquashing implements IDoSquashing{

	private NodeList snapshotElementList; 
	private String mOutputFileName = "squashed.xml";
	
	ConventionalParser cp;
	ValidatorProperties vp;
	/**
	 * 
	 */
	public DoSVSquashing() {
		init();
		// TODO Auto-generated constructor stub
	}
	
	/**
	 * Initializes lsParser and lsSerializer objects to be used later for parsing.
	 */
	private void init(){
		cp = ConventionalParser.getInstance();
		vp = ValidatorProperties.getInstance();
	}
	
	public void setOutputFileName(String tempDataDir, String name){
		mOutputFileName = name;
	}

	/**
	 * @param temporalBundle
	 * @return
	 */
	public Document squash(String tempDataDir, String configFile){

		String temporalBundle;
		String snapshotSchema;
		String temporalAnnotation;
		String physicalAnnotation;
		
		String configDir, temporalBundleDir;
		
		String beginDate, endDate ="";
		
		Document temporalDoc = null;	//Document element for temporal document.
		Document bundleDoc = null;
		Document configDoc = null;
		
		/* Find out the configDir required to locate snapshot document */
		configDir = configFile.substring(0,configFile.lastIndexOf("/")) + "/";
		
		configDoc = cp.parseDocument(configFile, null, vp.getProperty("ConfigSchema"));
		
		/* Get temporal bundle directory to locate snapshotSchema, temporal annotation and physical annotation */
		temporalBundle = configDir + configDoc.getDocumentElement().getAttribute("bundle");
		temporalBundleDir = temporalBundle.substring(0,temporalBundle.lastIndexOf("/")) + "/";

		/* Create sv_root element, which is the document root of schema varying XML document */
		temporalDoc = cp.createDocument(vp.getProperty("RepSchemaURL"),vp.getProperty("RepSchemaNameAlias") + ":sv_root",null);
		Element rootElement = temporalDoc.getDocumentElement();
		
        rootElement.setAttribute("xmlns:tv", vp.getProperty("TVSchemaURL"));
    	//rootElement.setAttribute("xmlns:" + vp.getProperty("RepSchemaNameAlias"), vp.getProperty("RepSchemaURL"));
		
		rootElement.setAttribute("bundle", temporalBundle);
		
		/* Create schemaItem element, which encompasses all the schema version elements within it */
		Element schemaItemElement = temporalDoc.createElement("schemaItem");
		temporalDoc.getDocumentElement().appendChild(schemaItemElement);
		
		/* Store the list of all the snapshot element list present in the configFile. It is required by function get SchemaConstantPeriodConfigRoot */
		snapshotElementList = configDoc.getElementsByTagName("snapshot");
		
		try {
			bundleDoc = cp.parseDocument(temporalBundle, null, vp.getProperty("TBSchema"));
			NodeList schemaAnnotationNodes=bundleDoc.getElementsByTagName("schemaAnnotation");
			
			for (int i=0 ; i<schemaAnnotationNodes.getLength() ; i++){
				Element currElement = (Element)schemaAnnotationNodes.item(i);
				beginDate = currElement.getElementsByTagName("tTime").item(0).getChildNodes().item(0).getNodeValue();
				if (i+1 < schemaAnnotationNodes.getLength()){	
					Element nextElement = (Element)schemaAnnotationNodes.item(i+1);
					endDate = nextElement.getElementsByTagName("tTime").item(0).getChildNodes().item(0).getNodeValue();
				}else{
					endDate = "9999-12-31";
				}

				/* Get an element, which has all the config elements falling in the range beginDate and endDate as its child elements
				 * It is passed to doDataSquashing, which squashes them and returns corresponding temporal document for that schema constant period.
				 */
				Element schemaConstantPeriodConfigRoot = getSchemaConstantPeriodConfigRoot(configDoc, beginDate, endDate);

				/* Create schemaVersion element */
				Element schemaVersion = temporalDoc.createElement("schemaVersion" + i);
				
				/* Create timePeriod element and append it as a child lf schemaVersion element */
				Element timePeriodElement = temporalDoc.createElement(vp.getProperty("TVSchemaNameAlias") + "timestamp_TransExtent");
				timePeriodElement.setAttribute("begin", beginDate);
				timePeriodElement.setAttribute("end", endDate);
				schemaVersion.appendChild(timePeriodElement);
				
				/* Create dataVaryingTemporalElement and append it as child of schemaVersion element */
				snapshotSchema = temporalBundleDir + currElement.getAttribute("snapshotSchema");
				temporalAnnotation = temporalBundleDir + currElement.getAttribute("temporalAnnotation");
				physicalAnnotation = temporalBundleDir + currElement.getAttribute("physicalAnnotation");
				
				DoSquashing doSquashing = new DoSquashing(snapshotSchema, temporalAnnotation, i);
				Document dataVaryingTemporalDoc = doSquashing.squash(tempDataDir, configDir, schemaConstantPeriodConfigRoot);
				Element temporalRootElement = (Element)temporalDoc.importNode(dataVaryingTemporalDoc.getDocumentElement(),true);

				schemaVersion.appendChild(temporalRootElement);
				schemaItemElement.appendChild(schemaVersion);
				
				rootElement.setAttribute("xmlns:rep" + i, vp.getProperty("RepSchemaURL") + i);
			}
			return temporalDoc;
		}catch(DOMException de){
			System.out.println("Error occurred while parsing Temporal Bundle Document.");
			return null;
		}catch(LSException le){
			System.out.println("Unable to load Temporal Bundle Document.");
			le.printStackTrace();
			return null;
		}catch(Exception e){
			System.out.println("Some other error occurred.");
			e.printStackTrace();
			return null;
		}
	}
	
	private Element getSchemaConstantPeriodConfigRoot(Document doc, String strBeginDate, String strEndDate){
		Element root = doc.createElement("config");
		try{
			ITimePeriod tp = new TimePeriod(strBeginDate, strEndDate);
			for (int i=0 ; i<snapshotElementList.getLength() ; i++){
				String currBeginDate = ((Element)snapshotElementList.item(i)).getAttribute("beginDate");
				String currEndDate = ((Element)snapshotElementList.item(i)).getAttribute("endDate");
				ITimePeriod currTP = new TimePeriod(currBeginDate, currEndDate);
				int relation = currTP.getRelationship(tp);
				if ((ITimePeriod.A_EQUALS_B == relation) ||
					(ITimePeriod.A_DURING_B == relation) ||
					 (ITimePeriod.A_STARTS_B == relation) ||
					  (ITimePeriod.A_FINISHES_B == relation) ||
					   (ITimePeriod.A_DURING_B == relation)){
					
					root.appendChild(snapshotElementList.item(i).cloneNode(true));
				}
			}
			return root;
		}catch(Exception e){
			System.out.println("Some other error occurred.");
		}
		return null;
	}
}
