/**
 * 
 */
package cs.arizona.tau.xml;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import cs.arizona.util.ConventionalParser;
import cs.arizona.util.ValidatorProperties;

/**
 * @author shailesh
 * TODO: Convert all methods to new format. creatSquashingObj is done.
 */
public class DecomposedRepresentationFactory implements IRepresentationFactory {
	public IDoSchemaMapping createSchemaMappingObj(String dataFile, boolean schemaVersioningFlag){
		if (true == schemaVersioningFlag){
			return new DoSVSchemaMapping();
		}else{
			return new DoSchemaMapping();
		}
	}
	
	public IDoSquashing createSquashingObj(String tempDataDir, String tempDataFile, boolean schemaVersioningFlag){
		
		if (true == schemaVersioningFlag){
			return new DoSVSquashing();
		}else {
			String strTemporalSchema = tempDataDir + "/" + getTemporalSchema(tempDataDir + "/" + tempDataFile);
			if (null == strTemporalSchema || "".equals(strTemporalSchema)){
				System.out.println("Passed temporal data file does not specify the temporal schema. Please provide correct file.");
			}
			//return new DoSquashingEditBased(strTemporalBundle, -1); // TODO
			return new DoSquashing(strTemporalSchema, -1);
		}
	}
	
	public IDoUnSquashing createUnSquashingObj(String tempDataDir, String dataFile, boolean schemaVersioningFlag){
		if (true == schemaVersioningFlag){
			return new DoSVUnSquashing();
		}else{
			String strTemporalBundle = tempDataDir + "/" + getTemporalSchema(tempDataDir + "/" + dataFile);
			if (null == strTemporalBundle || "".equals(strTemporalBundle)){
				System.out.println("Passed config file does not specify the temporal bundle. Please provide correct configuration file.");
			}
			return new DoUnSquashing(strTemporalBundle, -1);
		}
	}
	
	public IDoTemporalValidation createTemporalValidationObj(String temp_data_dir, String dataFile, boolean schemaVersioningFlag){
		if (true == schemaVersioningFlag){
			return new DoSVTemporalValidation();
		}else{
			String strTemporalBundle = temp_data_dir + "/" + getTemporalSchema(temp_data_dir + "/" + dataFile);
			if (null == strTemporalBundle || "".equals(strTemporalBundle)){
				System.out.println("Passed config file does not specify the temporal bundle. Please provide correct configuration file.");
			}
			return new DoTemporalValidation(strTemporalBundle, -1);
		}
	}
	
	private String getTemporalSchema(String tempDataFile){
		ValidatorProperties vp = ValidatorProperties.getInstance();
		ConventionalParser cp = ConventionalParser.getInstance();
		Document temporalDoc = null;

		temporalDoc = cp.parseDocument(tempDataFile, null, vp.getProperty("TDSchema"), false);
		
		Element temporalRoot = temporalDoc.getDocumentElement();
		Node tempSchemaSet = temporalRoot.getElementsByTagName("temporalSchemaSet").item(0);
		NodeList schemas = tempSchemaSet.getChildNodes();
		for(int i = 0; i < schemas.getLength(); i++) {
			if(Common.isElement(schemas.item(i))) {
				Element schema = (Element) schemas.item(i);
				return schema.getAttribute("schemaLocation");
			}
		}
		return null;
		/** TODO: Allow for several Temporal Schemas */
	}
}
