package cs.arizona.tau.time;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

/**
 * 
 * 
 * @author Alex Henniges (henniges@email.arizona.edu)
 *
 * @param <E> The type of object to store within the TemporalMap.
 * 
 * @TODO Provide the proper functionality when Periods overlap.
 */
public class TemporalMap<E> implements ITemporalMap<E>{
	
	private Period periodMap(Date date) {
		Set<Period> keySet = temporalMap.keySet();
		Iterator<Period> iter = keySet.iterator();
		while(iter.hasNext()) {
			Period next = iter.next();
			// If period contains instant...
			if(next.contains(date)) {
				return next;
			}	
		}
		return null;
	}
	
	private HashMap<Period, E> temporalMap;
	Set<Period> keySet;
	
	
	public TemporalMap() {
		this.temporalMap = new HashMap<Period, E>();
		keySet = temporalMap.keySet();
	}
	
	public void add(Period key, E value) {
		temporalMap.put(key, value);
		keySet = temporalMap.keySet();
	}

	
	public E get(Date b) {
		Period key = periodMap(b);
		
		return temporalMap.get(key);
	}

	public E get(Period p) {
		return temporalMap.get(p);
	}

	
	public Set<Period> getKeys() {
		return temporalMap.keySet();
	}
	
	public static void main(String[] args) {
		DateFormat df = DateFormat.getDateInstance(DateFormat.MEDIUM);
		Date d1 = null;
		Date d2 = null;
		Date d3 = null;
		Date d4 = null;
		Date test1 = null;
		Date test2 = null;
		Date test3 = null;
		Period p1  = null;
		Period p2  = null;
		Period p3  = null;
		try {
			d1 = df.parse("January 1, 2009");
			d2 = df.parse("March 1, 2009");
			d3 = df.parse("August 1, 2009");
			d4 = df.parse("December 31, 2009");
			test1 = df.parse("February 1, 2009");
			test2 = df.parse("April 9, 2009");
			p1 = new Period("2009-01-01", "2009-03-01");
			p2 = new Period("2009-03-01", "2009-08-01");
			p3 = new Period("2009-08-01", "2009-12-31");
		} catch (ParseException e) {
			e.printStackTrace();
		}
		

		
		TemporalMap<String> scpList = new TemporalMap<String>();
		
		scpList.add(p1, "Hello");
		scpList.add(p2, "World");
		scpList.add(p3, "I'm awesome");
		
		System.out.println("SCPList at " + df.format(test1) + ": " + scpList.get(test1));
		System.out.println("SCPList at " + df.format(test2) + ": " + scpList.get(test2));
	}
}
