/**
 * 
 */
package cs.arizona.tau.time;

import java.util.Collection;
import java.util.Iterator;
import java.util.ArrayList;
import java.util.Date;

/**
 * @author spjoshi
 *
 */
public class TemporalElement implements ITemporalElement {

	ArrayList times = new ArrayList();
	int numDimensions = 1;
	/**
	 * 
	 */
	public TemporalElement() {
		super();
		// TODO Auto-generated constructor stub
	}
	
	public Iterator iterator(){
		return times.iterator();
	}
	
	public int getNumDimensions(){
		return numDimensions;
	}
	
	public void setNumDimensions(int numDimensions){
		this.numDimensions = numDimensions;
	}

	public void add(ITime o){
		times.add(o);
	}
	
	public void addAll(Collection c){
		Iterator itr = c.iterator();
		while (itr.hasNext()){
			times.add(((ITime)itr.next()).cloneTime());
		}
	}
	
	public void clear(){
		times.clear();
	}
	
	public ITime getTimeSpan(){
		ITimePeriod timeSpanPeriod = new TimePeriod();
		if (numDimensions==1){
			timeSpanPeriod.setBeginDate(((ITimePeriod)times.get(0)).getBeginDate());
			timeSpanPeriod.setEndDate(((ITimePeriod)times.get(times.size()-1)).getEndDate());
		}
		return timeSpanPeriod;
	}
	
	public ITemporalElement cloneElement(){
		ITemporalElement te = new TemporalElement();
		te.setNumDimensions(this.getNumDimensions());
		te.addAll(times);
		return te;
	}
	
	public boolean remove(ITime t){
		return times.remove(t);
	}
	
	public ITime get(int index){
		return (ITime)times.get(index);
	}
	
	public void swap(int ind1, int ind2){
		Object o = times.get(ind1);
		times.set(ind2,times.get(ind1));
		times.set(ind1,o);
	}
	
	public Collection getAll(){
		return times;
	}
}
