/**
 * 
 */
package cs.arizona.tau.time;

import java.util.Iterator;

/**
 * @author spjoshi
 *
 */
public interface ITemporalRegion extends ITime{

	public static int TRANSACTION_TIME = 1;
	public static int VALID_TIME = 2;
	public static int BITEMPORAL_TIME = 3;

	public int getNumDimensions();
	public ITimePeriod getValidPeriod();
	public ITimePeriod getTransactionPeriod();
	public void setValidPeriod(ITimePeriod validPeriod);
	public void setTransactionPeriod(ITimePeriod transactionPeriod);
	public boolean overlap(ITemporalRegion tr);
	public boolean isEqual(ITemporalRegion tr);
	public Iterator split(ITemporalRegion tr);
	public String getInterfaceName();
	public int getRelationship(ITime time1); 
}
