package cs.arizona.tau.docs;

import java.util.LinkedList;
import java.util.List;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import cs.arizona.tau.xml.Common;
import cs.arizona.util.*;

public class ConventionalSchema {
  private Document conventional_schema_doc_;
  private List<Pair<Element, ConventionalSchema>>  imports;
  
  public ConventionalSchema(String conventional_schema_doc_name) {
    ValidatorProperties vp = ValidatorProperties.getInstance();
    ConventionalParser cp = ConventionalParser.getInstance();
    
    conventional_schema_doc_ = cp.parseDocument(
        conventional_schema_doc_name, null,
        vp.getProperty("XMLSchema"), false);
    
    imports = new LinkedList<Pair<Element, ConventionalSchema>>();
    
    NodeList nl = conventional_schema_doc_.getElementsByTagName("import");
    Node n;
    for(int i = 0; i < nl.getLength(); i++) {
      n = nl.item(i);
      if(Common.isElement(n)) {
        Element e = (Element) n;
        String schemaLocation = e.getAttribute("schemaLocation");
        imports.add(new Pair<Element, ConventionalSchema>(
            e, new ConventionalSchema(schemaLocation)));
      }
    }
  }
  
  public List<Pair<Element, ConventionalSchema>> getImports() {
    return imports;
  }
  
  public Document GetConventionalSchemaDocument() {
    return conventional_schema_doc_;
  }
}
