----------------------------------------------------------------
-- Q8:
--   Return the publisher of an item with id attribute
--   value (I4).
-- Feature:
--   Loop name with FOR statement
----------------------------------------------------------------
CREATE FUNCTION perstmt_get_publisher_id_by_item_id(item_id_in CHARACTER(10),
                                                    begin_time_in DATE,
                                                    end_time_in DATE)
  RETURNS ROW (taupsm_result CHARACTER(10),
               begin_time DATE,
               end_time DATE) ARRAY
  READS SQL DATA
  LANGUAGE SQL
  BEGIN
    DECLARE return_tbl ROW (taupsm_result CHARACTER(10),
                            begin_time DATE,
                            end_time DATE) ARRAY;
    FOR related AS
      SELECT i.item_id, i.publisher_id,
          LAST_INSTANCE(i.begin_time, begin_time_in) AS begin_time,
          FIRST_INSTANCE(i.end_time, end_time_in) AS end_time
        FROM item i
        WHERE LAST_INSTANCE(i.begin_time, begin_time_in) <
            FIRST_INSTANCE(i.end_time, end_time_in) 
    DO
      IF related.item_id = item_id_in
      THEN
        INSERT INTO return_tbl VALUES (related.publisher_id,
                                       related.begin_time,
                                       related.end_time);
      END IF;
    END FOR;
    RETURN return_tbl;
  END;

SELECT p.*,
    LAST_INSTANCE(p.begin_time, t.begin_time) AS begin_time,
    FIRST_INSTANCE(p.end_time, t.end_time) AS end_time
  FROM publisher p,
    perstmt_get_publisher_id_by_item_id('I4', p.begin_time, p.end_time) t
  WHERE p.publisher_id = t.taupsm_result AND
    LAST_INSTANCE(p.begin_time, t.begin_time) <
        FIRST_INSTANCE(p.end_time, t.end_time);

